/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.c.InvokeJavaFunctionPointer;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.Reflection;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public final class ClassInitializationInfo {
    private static final ClassInitializationInfo NO_INITIALIZER_NO_TRACKING = new ClassInitializationInfo(InitState.FullyInitialized, false, true, false);
    private static final ClassInitializationInfo INITIALIZED_NO_TRACKING = new ClassInitializationInfo(InitState.FullyInitialized, true, true, false);
    private static final ClassInitializationInfo FAILED_NO_TRACKING = new ClassInitializationInfo(InitState.InitializationError, false);
    private final FunctionPointerHolder classInitializer;
    private TypeReached typeReached;
    private InitState initState;
    private boolean slowPathRequired;
    private IsolateThread initThread;
    private final ReentrantLock initLock;
    private Condition initCondition;
    private boolean hasInitializer;
    private boolean buildTimeInitialized;

    public static ClassInitializationInfo forFailedInfo(boolean typeReachedTracked) {
        if (typeReachedTracked) {
            return new ClassInitializationInfo(InitState.InitializationError, typeReachedTracked);
        }
        return FAILED_NO_TRACKING;
    }

    public static ClassInitializationInfo forNoInitializerInfo(boolean typeReachedTracked) {
        if (typeReachedTracked) {
            return new ClassInitializationInfo(InitState.FullyInitialized, false, true, typeReachedTracked);
        }
        return NO_INITIALIZER_NO_TRACKING;
    }

    public static ClassInitializationInfo forInitializedInfo(boolean typeReachedTracked) {
        if (typeReachedTracked) {
            return new ClassInitializationInfo(InitState.FullyInitialized, true, true, typeReachedTracked);
        }
        return INITIALIZED_NO_TRACKING;
    }

    public boolean requiresSlowPath() {
        return this.slowPathRequired;
    }

    public boolean isTypeReached(DynamicHub caller) {
        assert (this.typeReached != TypeReached.UNTRACKED) : "We should never emit a check for untracked types as this was known at build time: " + caller.getName();
        return this.typeReached == TypeReached.REACHED;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public TypeReached getTypeReached() {
        return this.typeReached;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setTypeReached() {
        VMError.guarantee(this.typeReached != TypeReached.UNTRACKED, "Must not modify untracked types as nodes for checks have already been omitted.");
        this.typeReached = TypeReached.REACHED;
        this.slowPathRequired = this.initState != InitState.FullyInitialized;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassInitializationInfo(InitState initState, boolean hasInitializer, boolean buildTimeInitialized, boolean typeReachedTracked) {
        this(initState, typeReachedTracked);
        this.hasInitializer = hasInitializer;
        this.buildTimeInitialized = buildTimeInitialized;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassInitializationInfo(InitState initState, boolean typeReachedTracked) {
        this.classInitializer = null;
        this.typeReached = typeReachedTracked ? TypeReached.NOT_REACHED : TypeReached.UNTRACKED;
        this.initState = initState;
        this.slowPathRequired = this.typeReached != TypeReached.UNTRACKED || initState != InitState.FullyInitialized;
        this.initLock = initState == InitState.FullyInitialized ? null : new ReentrantLock();
        this.hasInitializer = true;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ClassInitializationInfo(CFunctionPointer classInitializer, boolean typeReachedTracked) {
        this.classInitializer = classInitializer == null || classInitializer.isNull() ? null : new FunctionPointerHolder(classInitializer);
        this.initState = InitState.Linked;
        this.typeReached = typeReachedTracked ? TypeReached.NOT_REACHED : TypeReached.UNTRACKED;
        this.slowPathRequired = true;
        this.initLock = new ReentrantLock();
        this.hasInitializer = classInitializer != null;
    }

    public boolean hasInitializer() {
        return this.hasInitializer;
    }

    public boolean isInitialized() {
        return this.initState == InitState.FullyInitialized;
    }

    public boolean isInitializationError() {
        return this.initState == InitState.InitializationError;
    }

    public boolean isBuildTimeInitialized() {
        return this.buildTimeInitialized;
    }

    private boolean isBeingInitialized() {
        return this.initState == InitState.BeingInitialized;
    }

    private boolean isInErrorState() {
        return this.initState == InitState.InitializationError;
    }

    private boolean isReentrantInitialization(IsolateThread thread) {
        return thread.equal((ComparableWord)this.initThread);
    }

    private static void markReached(DynamicHub hub) {
        DynamicHub current = hub;
        do {
            ClassInitializationInfo clinitInfo = current.getClassInitializationInfo();
            if (clinitInfo.typeReached == TypeReached.UNTRACKED) break;
            clinitInfo.typeReached = TypeReached.REACHED;
            if (clinitInfo.isInitialized()) {
                clinitInfo.slowPathRequired = false;
            }
            ClassInitializationInfo.reachInterfaces(current);
        } while ((current = current.getSuperHub()) != null);
    }

    private static void reachInterfaces(DynamicHub hub) {
        for (DynamicHub superInterface : hub.getInterfaces()) {
            if (superInterface.getClassInitializationInfo().typeReached == TypeReached.REACHED) {
                return;
            }
            if (hub.getClassInitializationInfo().typeReached != TypeReached.UNTRACKED) {
                superInterface.getClassInitializationInfo().typeReached = TypeReached.REACHED;
            }
            ClassInitializationInfo.reachInterfaces(superInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void slowPath(ClassInitializationInfo info, DynamicHub hub) {
        Class<?> callerClass;
        IsolateThread self = CurrentIsolate.getCurrentThread();
        ClassInitializationInfo.markReached(hub);
        if (info.isInitialized()) {
            return;
        }
        if (!hub.isLoaded() && DynamicHub.fromClass(callerClass = Reflection.getCallerClass()).isLoaded()) {
            PredefinedClassesSupport.loadClassIfNotLoaded(callerClass.getClassLoader(), null, DynamicHub.toClass(hub));
        }
        info.initLock.lock();
        try {
            while (info.isBeingInitialized() && !info.isReentrantInitialization(self)) {
                if (info.initCondition == null) {
                    info.initCondition = info.initLock.newCondition();
                }
                info.initCondition.awaitUninterruptibly();
            }
            if (info.isBeingInitialized() && info.isReentrantInitialization(self)) {
                return;
            }
            if (info.isInitialized()) {
                return;
            }
            if (info.isInErrorState()) {
                throw new NoClassDefFoundError("Could not initialize class " + hub.getName());
            }
            info.initState = InitState.BeingInitialized;
            info.initThread = self;
        }
        finally {
            info.initLock.unlock();
        }
        boolean pinned = false;
        if (ContinuationSupport.isSupported() && JavaThreads.isCurrentThreadVirtual()) {
            Target_jdk_internal_vm_Continuation.pin();
            pinned = true;
        }
        try {
            ClassInitializationInfo.doInitialize(info, hub);
        }
        finally {
            if (pinned) {
                Target_jdk_internal_vm_Continuation.unpin();
            }
        }
    }

    private static void doInitialize(ClassInitializationInfo info, DynamicHub hub) {
        if (!hub.isInterface()) {
            try {
                if (hub.getSuperHub() != null) {
                    hub.getSuperHub().ensureInitialized();
                }
                if (hub.hasDefaultMethods()) {
                    ClassInitializationInfo.initializeSuperInterfaces(hub);
                }
            }
            catch (Throwable ex) {
                info.setInitializationStateAndNotify(InitState.InitializationError);
                throw ex;
            }
        }
        Throwable exception = null;
        try {
            info.invokeClassInitializer(hub);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            if (!(exception instanceof Error)) {
                exception = new ExceptionInInitializerError(exception);
            }
            info.setInitializationStateAndNotify(InitState.InitializationError);
            throw (Error)exception;
        }
        info.setInitializationStateAndNotify(InitState.FullyInitialized);
    }

    private static void initializeSuperInterfaces(DynamicHub hub) {
        assert (hub.hasDefaultMethods()) : "caller should have checked this";
        for (DynamicHub iface : hub.getInterfaces()) {
            if (iface.hasDefaultMethods()) {
                ClassInitializationInfo.initializeSuperInterfaces(iface);
            }
            if (!iface.declaresDefaultMethods()) continue;
            iface.ensureInitialized();
        }
    }

    private void setInitializationStateAndNotify(InitState state) {
        this.initLock.lock();
        try {
            this.initState = state;
            if (this.initState == InitState.FullyInitialized) {
                this.slowPathRequired = false;
            }
            this.initThread = (IsolateThread)WordFactory.nullPointer();
            Unsafe.getUnsafe().storeFence();
            if (this.initCondition != null) {
                this.initCondition.signalAll();
                this.initCondition = null;
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void invokeClassInitializer(DynamicHub hub) {
        if (this.classInitializer != null) {
            ClassInitializerFunctionPointer functionPointer = (ClassInitializerFunctionPointer)this.classInitializer.functionPointer;
            if (functionPointer.isNull()) {
                throw ClassInitializationInfo.invokeClassInitializerError(hub);
            }
            functionPointer.invoke();
        }
    }

    private static RuntimeException invokeClassInitializerError(DynamicHub hub) {
        throw VMError.shouldNotReachHere("No classInitializer.functionPointer for class " + hub.getName());
    }

    static enum InitState {
        Linked,
        BeingInitialized,
        FullyInitialized,
        InitializationError;

    }

    public static enum TypeReached {
        NOT_REACHED,
        REACHED,
        UNTRACKED;

    }

    static interface ClassInitializerFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public void invoke();
    }
}

