/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ReachabilityAnalysisType
extends AnalysisType {
    private final Set<ReachabilityAnalysisType> instantiatedSubtypes = ConcurrentHashMap.newKeySet();
    private final Set<ReachabilityAnalysisMethod> invokedVirtualMethods = ConcurrentHashMap.newKeySet();
    private final Set<ReachabilityAnalysisMethod> invokedSpecialMethods = ConcurrentHashMap.newKeySet();

    public ReachabilityAnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType, AnalysisType cloneableType) {
        super(universe, javaType, storageKind, objectType, cloneableType);
    }

    protected void onInstantiated() {
        this.forAllSuperTypes(t -> ((ReachabilityAnalysisType)t).instantiatedSubtypes.add(this));
    }

    public Set<ReachabilityAnalysisType> getInstantiatedSubtypes() {
        return this.instantiatedSubtypes;
    }

    public Set<ReachabilityAnalysisMethod> getInvokedVirtualMethods() {
        return this.invokedVirtualMethods;
    }

    public void addInvokedVirtualMethod(ReachabilityAnalysisMethod method) {
        this.invokedVirtualMethods.add(method);
    }

    public void addSpecialInvokedMethod(ReachabilityAnalysisMethod method) {
        this.invokedSpecialMethods.add(method);
    }

    public Set<ReachabilityAnalysisMethod> getInvokedSpecialMethods() {
        return this.invokedSpecialMethods;
    }

    public ReachabilityAnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return (ReachabilityAnalysisMethod)super.resolveConcreteMethod(method, callerType);
    }
}

