/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.ClassInclusionPolicy;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.heap.TypedConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class ReachabilityAnalysisEngine
extends AbstractAnalysisEngine {
    private final Timer reachabilityTimer;
    private final Set<AnalysisType> allInstantiatedTypes;
    private final ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler;

    public ReachabilityAnalysisEngine(OptionValues options, AnalysisUniverse universe, HostVM hostVM, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, UnsupportedFeatures unsupportedFeatures, DebugContext debugContext, TimerCollection timerCollection, ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler, ClassInclusionPolicy classInclusionPolicy) {
        super(options, universe, hostVM, metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, unsupportedFeatures, debugContext, timerCollection, classInclusionPolicy);
        this.executor.init(this.getTiming());
        this.reachabilityTimer = timerCollection.createTimer("(reachability)");
        ReachabilityAnalysisType objectType = (ReachabilityAnalysisType)metaAccess.lookupJavaType(Object.class);
        this.allInstantiatedTypes = Collections.unmodifiableSet(objectType.getInstantiatedSubtypes());
        this.reachabilityMethodProcessingHandler = reachabilityMethodProcessingHandler;
    }

    protected CompletionExecutor.Timing getTiming() {
        return null;
    }

    public AnalysisType addRootClass(Class<?> clazz, boolean addFields, boolean addArrayClass) {
        AnalysisType type = this.metaAccess.lookupJavaType(clazz);
        return this.addRootClass(type, addFields, addArrayClass);
    }

    public AnalysisMethod addRootMethod(Executable method, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        return this.addRootMethod(this.metaAccess.lookupJavaMethod(method), invokeSpecial, reason, otherRoots);
    }

    public AnalysisMethod forcedAddRootMethod(Executable method, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        return this.addRootMethod(method, invokeSpecial, reason, otherRoots);
    }

    public AnalysisType addRootClass(AnalysisType type, boolean addFields, boolean addArrayClass) {
        type.registerAsReachable((Object)"root class");
        for (ResolvedJavaField javaField : type.getInstanceFields(false)) {
            AnalysisField field = (AnalysisField)javaField;
            if (!addFields) continue;
            field.registerAsAccessed((Object)"field of root class");
        }
        if (type.getSuperclass() != null) {
            this.addRootClass(type.getSuperclass(), addFields, addArrayClass);
        }
        if (addArrayClass) {
            this.addRootClass(type.getArrayClass(), false, false);
        }
        return type;
    }

    public AnalysisType addRootField(Class<?> clazz, String fieldName) {
        AnalysisType type = this.addRootClass(clazz, false, false);
        for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
            AnalysisField field = (AnalysisField)javaField;
            if (!field.getName().equals(fieldName)) continue;
            field.registerAsAccessed((Object)"root field");
            return field.getType();
        }
        throw AnalysisError.userError((String)("Field not found: " + fieldName));
    }

    public AnalysisType addRootField(Field field) {
        AnalysisField analysisField = this.getMetaAccess().lookupJavaField(field);
        analysisField.registerAsAccessed((Object)"root field");
        return analysisField.getType();
    }

    public AnalysisMethod addRootMethod(AnalysisMethod m, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        assert (otherRoots.length == 0) : otherRoots;
        ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)m;
        if (m.isStatic()) {
            this.postTask(() -> {
                if (method.registerAsDirectRootMethod(reason)) {
                    this.markMethodImplementationInvoked(method, reason);
                }
            });
        } else if (invokeSpecial) {
            AnalysisError.guarantee((!method.isAbstract() ? 1 : 0) != 0, (String)"Abstract methods cannot be registered as special invoke entry point.", (Object[])new Object[0]);
            this.postTask(() -> {
                if (method.registerAsDirectRootMethod(reason)) {
                    this.markMethodImplementationInvoked(method, reason);
                }
            });
        } else {
            this.postTask(() -> {
                if (method.registerAsVirtualRootMethod(reason)) {
                    this.markMethodInvoked(method, reason);
                }
            });
        }
        return method;
    }

    public void markMethodImplementationInvoked(ReachabilityAnalysisMethod method, Object reason) {
        if (!method.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        if (!method.registerAsImplementationInvoked(reason)) {
            return;
        }
        this.schedule(() -> this.onMethodImplementationInvoked(method));
    }

    private void onMethodImplementationInvoked(ReachabilityAnalysisMethod method) {
        try {
            this.reachabilityMethodProcessingHandler.onMethodReachable(this, method);
        }
        catch (Throwable ex) {
            this.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), (AnalysisMethod)method, ex.getLocalizedMessage(), null, ex);
        }
    }

    public void markMethodSpecialInvoked(ReachabilityAnalysisMethod targetMethod, Object reason) {
        ReachabilityAnalysisType declaringClass = targetMethod.getDeclaringClass();
        declaringClass.addSpecialInvokedMethod(targetMethod);
        if (!declaringClass.getInstantiatedSubtypes().isEmpty()) {
            this.markMethodImplementationInvoked(targetMethod, reason);
        }
    }

    protected void schedule(Runnable task) {
        super.schedule(task);
    }

    public void handleEmbeddedConstant(ReachabilityAnalysisMethod method, JavaConstant constant, Object reason) {
        if (constant.getJavaKind() == JavaKind.Object && constant.isNonNull()) {
            BytecodePosition position = new BytecodePosition(null, (ResolvedJavaMethod)method, 0);
            this.getUniverse().registerEmbeddedRoot(constant, position);
            AnalysisType type = ((TypedConstant)constant).getType();
            type.registerAsInstantiated(reason);
        }
    }

    private void onMethodInvoked(ReachabilityAnalysisMethod method, Object reason) {
        ReachabilityAnalysisType clazz = method.getDeclaringClass();
        if (method.isStatic()) {
            this.markMethodImplementationInvoked(method, reason);
            return;
        }
        Set<ReachabilityAnalysisType> instantiatedSubtypes = clazz.getInstantiatedSubtypes();
        for (ReachabilityAnalysisType subtype : instantiatedSubtypes) {
            ReachabilityAnalysisMethod resolvedMethod = subtype.resolveConcreteMethod((ResolvedJavaMethod)method, (ResolvedJavaType)clazz);
            if (resolvedMethod == null) continue;
            this.markMethodImplementationInvoked(resolvedMethod, reason);
        }
    }

    public void onTypeInstantiated(AnalysisType type) {
        ReachabilityAnalysisEngine bb = (ReachabilityAnalysisEngine)this.universe.getBigbang();
        bb.schedule(() -> type.forAllSuperTypes(current -> {
            Set<ReachabilityAnalysisMethod> invokedMethods = ((ReachabilityAnalysisType)((Object)((Object)current))).getInvokedVirtualMethods();
            for (ReachabilityAnalysisMethod curr : invokedMethods) {
                ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)type.resolveConcreteMethod((ResolvedJavaMethod)curr, (ResolvedJavaType)current);
                if (method == null) continue;
                this.markMethodImplementationInvoked(method, type.getInstantiatedReason());
            }
            for (ReachabilityAnalysisMethod method : ((ReachabilityAnalysisType)((Object)((Object)current))).getInvokedSpecialMethods()) {
                this.markMethodImplementationInvoked(method, type.getInstantiatedReason());
            }
        }));
    }

    public void markMethodInvoked(ReachabilityAnalysisMethod method, Object reason) {
        if (!method.registerAsInvoked(reason)) {
            return;
        }
        this.schedule(() -> this.onMethodInvoked(method, reason));
    }

    public boolean finish() throws InterruptedException {
        this.universe.setAnalysisDataValid(false);
        this.runReachability();
        assert (this.executor.getPostedOperations() == 0L) : this.executor.getPostedOperations();
        this.universe.setAnalysisDataValid(true);
        return true;
    }

    private void runReachability() throws InterruptedException {
        try (Timer.StopTimer t = this.reachabilityTimer.start();){
            this.executor.start();
            this.executor.complete();
            this.executor.shutdown();
            this.executor.init(this.getTiming());
        }
    }

    public void afterAnalysis() {
        this.computeCallers();
    }

    private void computeCallers() {
        HashSet<ReachabilityAnalysisMethod> seen = new HashSet<ReachabilityAnalysisMethod>();
        ArrayDeque<ReachabilityAnalysisMethod> queue = new ArrayDeque<ReachabilityAnalysisMethod>();
        for (AnalysisMethod m : this.universe.getMethods()) {
            ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)m;
            if ((method.isDirectRootMethod() || method.isEntryPoint()) && seen.add(method)) {
                queue.add(method);
            }
            if (!method.isVirtualRootMethod()) continue;
            for (ReachabilityAnalysisType subtype : method.getDeclaringClass().getInstantiatedSubtypes()) {
                ReachabilityAnalysisMethod resolved = subtype.resolveConcreteMethod((ResolvedJavaMethod)method, (ResolvedJavaType)subtype);
                if (resolved == null || !seen.add(resolved)) continue;
                queue.add(resolved);
            }
        }
        while (!queue.isEmpty()) {
            ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)((Object)queue.removeFirst());
            for (InvokeInfo invoke : method.getInvokes()) {
                for (AnalysisMethod c : invoke.getAllCallees()) {
                    ReachabilityAnalysisMethod callee = (ReachabilityAnalysisMethod)c;
                    callee.addCaller(invoke.getPosition());
                    if (!seen.add(callee)) continue;
                    callee.setReason(invoke.getPosition());
                    queue.add(callee);
                }
            }
        }
    }

    public void registerAsJNIAccessed(AnalysisField field, boolean writable) {
    }

    public Iterable<AnalysisType> getAllSynchronizedTypes() {
        return this.getAllInstantiatedTypes();
    }

    public Iterable<AnalysisType> getAllInstantiatedTypes() {
        return this.allInstantiatedTypes;
    }

    public void processGraph(StructuredGraph graph) {
        this.reachabilityMethodProcessingHandler.processGraph(this, graph);
    }

    public boolean trackPrimitiveValues() {
        return false;
    }
}

