/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.fieldvaluetransformer.ArrayBaseOffsetFieldValueTransformer;
import com.oracle.svm.core.fieldvaluetransformer.ArrayIndexScaleFieldValueTransformer;
import com.oracle.svm.core.fieldvaluetransformer.ArrayIndexShiftFieldValueTransformer;
import com.oracle.svm.core.fieldvaluetransformer.FieldOffsetFieldValueTransformer;
import com.oracle.svm.core.fieldvaluetransformer.StaticFieldBaseFieldValueTransformer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializerGraphBuilderPhase;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.ConstantFoldUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public class AutomaticUnsafeTransformationSupport {
    private static final int BASIC_LEVEL = 1;
    private static final int INFO_LEVEL = 2;
    private static final int DEBUG_LEVEL = 3;
    private final AnnotationSubstitutionProcessor annotationSubstitutions;
    private final List<ResolvedJavaType> suppressWarnings;
    private final ResolvedJavaType jdkInternalUnsafeType;
    private final ResolvedJavaType sunMiscUnsafeType;
    private final ResolvedJavaMethod unsafeStaticFieldOffsetMethod;
    private final ResolvedJavaMethod unsafeStaticFieldBaseMethod;
    private final ResolvedJavaMethod unsafeObjectFieldOffsetFieldMethod;
    private final ResolvedJavaMethod sunMiscUnsafeObjectFieldOffsetMethod;
    private final ResolvedJavaMethod unsafeObjectFieldOffsetClassStringMethod;
    private final ResolvedJavaMethod unsafeArrayBaseOffsetMethod;
    private final ResolvedJavaMethod unsafeArrayIndexScaleMethod;
    private final ResolvedJavaMethod integerNumberOfLeadingZerosMethod;
    private final HashSet<ResolvedJavaMethod> neverInlineSet = new HashSet();
    private final HashSet<ResolvedJavaMethod> noCheckedExceptionsSet = new HashSet();
    private final GraphBuilderConfiguration.Plugins plugins;
    private final OptionValues options;

    public AutomaticUnsafeTransformationSupport(OptionValues options, AnnotationSubstitutionProcessor annotationSubstitutions, ImageClassLoader loader) {
        this.options = options;
        this.annotationSubstitutions = annotationSubstitutions;
        MetaAccessProvider originalMetaAccess = GraalAccess.getOriginalProviders().getMetaAccess();
        try {
            Method fieldSetAccessible = Field.class.getMethod("setAccessible", Boolean.TYPE);
            ResolvedJavaMethod fieldSetAccessibleMethod = originalMetaAccess.lookupJavaMethod((Executable)fieldSetAccessible);
            this.neverInlineSet.add(fieldSetAccessibleMethod);
            Method fieldGet = Field.class.getMethod("get", Object.class);
            ResolvedJavaMethod fieldGetMethod = originalMetaAccess.lookupJavaMethod((Executable)fieldGet);
            this.neverInlineSet.add(fieldGetMethod);
            for (Method method : ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.VarHandles").getDeclaredMethods()) {
                this.neverInlineSet.add(originalMetaAccess.lookupJavaMethod((Executable)method));
            }
            Class sunMiscUnsafeClass = ReflectionUtil.lookupClass((boolean)false, (String)"sun.misc.Unsafe");
            this.sunMiscUnsafeType = originalMetaAccess.lookupJavaType(sunMiscUnsafeClass);
            Class<Unsafe> jdkInternalUnsafeClass = Unsafe.class;
            this.jdkInternalUnsafeType = originalMetaAccess.lookupJavaType(jdkInternalUnsafeClass);
            Method unsafeStaticFieldOffset = jdkInternalUnsafeClass.getMethod("staticFieldOffset", Field.class);
            this.unsafeStaticFieldOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeStaticFieldOffset);
            this.noCheckedExceptionsSet.add(this.unsafeStaticFieldOffsetMethod);
            this.neverInlineSet.add(this.unsafeStaticFieldOffsetMethod);
            Method unsafeStaticFieldBase = jdkInternalUnsafeClass.getMethod("staticFieldBase", Field.class);
            this.unsafeStaticFieldBaseMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeStaticFieldBase);
            this.noCheckedExceptionsSet.add(this.unsafeStaticFieldBaseMethod);
            this.neverInlineSet.add(this.unsafeStaticFieldBaseMethod);
            Method unsafeObjectFieldOffset = jdkInternalUnsafeClass.getMethod("objectFieldOffset", Field.class);
            this.unsafeObjectFieldOffsetFieldMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeObjectFieldOffset);
            this.noCheckedExceptionsSet.add(this.unsafeObjectFieldOffsetFieldMethod);
            this.neverInlineSet.add(this.unsafeObjectFieldOffsetFieldMethod);
            Method unsafeObjectClassStringOffset = jdkInternalUnsafeClass.getMethod("objectFieldOffset", Class.class, String.class);
            this.unsafeObjectFieldOffsetClassStringMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeObjectClassStringOffset);
            this.noCheckedExceptionsSet.add(this.unsafeObjectFieldOffsetClassStringMethod);
            this.neverInlineSet.add(this.unsafeObjectFieldOffsetClassStringMethod);
            Method sunMiscUnsafeObjectFieldOffset = sunMiscUnsafeClass.getMethod("objectFieldOffset", Field.class);
            this.sunMiscUnsafeObjectFieldOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)sunMiscUnsafeObjectFieldOffset);
            this.noCheckedExceptionsSet.add(this.sunMiscUnsafeObjectFieldOffsetMethod);
            this.neverInlineSet.add(this.sunMiscUnsafeObjectFieldOffsetMethod);
            Method unsafeArrayBaseOffset = jdkInternalUnsafeClass.getMethod("arrayBaseOffset", Class.class);
            this.unsafeArrayBaseOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeArrayBaseOffset);
            this.noCheckedExceptionsSet.add(this.unsafeArrayBaseOffsetMethod);
            this.neverInlineSet.add(this.unsafeArrayBaseOffsetMethod);
            Method unsafeArrayIndexScale = jdkInternalUnsafeClass.getMethod("arrayIndexScale", Class.class);
            this.unsafeArrayIndexScaleMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeArrayIndexScale);
            this.noCheckedExceptionsSet.add(this.unsafeArrayIndexScaleMethod);
            this.neverInlineSet.add(this.unsafeArrayIndexScaleMethod);
            Method integerNumberOfLeadingZeros = Integer.class.getMethod("numberOfLeadingZeros", Integer.TYPE);
            this.integerNumberOfLeadingZerosMethod = originalMetaAccess.lookupJavaMethod((Executable)integerNumberOfLeadingZeros);
            this.neverInlineSet.add(this.integerNumberOfLeadingZerosMethod);
            Method atomicIntegerFieldUpdaterNewUpdater = AtomicIntegerFieldUpdater.class.getMethod("newUpdater", Class.class, String.class);
            ResolvedJavaMethod atomicIntegerFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicIntegerFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicIntegerFieldUpdaterNewUpdaterMethod);
            Method atomicLongFieldUpdaterNewUpdater = AtomicLongFieldUpdater.class.getMethod("newUpdater", Class.class, String.class);
            ResolvedJavaMethod atomicLongFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicLongFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicLongFieldUpdaterNewUpdaterMethod);
            Method atomicReferenceFieldUpdaterNewUpdater = AtomicReferenceFieldUpdater.class.getMethod("newUpdater", Class.class, Class.class, String.class);
            ResolvedJavaMethod atomicReferenceFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicReferenceFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicReferenceFieldUpdaterNewUpdaterMethod);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
        StaticInitializerInlineInvokePlugin inlineInvokePlugin = new StaticInitializerInlineInvokePlugin(this.neverInlineSet);
        this.plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        this.plugins.appendInlineInvokePlugin((InlineInvokePlugin)inlineInvokePlugin);
        NoClassInitializationPlugin classInitializationPlugin = new NoClassInitializationPlugin();
        this.plugins.setClassInitializationPlugin((ClassInitializationPlugin)classInitializationPlugin);
        FallbackFeature fallbackFeature = ImageSingletons.contains(FallbackFeature.class) ? (FallbackFeature)ImageSingletons.lookup(FallbackFeature.class) : null;
        ReflectionPlugins.registerInvocationPlugins(loader, GraalAccess.getOriginalSnippetReflection(), annotationSubstitutions, (ClassInitializationPlugin)classInitializationPlugin, this.plugins.getInvocationPlugins(), null, ParsingReason.AutomaticUnsafeTransformation, fallbackFeature);
        this.suppressWarnings = List.of(originalMetaAccess.lookupJavaType(ReflectionUtil.lookupClass((boolean)false, (String)"sun.security.provider.ByteArrayAccess")));
    }

    private void addTransformation(BigBang bb, ResolvedJavaField original, ComputedValueField transformation) {
        Class returnType = original.getType().getJavaKind().toJavaClass();
        Object transformer = switch (transformation.getRecomputeValueKind()) {
            case RecomputeFieldValue.Kind.ArrayBaseOffset -> new ArrayBaseOffsetFieldValueTransformer(transformation.getTargetClass(), returnType);
            case RecomputeFieldValue.Kind.ArrayIndexScale -> new ArrayIndexScaleFieldValueTransformer(transformation.getTargetClass(), returnType);
            case RecomputeFieldValue.Kind.ArrayIndexShift -> new ArrayIndexShiftFieldValueTransformer(transformation.getTargetClass(), returnType);
            case RecomputeFieldValue.Kind.FieldOffset -> AutomaticUnsafeTransformationSupport.createFieldOffsetFieldValueTransformer(bb, original, transformation.getTargetField());
            case RecomputeFieldValue.Kind.StaticFieldBase -> new StaticFieldBaseFieldValueTransformer(transformation.getTargetField());
            default -> throw VMError.shouldNotReachHere("Unexpected kind: " + String.valueOf(transformation));
        };
        FieldValueInterceptionSupport.singleton().registerFieldValueTransformer(original, (FieldValueTransformer)transformer);
    }

    private static FieldOffsetFieldValueTransformer createFieldOffsetFieldValueTransformer(BigBang bb, ResolvedJavaField original, Field targetField) {
        bb.postTask(debugContext -> bb.registerAsUnsafeAccessed(bb.getMetaAccess().lookupJavaField(targetField), DefaultUnsafePartition.get(), (Object)original));
        return new FieldOffsetFieldValueTransformer(targetField, original.getType().getJavaKind().toJavaClass());
    }

    public void computeTransformations(BigBang bb, SVMHost hostVM, ResolvedJavaType hostType) {
        if (hostType.isArray()) {
            return;
        }
        if (!hostVM.getClassInitializationSupport().maybeInitializeAtBuildTime(hostType)) {
            return;
        }
        if (this.annotationSubstitutions.findFullSubstitution(hostType).isPresent()) {
            AutomaticUnsafeTransformationSupport.reportSkippedTransformation(hostType);
            return;
        }
        ResolvedJavaMethod clinit = hostType.getClassInitializer();
        if (clinit != null && clinit.hasBytecodes()) {
            DebugContext debug = new DebugContext.Builder(this.options).build();
            try (DebugContext.Scope s = debug.scope((Object)"Field offset computation", (Object)clinit);){
                StructuredGraph clinitGraph = this.getStaticInitializerGraph(clinit, debug);
                for (Invoke invoke : clinitGraph.getInvokes()) {
                    if (!(invoke.callTarget() instanceof MethodCallTargetNode)) continue;
                    if (AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeStaticFieldBaseMethod)) {
                        this.processUnsafeFieldComputation(bb, hostType, invoke, RecomputeFieldValue.Kind.StaticFieldBase);
                        continue;
                    }
                    if (AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeObjectFieldOffsetFieldMethod) || AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.sunMiscUnsafeObjectFieldOffsetMethod) || AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeStaticFieldOffsetMethod)) {
                        this.processUnsafeFieldComputation(bb, hostType, invoke, RecomputeFieldValue.Kind.FieldOffset);
                        continue;
                    }
                    if (AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeObjectFieldOffsetClassStringMethod)) {
                        this.processUnsafeObjectFieldOffsetClassStringInvoke(bb, hostType, invoke);
                        continue;
                    }
                    if (AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeArrayBaseOffsetMethod)) {
                        this.processUnsafeArrayBaseOffsetInvoke(bb, hostType, invoke);
                        continue;
                    }
                    if (!AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.unsafeArrayIndexScaleMethod)) continue;
                    this.processUnsafeArrayIndexScaleInvoke(bb, hostType, invoke, clinitGraph);
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private void processUnsafeFieldComputation(BigBang bb, ResolvedJavaType type, Invoke invoke, RecomputeFieldValue.Kind kind) {
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class<?> targetFieldHolder = null;
        String targetFieldName = null;
        String methodFormat = invoke.callTarget().targetMethod().format("%H.%n(%P)");
        ValueNode fieldArgumentNode = (ValueNode)invoke.callTarget().arguments().get(1);
        JavaConstant fieldArgument = this.nodeAsConstant(fieldArgumentNode);
        if (fieldArgument != null) {
            Field targetField = (Field)GraalAccess.getOriginalSnippetReflection().asObject(Field.class, fieldArgument);
            if (this.isValidField(invoke, targetField, unsuccessfulReasons, methodFormat)) {
                targetFieldHolder = targetField.getDeclaringClass();
                targetFieldName = targetField.getName();
            }
        } else {
            unsuccessfulReasons.add(() -> "The argument of " + methodFormat + " is not a constant value or a field load that can be constant-folded.");
        }
        this.processUnsafeFieldComputation(bb, type, invoke, kind, unsuccessfulReasons, targetFieldHolder, targetFieldName);
    }

    private JavaConstant nodeAsConstant(ValueNode node) {
        if (node.isConstant()) {
            return node.asJavaConstant();
        }
        if (node instanceof LoadFieldNode) {
            Providers p;
            ConstantNode result;
            ValueNode receiverNode;
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            ResolvedJavaField field = loadFieldNode.field();
            JavaConstant receiver = null;
            if (!field.isStatic() && (receiverNode = loadFieldNode.object()).isConstant()) {
                receiver = receiverNode.asJavaConstant();
            }
            if ((result = ConstantFoldUtil.tryConstantFold((ConstantFieldProvider)(p = GraalAccess.getOriginalProviders()).getConstantFieldProvider(), (ConstantReflectionProvider)p.getConstantReflection(), (MetaAccessProvider)p.getMetaAccess(), (ResolvedJavaField)field, (JavaConstant)receiver, (OptionValues)this.options, (Object)loadFieldNode.getNodeSourcePosition())) != null) {
                return result.asJavaConstant();
            }
        }
        return null;
    }

    private boolean isValidField(Invoke invoke, Field field, List<Supplier<String>> unsuccessfulReasons, String methodFormat) {
        if (field == null) {
            unsuccessfulReasons.add(() -> "The argument of " + methodFormat + " is a null constant.");
            return false;
        }
        boolean valid = true;
        if (AutomaticUnsafeTransformationSupport.isInvokeTo(invoke, this.sunMiscUnsafeObjectFieldOffsetMethod)) {
            Class<?> declaringClass = field.getDeclaringClass();
            if (declaringClass.isRecord()) {
                unsuccessfulReasons.add(() -> "The argument to " + methodFormat + " is a field of a record.");
                valid = false;
            }
            if (declaringClass.isHidden()) {
                unsuccessfulReasons.add(() -> "The argument to " + methodFormat + " is a field of a hidden class.");
                valid = false;
            }
        }
        return valid;
    }

    private void processUnsafeObjectFieldOffsetClassStringInvoke(BigBang bb, ResolvedJavaType type, Invoke unsafeObjectFieldOffsetInvoke) {
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class targetFieldHolder = null;
        String targetFieldName = null;
        ValueNode classArgument = (ValueNode)unsafeObjectFieldOffsetInvoke.callTarget().arguments().get(1);
        if (classArgument.isConstant()) {
            Class clazz = (Class)GraalAccess.getOriginalSnippetReflection().asObject(Class.class, classArgument.asJavaConstant());
            if (clazz == null) {
                unsuccessfulReasons.add(() -> "The Class argument of Unsafe.objectFieldOffset(Class, String) is a null constant.");
            } else {
                targetFieldHolder = clazz;
            }
        } else {
            unsuccessfulReasons.add(() -> "The Class argument of Unsafe.objectFieldOffset(Class, String) is not a constant class.");
        }
        ValueNode nameArgument = (ValueNode)unsafeObjectFieldOffsetInvoke.callTarget().arguments().get(2);
        if (nameArgument.isConstant()) {
            String fieldName = (String)GraalAccess.getOriginalSnippetReflection().asObject(String.class, nameArgument.asJavaConstant());
            if (fieldName == null) {
                unsuccessfulReasons.add(() -> "The String argument of Unsafe.objectFieldOffset(Class, String) is a null String.");
            } else {
                targetFieldName = fieldName;
            }
        } else {
            unsuccessfulReasons.add(() -> "The name argument of Unsafe.objectFieldOffset(Class, String) is not a constant String.");
        }
        this.processUnsafeFieldComputation(bb, type, unsafeObjectFieldOffsetInvoke, RecomputeFieldValue.Kind.FieldOffset, unsuccessfulReasons, targetFieldHolder, targetFieldName);
    }

    private void processUnsafeFieldComputation(BigBang bb, ResolvedJavaType type, Invoke invoke, RecomputeFieldValue.Kind kind, List<Supplier<String>> unsuccessfulReasons, Class<?> targetFieldHolder, String targetFieldName) {
        assert (kind == RecomputeFieldValue.Kind.FieldOffset || kind == RecomputeFieldValue.Kind.StaticFieldBase);
        SearchResult result = this.extractValueStoreField(invoke.asNode(), kind, unsuccessfulReasons);
        if (result.valueStoreField == null && !result.illegalUseFound) {
            return;
        }
        ResolvedJavaField valueStoreField = result.valueStoreField;
        if (targetFieldHolder != null && targetFieldName != null && valueStoreField != null) {
            Supplier<ComputedValueField> supplier = () -> ComputedValueField.create(valueStoreField, null, kind, targetFieldHolder, targetFieldName, false);
            if (this.tryAutomaticTransformation(bb, valueStoreField, kind, supplier)) {
                AutomaticUnsafeTransformationSupport.reportSuccessfulAutomaticRecomputation(kind, valueStoreField, targetFieldHolder.getName() + "." + targetFieldName);
            }
        } else {
            this.reportUnsuccessfulAutomaticRecomputation(type, valueStoreField, invoke, kind, unsuccessfulReasons);
        }
    }

    private void processUnsafeArrayBaseOffsetInvoke(BigBang bb, ResolvedJavaType type, Invoke unsafeArrayBaseOffsetInvoke) {
        SnippetReflectionProvider snippetReflectionProvider = GraalAccess.getOriginalSnippetReflection();
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class arrayClass = null;
        ValueNode arrayClassArgument = (ValueNode)unsafeArrayBaseOffsetInvoke.callTarget().arguments().get(1);
        if (arrayClassArgument.isJavaConstant()) {
            arrayClass = (Class)snippetReflectionProvider.asObject(Class.class, arrayClassArgument.asJavaConstant());
        } else {
            unsuccessfulReasons.add(() -> "The argument of the call to Unsafe.arrayBaseOffset() is not a constant.");
        }
        SearchResult result = this.extractValueStoreField(unsafeArrayBaseOffsetInvoke.asNode(), RecomputeFieldValue.Kind.ArrayBaseOffset, unsuccessfulReasons);
        ResolvedJavaField offsetField = result.valueStoreField;
        if (arrayClass != null && offsetField != null) {
            Class finalArrayClass = arrayClass;
            Supplier<ComputedValueField> supplier = () -> ComputedValueField.create(offsetField, null, RecomputeFieldValue.Kind.ArrayBaseOffset, finalArrayClass, null, true);
            if (this.tryAutomaticTransformation(bb, offsetField, RecomputeFieldValue.Kind.ArrayBaseOffset, supplier)) {
                AutomaticUnsafeTransformationSupport.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayBaseOffset, offsetField, arrayClass.getCanonicalName());
            }
        } else if (result.illegalUseFound) {
            this.reportUnsuccessfulAutomaticRecomputation(type, offsetField, unsafeArrayBaseOffsetInvoke, RecomputeFieldValue.Kind.ArrayBaseOffset, unsuccessfulReasons);
        }
    }

    private void processUnsafeArrayIndexScaleInvoke(BigBang bb, ResolvedJavaType type, Invoke unsafeArrayIndexScale, StructuredGraph clinitGraph) {
        SnippetReflectionProvider snippetReflectionProvider = GraalAccess.getOriginalSnippetReflection();
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class arrayClass = null;
        ValueNode arrayClassArgument = (ValueNode)unsafeArrayIndexScale.callTarget().arguments().get(1);
        if (arrayClassArgument.isJavaConstant()) {
            arrayClass = (Class)snippetReflectionProvider.asObject(Class.class, arrayClassArgument.asJavaConstant());
        } else {
            unsuccessfulReasons.add(() -> "The argument of the call to Unsafe.arrayIndexScale() is not a constant.");
        }
        SearchResult result = this.extractValueStoreField(unsafeArrayIndexScale.asNode(), RecomputeFieldValue.Kind.ArrayIndexScale, unsuccessfulReasons);
        ResolvedJavaField indexScaleField = result.valueStoreField;
        boolean indexScaleComputed = false;
        boolean indexShiftComputed = false;
        if (arrayClass != null) {
            if (indexScaleField != null) {
                Class finalArrayClass = arrayClass;
                Supplier<ComputedValueField> supplier = () -> ComputedValueField.create(indexScaleField, null, RecomputeFieldValue.Kind.ArrayIndexScale, finalArrayClass, null, true);
                if (this.tryAutomaticTransformation(bb, indexScaleField, RecomputeFieldValue.Kind.ArrayIndexScale, supplier)) {
                    AutomaticUnsafeTransformationSupport.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayIndexScale, indexScaleField, arrayClass.getCanonicalName());
                    indexScaleComputed = true;
                    indexShiftComputed = this.processArrayIndexShiftFromField(bb, type, indexScaleField, arrayClass, clinitGraph);
                }
            } else {
                indexShiftComputed = this.processArrayIndexShiftFromLocal(bb, type, unsafeArrayIndexScale, arrayClass);
            }
        }
        if (!indexScaleComputed && !indexShiftComputed && result.illegalUseFound) {
            this.reportUnsuccessfulAutomaticRecomputation(type, indexScaleField, unsafeArrayIndexScale, RecomputeFieldValue.Kind.ArrayIndexScale, unsuccessfulReasons);
        }
    }

    private boolean processArrayIndexShiftFromField(BigBang bb, ResolvedJavaType type, ResolvedJavaField indexScaleField, Class<?> arrayClass, StructuredGraph clinitGraph) {
        for (LoadFieldNode load : clinitGraph.getNodes().filter(LoadFieldNode.class)) {
            if (!load.field().equals((Object)indexScaleField) || !this.processArrayIndexShift(bb, type, arrayClass, (ValueNode)load, true)) continue;
            return true;
        }
        return false;
    }

    private boolean processArrayIndexShiftFromLocal(BigBang bb, ResolvedJavaType type, Invoke unsafeArrayIndexScale, Class<?> arrayClass) {
        return this.processArrayIndexShift(bb, type, arrayClass, unsafeArrayIndexScale.asNode(), false);
    }

    private boolean processArrayIndexShift(BigBang bb, ResolvedJavaType type, Class<?> arrayClass, ValueNode indexScaleValue, boolean silentFailure) {
        NodeIterable loadMethodCallTargetUsages = indexScaleValue.usages().filter(MethodCallTargetNode.class);
        for (MethodCallTargetNode methodCallTarget : loadMethodCallTargetUsages) {
            if (!AutomaticUnsafeTransformationSupport.isInvokeTo(methodCallTarget.invoke(), this.integerNumberOfLeadingZerosMethod)) continue;
            SearchResult result = null;
            ResolvedJavaField indexShiftField = null;
            ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
            Invoke numberOfLeadingZerosInvoke = methodCallTarget.invoke();
            NodeIterable numberOfLeadingZerosInvokeSubUsages = numberOfLeadingZerosInvoke.asNode().usages().filter(SubNode.class);
            if (numberOfLeadingZerosInvokeSubUsages.count() == 1) {
                SubNode subNode = (SubNode)numberOfLeadingZerosInvokeSubUsages.first();
                if (AutomaticUnsafeTransformationSupport.subNodeComputesLog2(subNode, numberOfLeadingZerosInvoke)) {
                    result = this.extractValueStoreField((ValueNode)subNode, RecomputeFieldValue.Kind.ArrayIndexShift, unsuccessfulReasons);
                    indexShiftField = result.valueStoreField;
                } else {
                    unsuccessfulReasons.add(() -> "The index array scale value provided by " + String.valueOf(indexScaleValue) + " is not used to calculate the array index shift.");
                }
            } else {
                unsuccessfulReasons.add(() -> "The call to " + methodCallTarget.targetMethod().format("%H.%n(%p)") + " has multiple uses.");
            }
            if (indexShiftField != null) {
                ResolvedJavaField finalIndexShiftField = indexShiftField;
                Supplier<ComputedValueField> supplier = () -> ComputedValueField.create(finalIndexShiftField, null, RecomputeFieldValue.Kind.ArrayIndexShift, arrayClass, null, true);
                if (!this.tryAutomaticTransformation(bb, indexShiftField, RecomputeFieldValue.Kind.ArrayIndexShift, supplier)) continue;
                AutomaticUnsafeTransformationSupport.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayIndexShift, indexShiftField, arrayClass.getCanonicalName());
                return true;
            }
            if (silentFailure || (result == null || !result.illegalUseFound) && unsuccessfulReasons.isEmpty()) continue;
            this.reportUnsuccessfulAutomaticRecomputation(type, null, numberOfLeadingZerosInvoke, RecomputeFieldValue.Kind.ArrayIndexShift, unsuccessfulReasons);
        }
        return false;
    }

    private static boolean subNodeComputesLog2(SubNode subNode, Invoke numberOfLeadingZerosInvokeNode) {
        PrimitiveConstant yValueConstant;
        PrimitiveConstant xValueConstant;
        ValueNode xValueNode = subNode.getX();
        ValueNode yValueNode = subNode.getY();
        if (xValueNode.isJavaConstant() && xValueNode.asJavaConstant().getJavaKind() == JavaKind.Int && (xValueConstant = (PrimitiveConstant)xValueNode.asJavaConstant()).asInt() == 31) {
            assert (yValueNode.equals(numberOfLeadingZerosInvokeNode.asNode()));
            return true;
        }
        if (yValueNode.isJavaConstant() && yValueNode.asJavaConstant().getJavaKind() == JavaKind.Int && (yValueConstant = (PrimitiveConstant)yValueNode.asJavaConstant()).asInt() == 31) {
            assert (xValueNode.equals(numberOfLeadingZerosInvokeNode.asNode()));
            return true;
        }
        return false;
    }

    private SearchResult extractValueStoreField(ValueNode valueNode, RecomputeFieldValue.Kind recomputeKind, List<Supplier<String>> unsuccessfulReasons) {
        ResolvedJavaField valueStoreField = null;
        boolean illegalUseFound = false;
        block0: for (Node valueNodeUsage : valueNode.usages()) {
            if (valueNodeUsage instanceof StoreFieldNode && valueStoreField == null) {
                valueStoreField = ((StoreFieldNode)valueNodeUsage).field();
                continue;
            }
            if (valueNodeUsage instanceof SignExtendNode && valueStoreField == null) {
                SignExtendNode signExtendNode = (SignExtendNode)valueNodeUsage;
                for (Node signExtendNodeUsage : signExtendNode.usages()) {
                    if (signExtendNodeUsage instanceof StoreFieldNode && valueStoreField == null) {
                        valueStoreField = ((StoreFieldNode)signExtendNodeUsage).field();
                        continue;
                    }
                    if (this.isAllowedUnsafeValueSink(signExtendNodeUsage)) continue;
                    illegalUseFound = true;
                    break block0;
                }
                continue;
            }
            if (this.isAllowedUnsafeValueSink(valueNodeUsage)) continue;
            illegalUseFound = true;
            break;
        }
        if (valueStoreField != null && !illegalUseFound) {
            if (valueStoreField.isStatic() && valueStoreField.isFinal()) {
                return SearchResult.foundField(valueStoreField);
            }
            ResolvedJavaField valueStoreFieldFinal = valueStoreField;
            Supplier<String> message = () -> "The field " + valueStoreFieldFinal.format("%H.%n") + ", where the value produced by the " + AutomaticUnsafeTransformationSupport.kindAsString(recomputeKind) + " computation is stored, is not" + (!valueStoreFieldFinal.isStatic() ? " static" : "") + (!valueStoreFieldFinal.isFinal() ? " final" : "") + ".";
            unsuccessfulReasons.add(message);
            return SearchResult.foundIllegalUse();
        }
        if (illegalUseFound) {
            String operation;
            String producer;
            if (valueNode instanceof Invoke) {
                Invoke invokeNode = (Invoke)valueNode;
                producer = "call to " + invokeNode.callTarget().targetMethod().format("%H.%n(%p)");
                operation = "call";
            } else if (valueNode instanceof SubNode) {
                producer = "subtraction operation " + String.valueOf(valueNode);
                operation = "subtraction";
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(valueNode);
            }
            Supplier<String> message = () -> "Could not determine the field where the value produced by the " + producer + " for the " + AutomaticUnsafeTransformationSupport.kindAsString(recomputeKind) + " computation is stored. The " + operation + " is not directly followed by a field store or by a sign extend node followed directly by a field store. ";
            unsuccessfulReasons.add(message);
            return SearchResult.foundIllegalUse();
        }
        return SearchResult.didNotFindIllegalUse();
    }

    private boolean isAllowedUnsafeValueSink(Node valueNodeUsage) {
        MethodCallTargetNode methodCallTarget;
        ResolvedJavaType declaringClass;
        if (valueNodeUsage instanceof FrameState) {
            return true;
        }
        return valueNodeUsage instanceof MethodCallTargetNode && ((declaringClass = (methodCallTarget = (MethodCallTargetNode)valueNodeUsage).targetMethod().getDeclaringClass()).equals((Object)this.jdkInternalUnsafeType) || declaringClass.equals((Object)this.sunMiscUnsafeType));
    }

    private boolean tryAutomaticTransformation(BigBang bb, ResolvedJavaField field, RecomputeFieldValue.Kind kind, Supplier<ComputedValueField> transformationSupplier) {
        if (this.annotationSubstitutions.isDeleted(field)) {
            String conflictingSubstitution = "The field " + field.format("%H.%n") + " is marked as deleted. ";
            AutomaticUnsafeTransformationSupport.reportConflictingSubstitution(field, kind, conflictingSubstitution);
            return false;
        }
        ComputedValueField transformation = transformationSupplier.get();
        Field targetField = transformation.getTargetField();
        if (targetField != null && this.annotationSubstitutions.isDeleted(targetField)) {
            String conflictingSubstitution = "The target field of " + field.format("%H.%n") + " is marked as deleted. ";
            AutomaticUnsafeTransformationSupport.reportSkippedSubstitution(field, kind, conflictingSubstitution);
            return false;
        }
        Optional<ResolvedJavaField> annotationSubstitution = this.annotationSubstitutions.findSubstitution(field);
        if (annotationSubstitution.isPresent()) {
            ResolvedJavaField substitutionField = annotationSubstitution.get();
            if (substitutionField instanceof ComputedValueField) {
                ComputedValueField computedValueField = (ComputedValueField)substitutionField;
                if (computedValueField.getRecomputeValueKind().equals((Object)kind)) {
                    if (computedValueField.getTargetField().equals(transformation.getTargetField())) {
                        AutomaticUnsafeTransformationSupport.reportUnnecessarySubstitution(transformation, computedValueField);
                    }
                    return false;
                }
                if (computedValueField.getRecomputeValueKind().equals((Object)RecomputeFieldValue.Kind.None)) {
                    this.addTransformation(bb, field, transformation);
                    AutomaticUnsafeTransformationSupport.reportOvewrittenSubstitution(substitutionField, kind, computedValueField.getAnnotated(), computedValueField.getRecomputeValueKind());
                    return true;
                }
                String conflictingSubstitution = "Detected RecomputeFieldValue." + String.valueOf(computedValueField.getRecomputeValueKind()) + " " + computedValueField.getAnnotated().format("%H.%n") + " substitution field. ";
                AutomaticUnsafeTransformationSupport.reportConflictingSubstitution(substitutionField, kind, conflictingSubstitution);
                return false;
            }
            String conflictingSubstitution = "Detected " + substitutionField.format("%H.%n") + " substitution field. ";
            AutomaticUnsafeTransformationSupport.reportConflictingSubstitution(substitutionField, kind, conflictingSubstitution);
            return false;
        }
        this.addTransformation(bb, field, transformation);
        return true;
    }

    private static void reportSkippedTransformation(ResolvedJavaType type) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 3) {
            LogUtils.warning((String)("Skipped automatic unsafe transformation analysis for type " + type.getName() + ". The entire type is substituted, therefore its class initializer is eliminated."));
        }
    }

    private static void reportUnnecessarySubstitution(ResolvedJavaField offsetField, ComputedValueField computedSubstitutionField) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 1) {
            RecomputeFieldValue.Kind kind = computedSubstitutionField.getRecomputeValueKind();
            String kindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(kind);
            String annotatedFieldStr = computedSubstitutionField.getAnnotated().format("%H.%n");
            String offsetFieldStr = offsetField.format("%H.%n");
            String optionStr = SubstrateOptionsParser.commandArgument(Options.AutomaticUnsafeTransformationLogLevel, "+");
            LogUtils.warning((String)"Detected unnecessary %s %s substitution field for %s. The annotated field can be removed. This %s computation can be detected automatically. Use option -H:+%s=%s to print all automatically detected substitutions.", (Object[])new Object[]{kindStr, annotatedFieldStr, offsetFieldStr, kind, optionStr, 2});
        }
    }

    private static void reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind recomputeKind, ResolvedJavaField substitutedField, String target) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 2) {
            String recomputeKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(recomputeKind);
            String substitutedFieldStr = substitutedField.format("%H.%n");
            LogUtils.info((String)"%s substitution automatically registered for %s, target element %s.", (Object[])new Object[]{recomputeKindStr, substitutedFieldStr, target});
        }
    }

    private static void reportOvewrittenSubstitution(ResolvedJavaField offsetField, RecomputeFieldValue.Kind newKind, ResolvedJavaField overwrittenField, RecomputeFieldValue.Kind overwrittenKind) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 2) {
            String newKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(newKind);
            String overwrittenKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(overwrittenKind);
            String offsetFieldStr = offsetField.format("%H.%n");
            String overwrittenFieldStr = overwrittenField.format("%H.%n");
            LogUtils.info((String)"The %s %s substitution was overwritten. A %s substitution for %s was automatically registered.", (Object[])new Object[]{overwrittenKindStr, overwrittenFieldStr, newKindStr, offsetFieldStr});
        }
    }

    private static void reportConflictingSubstitution(ResolvedJavaField field, RecomputeFieldValue.Kind recomputeKind, String conflictingSubstitution) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 1) {
            String fieldStr = field.format("%H.%n");
            String recomputeKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(recomputeKind);
            LogUtils.warning((String)"The %s substitution for %s could not be recomputed automatically because a conflicting substitution was detected. Conflicting substitution: %s. Add a %s manual substitution for %s.", (Object[])new Object[]{recomputeKindStr, fieldStr, conflictingSubstitution, recomputeKindStr, fieldStr});
        }
    }

    private static void reportSkippedSubstitution(ResolvedJavaField field, RecomputeFieldValue.Kind recomputeKind, String conflictingSubstitution) {
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 1) {
            String fieldStr = field.format("%H.%n");
            String recomputeKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(recomputeKind);
            LogUtils.warning((String)"The %s substitution for %s could not be recomputed automatically because a conflicting substitution was detected. Conflicting substitution: %s.", (Object[])new Object[]{recomputeKindStr, fieldStr, conflictingSubstitution});
        }
    }

    private void reportUnsuccessfulAutomaticRecomputation(ResolvedJavaType type, ResolvedJavaField computedField, Invoke invoke, RecomputeFieldValue.Kind recomputeKind, List<Supplier<String>> reasons) {
        Object msg = "";
        if (!(Options.AutomaticUnsafeTransformationLogLevel.getValue() < 1 || this.suppressWarningsFor(type) && Options.AutomaticUnsafeTransformationLogLevel.getValue() < 3)) {
            String recomputeKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(recomputeKind);
            String invokeStr = invoke.callTarget().targetMethod().format("%H.%n(%p)");
            msg = (String)msg + recomputeKindStr + " automatic field value transformation failed. ";
            msg = (String)msg + "The automatic registration was attempted because ";
            msg = recomputeKind == RecomputeFieldValue.Kind.ArrayIndexShift ? (String)msg + "an " + String.valueOf(RecomputeFieldValue.Kind.ArrayIndexScale) + " computation followed by a call to " + invokeStr + " " : (String)msg + "a call to " + invokeStr + " ";
            msg = (String)msg + "was detected in the class initializer of " + type.toJavaName() + ". ";
            if (computedField != null) {
                msg = (String)msg + "Add a " + recomputeKindStr + " manual substitution for " + computedField.format("%H.%n") + ". ";
            }
            msg = (String)msg + "Detailed failure reason(s): " + reasons.stream().map(s -> (String)s.get()).collect(Collectors.joining(", "));
        }
        if (Options.AutomaticUnsafeTransformationLogLevel.getValue() >= 3 && this.suppressWarningsFor(type)) {
            msg = (String)msg + "(This warning is suppressed by default because this type ";
            if (this.warningsAreWhiteListed(type)) {
                msg = (String)msg + "is manually added to a white list";
            } else if (this.isAliased(type)) {
                msg = (String)msg + "is aliased";
            } else {
                ResolvedJavaType substitutionType = this.findFullSubstitutionType(type);
                msg = (String)msg + "is fully substituted by " + substitutionType.toJavaName();
            }
            msg = (String)msg + ".)";
        }
        if (!((String)msg).isEmpty()) {
            LogUtils.warning((String)msg);
        }
    }

    private static String kindAsString(RecomputeFieldValue.Kind recomputeKind) {
        switch (recomputeKind) {
            case FieldOffset: {
                return "field offset";
            }
            case StaticFieldBase: {
                return "static field base";
            }
            case ArrayBaseOffset: {
                return "array base offset";
            }
            case ArrayIndexScale: {
                return "array index scale";
            }
            case ArrayIndexShift: {
                return "array index shift";
            }
        }
        throw VMError.shouldNotReachHere("Unexpected kind: " + String.valueOf(recomputeKind));
    }

    private boolean suppressWarningsFor(ResolvedJavaType type) {
        return this.warningsAreWhiteListed(type) || this.isAliased(type) || this.findFullSubstitutionType(type) != null;
    }

    private boolean warningsAreWhiteListed(ResolvedJavaType type) {
        return this.suppressWarnings.contains(type);
    }

    private ResolvedJavaType findFullSubstitutionType(ResolvedJavaType type) {
        Optional<ResolvedJavaType> substTypeOptional = this.annotationSubstitutions.findFullSubstitution(type);
        return substTypeOptional.orElse(null);
    }

    private boolean isAliased(ResolvedJavaType type) {
        return this.annotationSubstitutions.isAliased(type);
    }

    private StructuredGraph getStaticInitializerGraph(ResolvedJavaMethod clinit, DebugContext debug) {
        assert (clinit.hasBytecodes());
        HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
        StructuredGraph graph = new StructuredGraph.Builder(this.options, debug).method(clinit).recordInlinedMethods(false).build();
        graph.getGraphState().configureExplicitExceptionsNoDeopt();
        ClassInitializerGraphBuilderPhase builderPhase = new ClassInitializerGraphBuilderPhase((CoreProviders)context, GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.plugins).withEagerResolving(true), context.getOptimisticOptimizations());
        builderPhase.apply(graph, context);
        for (InvokeWithExceptionNode invoke : graph.getNodes(InvokeWithExceptionNode.TYPE)) {
            if (!this.noCheckedExceptionsSet.contains(invoke.callTarget().targetMethod())) continue;
            invoke.replaceWithInvoke();
        }
        CanonicalizerPhase.createWithoutReadCanonicalization().apply(graph, (Object)context);
        return graph;
    }

    private static boolean isInvokeTo(Invoke invoke, ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        ResolvedJavaMethod targetMethod = invoke.callTarget().targetMethod();
        return method.equals((Object)targetMethod);
    }

    static class StaticInitializerInlineInvokePlugin
    implements InlineInvokePlugin {
        static final int maxDepth = 1;
        static final int maxCodeSize = 500;
        private final HashSet<ResolvedJavaMethod> neverInline;

        StaticInitializerInlineInvokePlugin(HashSet<ResolvedJavaMethod> neverInline) {
            this.neverInline = neverInline;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (this.neverInline.contains(original)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getCode() != null && original.getCodeSize() < 500 && builder.getDepth() <= 1) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    static final class SearchResult {
        final ResolvedJavaField valueStoreField;
        final boolean illegalUseFound;

        private SearchResult(ResolvedJavaField valueStoreField, boolean illegalUseFound) {
            this.valueStoreField = valueStoreField;
            this.illegalUseFound = illegalUseFound;
        }

        static SearchResult foundField(ResolvedJavaField offsetField) {
            return new SearchResult(offsetField, false);
        }

        static SearchResult foundIllegalUse() {
            return new SearchResult(null, true);
        }

        static SearchResult didNotFindIllegalUse() {
            return new SearchResult(null, false);
        }
    }

    static class Options {
        static final HostedOptionKey<Integer> AutomaticUnsafeTransformationLogLevel = new HostedOptionKey<Integer>(1);

        Options() {
        }
    }
}

