/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.CustomTypeFieldHandler;
import com.oracle.svm.hosted.ameta.ReadableJavaField;
import com.oracle.svm.hosted.analysis.FieldValueComputer;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import com.oracle.svm.hosted.substitute.FieldValueTransformation;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public final class FieldValueInterceptionSupport {
    private static final Object INTERCEPTOR_ACCESSED_MARKER = new Object();
    private final AnnotationSubstitutionProcessor annotationSubstitutions;
    private final Map<ResolvedJavaField, Object> fieldValueInterceptors = new ConcurrentHashMap<ResolvedJavaField, Object>();

    public static FieldValueInterceptionSupport singleton() {
        return (FieldValueInterceptionSupport)ImageSingletons.lookup(FieldValueInterceptionSupport.class);
    }

    public FieldValueInterceptionSupport(AnnotationSubstitutionProcessor annotationSubstitutions) {
        this.annotationSubstitutions = annotationSubstitutions;
    }

    public void registerFieldValueTransformer(Field reflectionField, FieldValueTransformer transformer) {
        this.registerFieldValueTransformer(GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaField(reflectionField), transformer);
    }

    public void registerFieldValueTransformer(ResolvedJavaField oField, FieldValueTransformer transformer) {
        ComputedValueField computedValueField;
        ResolvedJavaField resolvedJavaField;
        assert (oField instanceof HotSpotResolvedJavaField) : oField;
        if (this.annotationSubstitutions.isDeleted(oField)) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "The field is marked as deleted, i.e., the field is not available on this platform");
        }
        Optional<ResolvedJavaField> substitution = this.annotationSubstitutions.findSubstitution(oField);
        if (substitution.isPresent() && (resolvedJavaField = substitution.get()) instanceof ComputedValueField && (computedValueField = (ComputedValueField)resolvedJavaField).getRecomputeValueKind() != RecomputeFieldValue.Kind.None) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "The field value is already transformed via an @Alias annotation.");
        }
        FieldValueTransformation transformation = new FieldValueTransformation(OriginalClassProvider.getJavaClass((JavaType)oField.getType()), Objects.requireNonNull(transformer), false);
        Object existingInterceptor = this.fieldValueInterceptors.putIfAbsent(oField, transformation);
        if (existingInterceptor == INTERCEPTOR_ACCESSED_MARKER) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "The field was already accessed by the static analysis. The transformer must be registered earlier, before the static analysis sees a reference to the field for the first time.");
        }
        if (existingInterceptor != null) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "A field value transformer is already registered for this field.");
        }
    }

    Object lookupFieldValueInterceptor(AnalysisField field) {
        Object result = field.getFieldValueInterceptor();
        if (result == null) {
            result = this.computeAndCacheFieldValueInterceptor(field);
        }
        return result == INTERCEPTOR_ACCESSED_MARKER ? null : result;
    }

    private Object computeAndCacheFieldValueInterceptor(AnalysisField field) {
        Object result;
        field.beforeFieldValueAccess();
        ResolvedJavaField oField = OriginalFieldProvider.getOriginalField((ResolvedJavaField)field);
        assert (oField == null || oField instanceof HotSpotResolvedJavaField) : oField;
        FieldValueComputer computer = FieldValueInterceptionSupport.createFieldValueComputer(field);
        if (computer != null) {
            VMError.guarantee(oField != null, "Cannot have a @UnknownObjectField or @UnknownPrimitiveField annotation on synthetic field %s", field);
            Object interceptor = this.fieldValueInterceptors.computeIfAbsent(oField, k -> computer);
            if (!(interceptor instanceof FieldValueComputer)) {
                throw UserError.abort("Cannot register a field value transformer for field %s: %s", field.format("%H.%n"), "The field is annotated with @UnknownObjectField or @UnknownPrimitiveField.");
            }
            result = interceptor;
        } else {
            result = oField != null ? this.fieldValueInterceptors.computeIfAbsent(oField, k -> INTERCEPTOR_ACCESSED_MARKER) : INTERCEPTOR_ACCESSED_MARKER;
        }
        Objects.requireNonNull(result, "Must have a non-null value now to avoid repeated invocation of this method");
        field.setFieldValueInterceptor(result);
        return result;
    }

    public boolean isValueAvailable(AnalysisField field) {
        ReadableJavaField readableField;
        ResolvedJavaField resolvedJavaField;
        FieldValueComputer computer;
        FieldValueTransformerWithAvailability transformerWithAvailability;
        FieldValueTransformation transformation;
        FieldValueTransformer fieldValueTransformer;
        Object interceptor = this.lookupFieldValueInterceptor(field);
        return !(interceptor instanceof FieldValueTransformation ? (fieldValueTransformer = (transformation = (FieldValueTransformation)interceptor).getFieldValueTransformer()) instanceof FieldValueTransformerWithAvailability && !FieldValueInterceptionSupport.isAvailable((transformerWithAvailability = (FieldValueTransformerWithAvailability)fieldValueTransformer).valueAvailability()) : (interceptor instanceof FieldValueComputer ? !(computer = (FieldValueComputer)interceptor).isAvailable() : (resolvedJavaField = field.wrapped) instanceof ReadableJavaField && !(readableField = (ReadableJavaField)resolvedJavaField).isValueAvailable()));
    }

    private static boolean isAvailable(FieldValueTransformerWithAvailability.ValueAvailability availability) {
        return switch (availability) {
            default -> throw new MatchException(null, null);
            case FieldValueTransformerWithAvailability.ValueAvailability.BeforeAnalysis -> true;
            case FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis -> BuildPhaseProvider.isHostedUniverseBuilt();
            case FieldValueTransformerWithAvailability.ValueAvailability.AfterCompilation -> BuildPhaseProvider.isCompilationFinished();
        };
    }

    public boolean hasFieldValueTransformer(AnalysisField field) {
        Object interceptor = this.lookupFieldValueInterceptor(field);
        if (interceptor instanceof FieldValueTransformation) {
            return true;
        }
        return field.wrapped instanceof ComputedValueField;
    }

    JavaConstant readFieldValue(ClassInitializationSupport classInitializationSupport, AnalysisField field, JavaConstant receiver) {
        assert (this.isValueAvailable(field)) : field;
        Object interceptor = this.lookupFieldValueInterceptor(field);
        if (interceptor instanceof FieldValueTransformation) {
            FieldValueTransformation transformation = (FieldValueTransformation)interceptor;
            return transformation.readValue(classInitializationSupport, field.wrapped, receiver);
        }
        return ReadableJavaField.readFieldValue(classInitializationSupport, field.wrapped, receiver);
    }

    private static FieldValueComputer createFieldValueComputer(AnalysisField field) {
        UnknownObjectField unknownObjectField = (UnknownObjectField)field.getAnnotation(UnknownObjectField.class);
        if (unknownObjectField != null) {
            return new FieldValueComputer((BooleanSupplier)ReflectionUtil.newInstance(unknownObjectField.availability()), FieldValueInterceptionSupport.extractAnnotationTypes(field, unknownObjectField.types(), unknownObjectField.fullyQualifiedTypes()), unknownObjectField.canBeNull());
        }
        UnknownPrimitiveField unknownPrimitiveField = (UnknownPrimitiveField)field.getAnnotation(UnknownPrimitiveField.class);
        if (unknownPrimitiveField != null) {
            return new FieldValueComputer((BooleanSupplier)ReflectionUtil.newInstance(unknownPrimitiveField.availability()), List.of(field.getType().getJavaClass()), false);
        }
        return null;
    }

    private static List<Class<?>> extractAnnotationTypes(AnalysisField field, Class<?>[] types, String[] fullyQualifiedTypes) {
        ArrayList annotationTypes = new ArrayList(Arrays.asList(types));
        for (String annotationTypeName : fullyQualifiedTypes) {
            try {
                Class<?> annotationType = Class.forName(annotationTypeName);
                annotationTypes.add(annotationType);
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("Specified computed value type not found: " + annotationTypeName, new Object[0]);
            }
        }
        if (annotationTypes.isEmpty()) {
            AnalysisType fieldType = field.getType();
            UserError.guarantee(CustomTypeFieldHandler.isConcreteType(fieldType), "Illegal use of @UnknownObjectField annotation on field %s. The field type must be concrete or the annotation must declare a concrete type.", field);
            annotationTypes.add(fieldType.getJavaClass());
        }
        return annotationTypes;
    }
}

