/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationInternals;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_StackChunk;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@TargetClass(className="jdk.internal.vm.Continuation")
public final class Target_jdk_internal_vm_Continuation {
    @Alias
    Runnable target;
    @Inject
    int pinCount;
    @Inject
    StoredContinuation stored;
    @Delete
    Target_jdk_internal_vm_StackChunk tail;
    @Inject
    Pointer sp;
    @Inject
    CodePointer ip;
    @Inject
    Pointer baseSP;
    @Inject
    int overflowCheckState;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    boolean isEmpty() {
        return this.stored == null;
    }

    @Alias
    public native Target_jdk_internal_vm_ContinuationScope getScope();

    @Alias
    public native Target_jdk_internal_vm_Continuation getParent();

    @Substitute
    @NeverInline(value="access stack pointer")
    private static int isPinned0(Target_jdk_internal_vm_ContinuationScope scope) {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        Target_jdk_internal_vm_Continuation cont = carrier.cont;
        if (cont != null) {
            while (true) {
                if (cont.pinCount != 0) {
                    return 2;
                }
                if (cont.getParent() == null || cont.getScope() == scope) break;
                cont = cont.getParent();
            }
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(CurrentIsolate.getCurrentThread());
            if (anchor.isNonNull() && cont.baseSP.aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
                return 3;
            }
        }
        return 0;
    }

    @Substitute
    boolean isStarted() {
        return this.stored != null;
    }

    @Alias
    public static native Target_jdk_internal_vm_Continuation getCurrentContinuation(Target_jdk_internal_vm_ContinuationScope var0);

    @Substitute
    static void enterSpecial(Target_jdk_internal_vm_Continuation c, boolean isContinue, boolean isVirtualThread) {
        assert (isVirtualThread);
        int stateBefore = StackOverflowCheck.singleton().getState();
        VMError.guarantee(!StackOverflowCheck.singleton().isYellowZoneAvailable());
        assert (isContinue == (c.stored != null));
        if (isContinue) {
            StackOverflowCheck.singleton().setState(c.overflowCheckState);
        }
        try {
            ContinuationInternals.enterSpecial0(c, isContinue);
        }
        catch (StackOverflowError e) {
            throw e == ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR ? new StackOverflowError() : e;
        }
        finally {
            c.overflowCheckState = StackOverflowCheck.singleton().getState();
            StackOverflowCheck.singleton().setState(stateBefore);
            assert (c.sp.isNull() && c.ip.isNull() && c.baseSP.isNull());
        }
    }

    @Substitute
    private static int doYield() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        Target_jdk_internal_vm_Continuation cont = carrier.cont;
        int pinnedReason = Target_jdk_internal_vm_Continuation.isPinned0(cont.getScope());
        if (pinnedReason != 0) {
            return pinnedReason;
        }
        return ContinuationInternals.doYield0(cont);
    }

    @Alias
    private native void finish();

    @Substitute
    private static void enter(Target_jdk_internal_vm_Continuation c, boolean isContinue) {
        try {
            c.target.run();
        }
        finally {
            c.finish();
        }
    }

    @Substitute
    void enter0() {
        Target_jdk_internal_vm_Continuation.enter(this, false);
    }

    @Substitute
    public static void pin() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        if (carrier.cont != null) {
            if (carrier.cont.pinCount + 1 == 0) {
                throw new IllegalStateException("Pin overflow");
            }
            ++carrier.cont.pinCount;
        }
    }

    @Substitute
    public static void unpin() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        if (carrier.cont != null) {
            if (carrier.cont.pinCount == 0) {
                throw new IllegalStateException("Pin underflow");
            }
            --carrier.cont.pinCount;
        }
    }

    @Alias
    static native boolean isPinned(Target_jdk_internal_vm_ContinuationScope var0);

    @Substitute
    void postYieldCleanup() {
    }

    @Delete
    native void dump();
}

