/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.word.LocationIdentity;

public class SnippetRuntime {
    public static final SubstrateForeignCallDescriptor UNSUPPORTED_FEATURE = SnippetRuntime.findForeignCall(SnippetRuntime.class, "unsupportedFeature", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    private static final SubstrateForeignCallDescriptor REGISTER_FINALIZER = SnippetRuntime.findForeignCall(SnippetRuntime.class, "registerFinalizer", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_SIN = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature.getName(), Math.class, "sin", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_COS = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature.getName(), Math.class, "cos", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_TAN = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature.getName(), Math.class, "tan", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_LOG = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature.getName(), Math.class, "log", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_LOG10 = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature.getName(), Math.class, "log10", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_EXP = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature.getName(), Math.class, "exp", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_POW = SnippetRuntime.findForeignJdkCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature.getName(), Math.class, "pow", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SubstrateForeignCallDescriptor[]{UNSUPPORTED_FEATURE, REGISTER_FINALIZER, ARITHMETIC_SIN, ARITHMETIC_COS, ARITHMETIC_TAN, ARITHMETIC_LOG, ARITHMETIC_LOG10, ARITHMETIC_EXP, ARITHMETIC_POW};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity ... additionalKilledLocations) {
        Method method = SnippetRuntime.findMethod(declaringClass, methodName);
        SubstrateForeignCallTarget foreignCallTargetAnnotation = (SubstrateForeignCallTarget)AnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class);
        VMError.guarantee(foreignCallTargetAnnotation != null, "Add missing @SubstrateForeignCallTarget to %s.%s", declaringClass.getName(), methodName);
        boolean isUninterruptible = Uninterruptible.Utils.isUninterruptible(method);
        boolean isFullyUninterruptible = foreignCallTargetAnnotation.fullyUninterruptible();
        return SnippetRuntime.findForeignCall(methodName, method, callSideEffect, isUninterruptible, isFullyUninterruptible, additionalKilledLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignJdkCall(String descriptorName, Class<?> declaringClass, String methodName, ForeignCallDescriptor.CallSideEffect callSideEffect, boolean isUninterruptible, boolean isFullyUninterruptible, LocationIdentity ... additionalKilledLocations) {
        Method method = SnippetRuntime.findMethod(declaringClass, methodName);
        SubstrateForeignCallTarget foreignCallTargetAnnotation = (SubstrateForeignCallTarget)AnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class);
        VMError.guarantee(foreignCallTargetAnnotation == null, "%s.%s must not be annotated with @SubstrateForeignCallTarget.", declaringClass.getName(), methodName);
        return SnippetRuntime.findForeignCall(descriptorName, method, callSideEffect, isUninterruptible, isFullyUninterruptible, additionalKilledLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Method method, ForeignCallDescriptor.CallSideEffect callSideEffect, boolean isUninterruptible, boolean isFullyUninterruptible, LocationIdentity ... additionalKilledLocations) {
        LocationIdentity[] killedLocations;
        if (isFullyUninterruptible) {
            VMError.guarantee(isUninterruptible, "%s is fully uninterruptible but not annotated with @Uninterruptible.", method);
            killedLocations = additionalKilledLocations;
        } else if (additionalKilledLocations.length == 0 || additionalKilledLocations == SubstrateAllocationSnippets.GC_LOCATIONS) {
            killedLocations = SubstrateAllocationSnippets.GC_LOCATIONS;
        } else if (SnippetRuntime.containsAny(additionalKilledLocations)) {
            killedLocations = additionalKilledLocations;
        } else {
            killedLocations = new LocationIdentity[SubstrateAllocationSnippets.GC_LOCATIONS.length + additionalKilledLocations.length];
            System.arraycopy(SubstrateAllocationSnippets.GC_LOCATIONS, 0, killedLocations, 0, SubstrateAllocationSnippets.GC_LOCATIONS.length);
            System.arraycopy(additionalKilledLocations, 0, killedLocations, SubstrateAllocationSnippets.GC_LOCATIONS.length, additionalKilledLocations.length);
        }
        boolean needsDebugInfo = !isFullyUninterruptible;
        boolean isGuaranteedSafepoint = !isUninterruptible;
        return new SubstrateForeignCallDescriptor(descriptorName, method, callSideEffect, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
    }

    private static Method findMethod(Class<?> declaringClass, String methodName) {
        Method foundMethod = null;
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            assert (foundMethod == null) : "found more than one method " + declaringClass.getName() + "." + methodName;
            foundMethod = method;
        }
        assert (foundMethod != null) : "did not find method " + declaringClass.getName() + "." + methodName;
        return foundMethod;
    }

    private static boolean containsAny(LocationIdentity[] locations) {
        for (LocationIdentity location : locations) {
            if (!location.isAny()) continue;
            return true;
        }
        return false;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void unsupportedFeature(String msg) {
        throw VMError.unsupportedFeature(msg);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void registerFinalizer(Object obj) {
    }

    public static class SubstrateForeignCallDescriptor
    extends ForeignCallDescriptor {
        private final Class<?> declaringClass;
        private final String methodName;

        SubstrateForeignCallDescriptor(String descriptorName, Method method, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity[] killedLocations, boolean needsDebugInfo, boolean isGuaranteedSafepoint) {
            super(descriptorName, method.getReturnType(), (Class[])method.getParameterTypes(), callSideEffect, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
            this.declaringClass = method.getDeclaringClass();
            this.methodName = method.getName();
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess) {
            for (Method method : this.declaringClass.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName)) continue;
                return metaAccess.lookupJavaMethod((Executable)method);
            }
            throw VMError.shouldNotReachHere("method " + this.methodName + " not found");
        }

        public boolean needsDebugInfo() {
            return this.canDeoptimize();
        }
    }
}

