/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockingPrimitive;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;

public abstract class VMLockSupport {
    @Fold
    public static VMLockSupport singleton() {
        return (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
    }

    public abstract VMMutex[] getMutexes();

    public abstract VMCondition[] getConditions();

    public abstract VMSemaphore[] getSemaphores();

    @Uninterruptible(reason="Too early for safepoints.")
    public final boolean initialize() {
        VMLockSupport support = VMLockSupport.singleton();
        for (VMMutex vMMutex : support.getMutexes()) {
            if (vMMutex.initialize() == 0) continue;
            return false;
        }
        for (VMLockingPrimitive vMLockingPrimitive : support.getConditions()) {
            if (vMLockingPrimitive.initialize() == 0) continue;
            return false;
        }
        for (VMLockingPrimitive vMLockingPrimitive : support.getSemaphores()) {
            if (vMLockingPrimitive.initialize() == 0) continue;
            return false;
        }
        return true;
    }

    @Uninterruptible(reason="The isolate teardown is in progress.")
    public final boolean destroy() {
        VMLockSupport support = VMLockSupport.singleton();
        for (VMSemaphore vMSemaphore : support.getSemaphores()) {
            if (vMSemaphore.destroy() == 0) continue;
            return false;
        }
        for (VMLockingPrimitive vMLockingPrimitive : support.getConditions()) {
            if (vMLockingPrimitive.destroy() == 0) continue;
            return false;
        }
        for (VMLockingPrimitive vMLockingPrimitive : support.getMutexes()) {
            if (vMLockingPrimitive.destroy() == 0) continue;
            return false;
        }
        return true;
    }

    public static class DumpVMMutexes
    extends SubstrateDiagnostics.DiagnosticThunk {
        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("VM mutexes:").indent(true);
            VMLockSupport support = null;
            if (ImageSingletons.contains(VMLockSupport.class)) {
                support = (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
            }
            if (support == null || support.getMutexes() == null) {
                log.string("No mutex information is available.").newline();
            } else {
                for (VMMutex mutex : support.getMutexes()) {
                    IsolateThread owner = mutex.owner;
                    log.string("mutex \"").string(mutex.getName()).string("\" ");
                    if (owner.isNull()) {
                        log.string("is unlocked.");
                    } else {
                        log.string("is locked by ");
                        if (owner.equal((ComparableWord)VMMutex.UNSPECIFIED_OWNER)) {
                            log.string("an unspecified thread.");
                        } else {
                            log.string("thread ").zhex((WordBase)owner);
                        }
                    }
                    log.newline();
                }
            }
            log.indent(false);
        }
    }
}

