/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.SingleThreadedVMCondition;
import com.oracle.svm.core.locks.SingleThreadedVMLockSupport;
import com.oracle.svm.core.locks.SingleThreadedVMMutex;
import com.oracle.svm.core.locks.SingleThreadedVMSemaphore;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class SingleThreadedVMLockFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMMutex, VMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, VMMutex>(this, VMMutex.class){

        @Override
        protected VMMutex createReplacement(VMMutex source) {
            return new SingleThreadedVMMutex(source.getName());
        }
    };
    private final ClassInstanceReplacer<VMCondition, VMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, VMCondition>(VMCondition.class){

        @Override
        protected VMCondition createReplacement(VMCondition source) {
            return new SingleThreadedVMCondition((SingleThreadedVMMutex)SingleThreadedVMLockFeature.this.mutexReplacer.apply((Object)source.getMutex()));
        }
    };
    private final ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(this, VMSemaphore.class){

        @Override
        protected VMSemaphore createReplacement(VMSemaphore source) {
            return new SingleThreadedVMSemaphore(source.getName());
        }
    };

    SingleThreadedVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue() == false;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(VMLockSupport.class, (Object)new SingleThreadedVMLockSupport());
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
        access.registerObjectReplacer(this.semaphoreReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        this.mutexReplacer.getReplacements();
        this.conditionReplacer.getReplacements();
        this.semaphoreReplacer.getReplacements();
    }
}

