/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.RuntimeModuleSupport;
import com.oracle.svm.core.jdk.resources.MissingResourceRegistrationUtils;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import com.oracle.svm.core.jdk.resources.ResourceExceptionEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Resources {
    private static final int INVALID_TIMESTAMP = -1;
    public static final char RESOURCES_INTERNAL_PATH_SEPARATOR = '/';
    private final EconomicMap<Pair<Module, String>, ResourceStorageEntryBase> resources = ImageHeapMap.create();
    private final EconomicMap<ModuleResourcePair, Boolean> includePatterns = ImageHeapMap.create();
    public static final ResourceStorageEntryBase NEGATIVE_QUERY_MARKER = new ResourceStorageEntryBase();
    private static final ResourceStorageEntryBase MISSING_METADATA_MARKER = new ResourceStorageEntryBase();
    private long lastModifiedTime = -1L;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String BEGIN_ESCAPED_SEQUENCE = "\\Q";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String END_ESCAPED_SEQUENCE = "\\E";

    public static Resources singleton() {
        return (Resources)ImageSingletons.lookup(Resources.class);
    }

    Resources() {
    }

    public EconomicMap<Pair<Module, String>, ResourceStorageEntryBase> getResourceStorage() {
        return this.resources;
    }

    public Iterable<ResourceStorageEntryBase> resources() {
        return this.resources.getValues();
    }

    public int count() {
        return this.resources.size();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public static String moduleName(Module module) {
        return module == null ? null : module.getName();
    }

    private static Pair<Module, String> createStorageKey(Module module, String resourceName) {
        Module m = module != null && module.isNamed() ? module : null;
        return Pair.create((Object)m, (Object)resourceName);
    }

    public static Set<String> getIncludedResourcesModules() {
        return StreamSupport.stream(Resources.singleton().resources.getKeys().spliterator(), false).map(Pair::getLeft).filter(Objects::nonNull).map(Module::getName).collect(Collectors.toSet());
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        try {
            return is.readAllBytes();
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void updateTimeStamp() {
        if (this.lastModifiedTime == -1L) {
            this.lastModifiedTime = new Date().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void addEntry(Module module, String resourceName, boolean isDirectory, byte[] data, boolean fromJar, boolean isNegativeQuery) {
        Module m;
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to add a resource entry after analysis.");
        Module module2 = m = module != null && module.isNamed() ? module : null;
        if (m != null) {
            m = RuntimeModuleSupport.instance().getRuntimeModuleForHostedModule(m);
        }
        EconomicMap<Pair<Module, String>, ResourceStorageEntryBase> economicMap = this.resources;
        synchronized (economicMap) {
            Pair<Module, String> key = Resources.createStorageKey(m, resourceName);
            ResourceStorageEntryBase entry = (ResourceStorageEntryBase)this.resources.get(key);
            if (isNegativeQuery) {
                if (entry == null) {
                    this.resources.put(key, (Object)NEGATIVE_QUERY_MARKER);
                }
                return;
            }
            if (entry == null || entry == NEGATIVE_QUERY_MARKER) {
                this.updateTimeStamp();
                entry = new ResourceStorageEntry(isDirectory, fromJar);
                this.resources.put(key, (Object)entry);
            } else if (key.getLeft() != null) {
                return;
            }
            entry.getData().add(data);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String resourceName, InputStream is) {
        Resources.singleton().registerResource(null, resourceName, is, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerResource(Module module, String resourceName, byte[] resourceContent) {
        this.addEntry(module, resourceName, false, resourceContent, true, false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerResource(Module module, String resourceName, InputStream is, boolean fromJar) {
        this.addEntry(module, resourceName, false, Resources.inputStreamToByteArray(is), fromJar, false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerDirectoryResource(Module module, String resourceDirName, String content, boolean fromJar) {
        this.addEntry(module, resourceDirName, true, content.getBytes(), fromJar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerIOException(Module module, String resourceName, IOException e, boolean linkAtBuildTime) {
        if (linkAtBuildTime) {
            if (SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions.getValue().booleanValue()) {
                throw new RuntimeException("Resource " + resourceName + " from module " + Resources.moduleName(module) + " produced an IOException.", e);
            }
            LogUtils.warning((String)("Resource " + resourceName + " from module " + Resources.moduleName(module) + " produced the following IOException: " + e.getClass().getTypeName() + ": " + e.getMessage()));
        }
        Pair<Module, String> key = Resources.createStorageKey(module, resourceName);
        EconomicMap<Pair<Module, String>, ResourceStorageEntryBase> economicMap = this.resources;
        synchronized (economicMap) {
            this.updateTimeStamp();
            this.resources.put(key, (Object)new ResourceExceptionEntry(e));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(String resourceName) {
        this.registerNegativeQuery(null, resourceName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(Module module, String resourceName) {
        this.addEntry(module, resourceName, false, null, false, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerIncludePattern(String pattern) {
        this.registerIncludePattern(null, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerIncludePattern(String module, String pattern) {
        assert (MissingRegistrationUtils.throwMissingRegistrationErrors());
        EconomicMap<ModuleResourcePair, Boolean> economicMap = this.includePatterns;
        synchronized (economicMap) {
            this.updateTimeStamp();
            this.includePatterns.put((Object)new ModuleResourcePair(module, Resources.handleEscapedCharacters(pattern)), (Object)Boolean.TRUE);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String handleEscapedCharacters(String pattern) {
        if (pattern.startsWith(BEGIN_ESCAPED_SEQUENCE) && pattern.endsWith(END_ESCAPED_SEQUENCE)) {
            return pattern.substring(BEGIN_ESCAPED_SEQUENCE.length(), pattern.length() - END_ESCAPED_SEQUENCE.length());
        }
        return pattern;
    }

    public static String toCanonicalForm(String resourceName) {
        NativeImageResourcePath path = new NativeImageResourcePath(null, Resources.removeTrailingSlash(resourceName).getBytes(StandardCharsets.UTF_8), true);
        return new String(NativeImageResourcePath.getResolved(path));
    }

    private static boolean hasTrailingSlash(String resourceName) {
        return resourceName.endsWith("/");
    }

    private static String removeTrailingSlash(String resourceName) {
        return Resources.hasTrailingSlash(resourceName) ? resourceName.substring(0, resourceName.length() - 1) : resourceName;
    }

    private static boolean wasAlreadyInCanonicalForm(String resourceName, String canonicalResourceName) {
        return resourceName.equals(canonicalResourceName) || Resources.removeTrailingSlash(resourceName).equals(canonicalResourceName);
    }

    public ResourceStorageEntryBase get(String name, boolean throwOnMissing) {
        return this.get(null, name, throwOnMissing);
    }

    public ResourceStorageEntryBase get(Module module, String resourceName, boolean throwOnMissing) {
        String canonicalResourceName = Resources.toCanonicalForm(resourceName);
        String moduleName = Resources.moduleName(module);
        ResourceStorageEntryBase entry = (ResourceStorageEntryBase)this.resources.get(Resources.createStorageKey(module, canonicalResourceName));
        if (entry == null) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                MapCursor cursor = this.includePatterns.getEntries();
                while (cursor.advance()) {
                    ModuleResourcePair moduleResourcePair = (ModuleResourcePair)cursor.getKey();
                    if (!Objects.equals(moduleName, moduleResourcePair.module) || !Resources.matchResource(moduleResourcePair.resource, resourceName) && !Resources.matchResource(moduleResourcePair.resource, canonicalResourceName)) continue;
                    return null;
                }
                return Resources.missingMetadata(resourceName, throwOnMissing);
            }
            return null;
        }
        if (entry.isException()) {
            throw new RuntimeException(entry.getException());
        }
        if (entry == NEGATIVE_QUERY_MARKER) {
            return null;
        }
        if (entry.isFromJar() && !Resources.wasAlreadyInCanonicalForm(resourceName, canonicalResourceName)) {
            return null;
        }
        if (!entry.isDirectory() && Resources.hasTrailingSlash(resourceName)) {
            return null;
        }
        return entry;
    }

    private static ResourceStorageEntryBase missingMetadata(String resourceName, boolean throwOnMissing) {
        if (throwOnMissing) {
            MissingResourceRegistrationUtils.missingResource(resourceName);
        }
        return MISSING_METADATA_MARKER;
    }

    private static URL createURL(Module module, String resourceName, int index) {
        try {
            String refPart = index != 0 ? "#" + Integer.toString(index) : "";
            String moduleName = Resources.moduleName(module);
            return new URL("resource", moduleName, -1, "/" + resourceName + refPart);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public URL createURL(String resourceName) {
        return this.createURL(null, resourceName);
    }

    public URL createURL(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Enumeration<URL> urls = this.createURLs(module, resourceName);
        return urls.hasMoreElements() ? urls.nextElement() : null;
    }

    public InputStream createInputStream(String resourceName) {
        return this.createInputStream(null, resourceName);
    }

    public InputStream createInputStream(Module module, String resourceName) {
        boolean isInMetadata;
        if (resourceName == null) {
            return null;
        }
        ResourceStorageEntryBase entry = this.get(module, resourceName, false);
        boolean bl = isInMetadata = entry != MISSING_METADATA_MARKER;
        if (Resources.moduleName(module) == null && (entry == MISSING_METADATA_MARKER || entry == null)) {
            for (Module m : RuntimeModuleSupport.instance().getBootLayer().modules()) {
                entry = this.get(m, resourceName, false);
                if (entry != MISSING_METADATA_MARKER) {
                    isInMetadata = true;
                }
                if (entry == null || entry == MISSING_METADATA_MARKER) continue;
                break;
            }
        }
        if (!isInMetadata) {
            MissingResourceRegistrationUtils.missingResource(resourceName);
        }
        if (entry == null || entry == MISSING_METADATA_MARKER) {
            return null;
        }
        List<byte[]> data = entry.getData();
        return data.isEmpty() ? null : new ByteArrayInputStream(data.get(0));
    }

    public Enumeration<URL> createURLs(String resourceName) {
        return this.createURLs(null, resourceName);
    }

    public Enumeration<URL> createURLs(Module module, String resourceName) {
        ResourceStorageEntryBase explicitEntry;
        if (resourceName == null) {
            return null;
        }
        boolean missingMetadata = true;
        ArrayList<URL> resourcesURLs = new ArrayList<URL>();
        String canonicalResourceName = Resources.toCanonicalForm(resourceName);
        boolean shouldAppendTrailingSlash = Resources.hasTrailingSlash(resourceName);
        if (Resources.moduleName(module) == null) {
            for (Module m : RuntimeModuleSupport.instance().getBootLayer().modules()) {
                ResourceStorageEntryBase entry = this.get(m, resourceName, false);
                if (entry == MISSING_METADATA_MARKER) continue;
                missingMetadata = false;
                Resources.addURLEntries(resourcesURLs, (ResourceStorageEntry)entry, m, (String)(shouldAppendTrailingSlash ? canonicalResourceName + "/" : canonicalResourceName));
            }
        }
        if ((explicitEntry = this.get(module, resourceName, false)) != MISSING_METADATA_MARKER) {
            missingMetadata = false;
            Resources.addURLEntries(resourcesURLs, (ResourceStorageEntry)explicitEntry, module, (String)(shouldAppendTrailingSlash ? canonicalResourceName + "/" : canonicalResourceName));
        }
        if (missingMetadata) {
            MissingResourceRegistrationUtils.missingResource(resourceName);
        }
        if (resourcesURLs.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(resourcesURLs);
    }

    private static void addURLEntries(List<URL> resourcesURLs, ResourceStorageEntry entry, Module module, String canonicalResourceName) {
        if (entry == null) {
            return;
        }
        int numberOfResources = entry.getData().size();
        for (int index = 0; index < numberOfResources; ++index) {
            resourcesURLs.add(Resources.createURL(module, canonicalResourceName, index));
        }
    }

    private static boolean matchResource(String pattern, String resource) {
        int i;
        if (pattern.equals(resource)) {
            return true;
        }
        if (!pattern.contains("*")) {
            return false;
        }
        if (pattern.endsWith("*")) {
            return resource.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        String[] parts = pattern.split("\\*");
        boolean found = false;
        for (i = parts.length - 1; i > 0 && !found; --i) {
            found = !parts[i - 1].endsWith("\\");
        }
        if (!found) {
            return false;
        }
        String start = String.join((CharSequence)"*", Arrays.copyOfRange(parts, 0, i + 1));
        String end = String.join((CharSequence)"*", Arrays.copyOfRange(parts, i + 1, parts.length));
        return resource.startsWith(start) && resource.endsWith(end);
    }

    public record ModuleResourcePair(String module, String resource) {
    }
}

