/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK22OrLater;
import com.oracle.svm.core.reflect.fieldaccessor.UnsafeFieldAccessorFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.internal.access.JavaLangReflectAccess;
import jdk.internal.reflect.FieldAccessor;
import jdk.internal.reflect.ReflectionFactory;

@TargetClass(value=ReflectionFactory.class)
final class Target_jdk_internal_reflect_ReflectionFactory {
    @Alias
    private static ReflectionFactory soleInstance;
    @Alias
    private JavaLangReflectAccess langReflectAccess;

    Target_jdk_internal_reflect_ReflectionFactory() {
    }

    @Substitute
    public static ReflectionFactory getReflectionFactory() {
        return soleInstance;
    }

    @Substitute
    public FieldAccessor newFieldAccessor(Field field0, boolean override) {
        boolean isFinal;
        Field field = field0;
        Field root = this.langReflectAccess.getRoot(field);
        if (!(root == null || root.getModifiers() != field.getModifiers() && override)) {
            field = root;
        }
        boolean isReadOnly = (isFinal = Modifier.isFinal(field.getModifiers())) && (!override || this.langReflectAccess.isTrustedFinalField(field));
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, isReadOnly);
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Fold
    static boolean useOldSerializableConstructor() {
        return true;
    }
}

