/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PhysicalMemory {
    private static final long K = 1024L;
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final UnsignedWord UNSET_SENTINEL;
    private static UnsignedWord cachedSize;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInitialized() {
        return cachedSize != UNSET_SENTINEL;
    }

    public static boolean isInitializationInProgress() {
        return LOCK.isHeldByCurrentThread();
    }

    @Uninterruptible(reason="May only be called during early startup.")
    public static void setSize(UnsignedWord value) {
        VMError.guarantee(!PhysicalMemory.isInitialized(), "PhysicalMemorySize must not be initialized yet.");
        cachedSize = value;
    }

    public static UnsignedWord size() {
        if (PhysicalMemory.isInitializationDisallowed()) {
            throw VMError.shouldNotReachHere("Accessing the physical memory size may require allocation and synchronization");
        }
        if (!PhysicalMemory.isInitialized()) {
            long memoryLimit = SubstrateOptions.MaxRAM.getValue();
            if (memoryLimit > 0L) {
                cachedSize = WordFactory.unsigned((long)memoryLimit);
            } else {
                LOCK.lock();
                try {
                    if (!PhysicalMemory.isInitialized()) {
                        memoryLimit = Containers.memoryLimitInBytes();
                        cachedSize = memoryLimit > 0L ? WordFactory.unsigned((long)memoryLimit) : ((PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemorySupport.class)).size();
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return cachedSize;
    }

    public static long usedSize() {
        if (Platform.includedIn(Platform.WINDOWS.class) || Platform.includedIn(Platform.MACOS.class) || Containers.isContainerized() && Containers.memoryLimitInBytes() > 0L) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return osBean.getTotalMemorySize() - osBean.getFreeMemorySize();
        }
        if (Platform.includedIn(Platform.LINUX.class)) {
            return PhysicalMemory.getUsedSizeFromProcMemInfo();
        }
        return -1L;
    }

    private static long getUsedSizeFromProcMemInfo() {
        try {
            List<String> lines = PhysicalMemory.readAllLines("/proc/meminfo");
            for (String line : lines) {
                if (!line.contains("MemAvailable")) continue;
                return PhysicalMemory.size().rawValue() - PhysicalMemory.parseFirstNumber(line) * 1024L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static List<String> readAllLines(String fileName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName, StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static long parseFirstNumber(String str) {
        int firstDigit = -1;
        int lastDigit = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) {
                if (firstDigit == -1) {
                    firstDigit = i;
                }
                lastDigit = i;
                continue;
            }
            if (firstDigit != -1) break;
        }
        if (firstDigit >= 0) {
            String number = str.substring(firstDigit, lastDigit + 1);
            return Long.parseLong(number);
        }
        return -1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCachedSize() {
        VMError.guarantee(PhysicalMemory.isInitialized(), "Cached physical memory size is not available");
        return cachedSize;
    }

    private static boolean isInitializationDisallowed() {
        return Heap.getHeap().isAllocationDisallowed() || VMOperation.isInProgress() || !PlatformThreads.isCurrentAssigned() || StackOverflowCheck.singleton().isYellowZoneAvailable();
    }

    static {
        cachedSize = UNSET_SENTINEL = UnsignedUtils.MAX_VALUE;
    }

    public static interface PhysicalMemorySupport {
        public UnsignedWord size();
    }
}

