/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class StoreVMThreadLocalNode
extends AbstractStateSplit
implements VMThreadLocalAccess,
Lowerable,
SingleMemoryKill,
OrderedMemoryAccess {
    public static final NodeClass<StoreVMThreadLocalNode> TYPE = NodeClass.create(StoreVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    protected final BarrierType barrierType;
    private final MemoryOrderMode memoryOrder;
    @Node.Input
    protected ValueNode holder;
    @Node.Input
    protected ValueNode value;

    public StoreVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(TYPE, StampFactory.forVoid());
        this.threadLocalInfo = threadLocalInfo;
        this.barrierType = barrierType;
        this.memoryOrder = memoryOrder;
        this.holder = holder;
        this.value = value;
    }

    public ValueNode getValue() {
        return this.value;
    }

    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return this.threadLocalInfo.locationIdentity;
    }

    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.graph());
        AddressNode address = (AddressNode)this.graph().unique((Node)new OffsetAddressNode(this.holder, (ValueNode)offset));
        JavaWriteNode write = (JavaWriteNode)this.graph().add((Node)new JavaWriteNode(this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.value, this.barrierType, true, true, this.memoryOrder));
        write.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)write);
        tool.getLowerer().lower((Node)write, tool);
    }
}

