/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.Platform;

public class SubstrateAArch64RegisterConfig
implements SubstrateRegisterConfig {
    private final TargetDescription target;
    private final int nativeParamsStackOffset;
    private final RegisterArray generalParameterRegs;
    private final RegisterArray fpParameterRegs;
    private final RegisterArray allocatableRegs;
    private final RegisterArray calleeSaveRegisters;
    private final RegisterAttributes[] attributesMap;
    private final MetaAccessProvider metaAccess;
    private final boolean preserveFramePointer;
    public static final Register fp = AArch64.r29;

    public SubstrateAArch64RegisterConfig(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, boolean preserveFramePointer) {
        this.target = target;
        this.metaAccess = metaAccess;
        this.preserveFramePointer = preserveFramePointer;
        this.generalParameterRegs = new RegisterArray(new Register[]{AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7});
        this.fpParameterRegs = new RegisterArray(new Register[]{AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7});
        this.nativeParamsStackOffset = 0;
        ArrayList regs = new ArrayList(AArch64.allRegisters.asList());
        regs.remove(ReservedRegisters.singleton().getFrameRegister());
        regs.remove(AArch64.zr);
        regs.remove(AArch64.r8);
        regs.remove(AArch64.r9);
        if (preserveFramePointer) {
            regs.remove(fp);
        }
        regs.remove(AArch64.r31);
        regs.remove(ReservedRegisters.singleton().getHeapBaseRegister());
        regs.remove(ReservedRegisters.singleton().getThreadRegister());
        if (Platform.includedIn(Platform.DARWIN.class) || Platform.includedIn(Platform.WINDOWS.class) || Platform.includedIn(Platform.ANDROID.class)) {
            regs.remove(AArch64.r18);
        }
        this.allocatableRegs = new RegisterArray(regs);
        switch (config) {
            case NORMAL: {
                this.calleeSaveRegisters = new RegisterArray(new Register[0]);
                break;
            }
            case NATIVE_TO_JAVA: {
                this.calleeSaveRegisters = new RegisterArray(new Register[]{AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22, AArch64.r23, AArch64.r24, AArch64.r25, AArch64.r26, AArch64.r27, AArch64.r28, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15});
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)config);
            }
        }
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)AArch64.allRegisters);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: 
            case Object: {
                return AArch64.r0;
            }
            case Float: 
            case Double: {
                return AArch64.v0;
            }
            case Void: {
                return null;
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(kind);
    }

    public RegisterArray getAllocatableRegisters() {
        return this.allocatableRegs;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return this.calleeSaveRegisters;
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.getAllocatableRegisters();
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return true;
    }

    public RegisterAttributes[] getAttributesMap() {
        return this.attributesMap;
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type t, JavaKind kind) {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean shouldPreserveFramePointer() {
        return this.preserveFramePointer;
    }

    private int javaStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        ValueKind valueKind = valueKindFactory.getValueKind(kind.getStackKind());
        int alignment = Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        locations[index] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return currentStackOffset + alignment;
    }

    private int linuxNativeStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        ValueKind valueKind = valueKindFactory.getValueKind(isOutgoing ? kind.getStackKind() : kind);
        int alignment = Math.max(kind.getByteCount(), this.target.wordSize);
        locations[index] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return currentStackOffset + alignment;
    }

    private static int darwinNativeStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        int paramByteSize = kind.getByteCount();
        int alignedStackOffset = NumUtil.roundUp((int)currentStackOffset, (int)paramByteSize);
        locations[index] = StackSlot.get((ValueKind)valueKindFactory.getValueKind(kind), (int)alignedStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return alignedStackOffset + paramByteSize;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type t, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        SubstrateCallingConventionType type = (SubstrateCallingConventionType)t;
        if (type.fixedParameterAssignment != null || type.returnSaving != null) {
            throw VMError.unsupportedFeature("Fixed parameter assignments and return saving are not yet supported on this platform.");
        }
        boolean isEntryPoint = type.nativeABI() && !type.outgoing;
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentFP = 0;
        int currentStackOffset = type.nativeABI() ? this.nativeParamsStackOffset : this.target.wordSize;
        JavaKind[] kinds = new JavaKind[locations.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind;
            kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)parameterTypes[i], this.metaAccess, this.target);
            Register register = null;
            if (type.kind == SubstrateCallingConventionKind.ForwardReturnValue) {
                VMError.guarantee(i == 0, "Method with calling convention ForwardReturnValue cannot have more than one parameter");
                register = this.getReturnRegister(kind);
            } else {
                switch (kind) {
                    case Boolean: 
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Int: 
                    case Long: 
                    case Object: {
                        if (currentGeneral >= this.generalParameterRegs.size()) break;
                        register = this.generalParameterRegs.get(currentGeneral++);
                        break;
                    }
                    case Float: 
                    case Double: {
                        if (currentFP >= this.fpParameterRegs.size()) break;
                        register = this.fpParameterRegs.get(currentFP++);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHereUnexpectedInput(kind);
                    }
                }
            }
            if (register != null) {
                boolean useJavaKind = isEntryPoint && (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.WINDOWS.class));
                locations[i] = register.asValue(valueKindFactory.getValueKind(useJavaKind ? kind : kind.getStackKind()));
                continue;
            }
            if (type.nativeABI()) {
                if (Platform.includedIn(Platform.LINUX.class)) {
                    currentStackOffset = this.linuxNativeStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
                    continue;
                }
                if (Platform.includedIn(Platform.DARWIN.class)) {
                    currentStackOffset = SubstrateAArch64RegisterConfig.darwinNativeStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
                    continue;
                }
                throw VMError.unsupportedPlatform();
            }
            currentStackOffset = this.javaStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : ObjectLayout.getCallSignatureKind(isEntryPoint, (ResolvedJavaType)returnType, this.metaAccess, this.target);
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new SubstrateCallingConvention(type, kinds, currentStackOffset, returnLocation, locations);
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return new RegisterArray(list);
    }

    public RegisterArray getJavaGeneralParameterRegs() {
        return this.generalParameterRegs;
    }
}

