/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;

class AdrpLdrMacroInstructionNativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction;

    AdrpLdrMacroInstructionNativeImagePatcher(AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void patchCode(long methodStartAddress, int relative, byte[] code) {
        long startAddress = methodStartAddress + (long)this.macroInstruction.instructionPosition;
        this.macroInstruction.patch(startAddress, relative, code);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int getOffset() {
        throw VMError.unsupportedFeature("trying to get offset of adrp ldr macro instruction");
    }

    @Override
    public int getLength() {
        throw VMError.unsupportedFeature("trying to get length of adrp ldr macro instruction");
    }
}

