/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.fieldvaluetransformer.BoxingTransformer;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;

public final class FieldOffsetFieldValueTransformer
extends BoxingTransformer
implements FieldValueTransformerWithAvailability {
    private final Field targetField;

    public FieldOffsetFieldValueTransformer(Field targetField, Class<?> returnType) {
        super(returnType);
        this.targetField = targetField;
    }

    @Override
    public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
        return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
    }

    public Object transform(Object receiver, Object originalValue) {
        int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(this.targetField, true);
        if (offset <= 0) {
            throw VMError.shouldNotReachHere("Field is not marked as unsafe accessed: " + String.valueOf(this.targetField));
        }
        return this.box(offset);
    }
}

