/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.DeoptimizationSourcePositionDecoder;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.util.ByteArrayReader;
import java.util.List;
import jdk.graal.compiler.core.common.util.FrequencyEncoder;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeWriter;
import jdk.graal.compiler.graph.NodeSourcePosition;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class DeoptimizationSourcePositionEncoder {
    private final FrequencyEncoder<Object> objectConstants = FrequencyEncoder.createIdentityEncoder();

    public void encodeAndInstall(List<NodeSourcePosition> deoptSourcePositions, CodeInfo target, ReferenceAdjuster adjuster) {
        this.addObjectConstants(deoptSourcePositions);
        Object[] encodedObjectConstants = this.objectConstants.encodeAll(new Object[this.objectConstants.getLength()]);
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        EconomicMap sourcePositionStartOffsets = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        NonmovableArray<Integer> deoptStartOffsets = NonmovableArrays.createIntArray(deoptSourcePositions.size());
        this.encodeSourcePositions(deoptSourcePositions, (EconomicMap<NodeSourcePosition, Long>)sourcePositionStartOffsets, deoptStartOffsets, encodingBuffer);
        NonmovableArray<Byte> deoptEncodings = NonmovableArrays.createByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten()));
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(deoptEncodings));
        DeoptimizationSourcePositionEncoder.install(target, deoptStartOffsets, deoptEncodings, encodedObjectConstants, deoptSourcePositions, adjuster);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
    private static void install(CodeInfo target, NonmovableArray<Integer> deoptStartOffsets, NonmovableArray<Byte> deoptEncodings, Object[] encodedObjectConstants, List<NodeSourcePosition> deoptSourcePositions, ReferenceAdjuster adjuster) {
        NonmovableObjectArray<Object> deoptObjectConstants = adjuster.copyOfObjectArray(encodedObjectConstants);
        RuntimeCodeInfoAccess.setDeoptimizationMetadata(target, deoptStartOffsets, deoptEncodings, deoptObjectConstants);
        DeoptimizationSourcePositionEncoder.afterInstallation(deoptStartOffsets, deoptEncodings, deoptSourcePositions, deoptObjectConstants, adjuster);
    }

    @Uninterruptible(reason="Safe for GC, but called from uninterruptible code.", calleeMustBe=false)
    private static void afterInstallation(NonmovableArray<Integer> deoptStartOffsets, NonmovableArray<Byte> deoptEncodings, List<NodeSourcePosition> deoptSourcePositions, NonmovableObjectArray<Object> deoptObjectConstants, ReferenceAdjuster adjuster) {
        assert (!adjuster.isFinished() || DeoptimizationSourcePositionEncoder.verifyEncoding(deoptSourcePositions, deoptStartOffsets, deoptEncodings, deoptObjectConstants));
    }

    private void addObjectConstants(List<NodeSourcePosition> deoptimzationSourcePositions) {
        EconomicSet processedPositions = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (NodeSourcePosition sourcePosition : deoptimzationSourcePositions) {
            this.addObjectConstants(sourcePosition, (EconomicSet<NodeSourcePosition>)processedPositions);
        }
    }

    private void addObjectConstants(NodeSourcePosition sourcePosition, EconomicSet<NodeSourcePosition> processedPositions) {
        if (sourcePosition == null || processedPositions.contains((Object)sourcePosition)) {
            return;
        }
        this.addObjectConstants(sourcePosition.getCaller(), processedPositions);
        this.objectConstants.addObject((Object)sourcePosition.getMethod());
        processedPositions.add((Object)sourcePosition);
    }

    private void encodeSourcePositions(List<NodeSourcePosition> deoptSourcePositions, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, NonmovableArray<Integer> deoptStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        for (int i = 0; i < deoptSourcePositions.size(); ++i) {
            int startOffset;
            NodeSourcePosition sourcePosition = deoptSourcePositions.get(i);
            if (sourcePosition == null) {
                startOffset = -1;
            } else {
                startOffset = TypeConversion.asS4((long)this.encodeSourcePositions(sourcePosition, sourcePositionStartOffsets, encodingBuffer));
                assert (startOffset > -1) : startOffset;
            }
            NonmovableArrays.setInt(deoptStartOffsets, i, startOffset);
        }
    }

    private long encodeSourcePositions(NodeSourcePosition sourcePosition, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        Long existingAbsoluteOffset = (Long)sourcePositionStartOffsets.get((Object)sourcePosition);
        if (existingAbsoluteOffset != null) {
            return existingAbsoluteOffset;
        }
        long callerAbsoluteOffset = -1L;
        if (sourcePosition.getCaller() != null) {
            callerAbsoluteOffset = this.encodeSourcePositions(sourcePosition.getCaller(), sourcePositionStartOffsets, encodingBuffer);
        }
        long startAbsoluteOffset = encodingBuffer.getBytesWritten();
        long callerRelativeOffset = 0L;
        if (sourcePosition.getCaller() != null) {
            callerRelativeOffset = startAbsoluteOffset - callerAbsoluteOffset;
            assert (callerRelativeOffset > 0L) : sourcePosition;
        }
        encodingBuffer.putUV(callerRelativeOffset);
        encodingBuffer.putSV((long)sourcePosition.getBCI());
        encodingBuffer.putUV((long)this.objectConstants.getIndex((Object)sourcePosition.getMethod()));
        sourcePositionStartOffsets.put((Object)sourcePosition, (Object)startAbsoluteOffset);
        return startAbsoluteOffset;
    }

    private static boolean verifyEncoding(List<NodeSourcePosition> deoptSourcePositions, NonmovableArray<Integer> deoptStartOffsets, NonmovableArray<Byte> deoptEncodings, NonmovableObjectArray<Object> deoptObjectConstants) {
        for (int i = 0; i < deoptSourcePositions.size(); ++i) {
            NodeSourcePosition originalSourcePosition = deoptSourcePositions.get(i);
            NodeSourcePosition decodedSourcePosition = DeoptimizationSourcePositionDecoder.decode(i, deoptStartOffsets, deoptEncodings, deoptObjectConstants);
            DeoptimizationSourcePositionEncoder.verifySourcePosition(originalSourcePosition, decodedSourcePosition);
        }
        return true;
    }

    private static void verifySourcePosition(NodeSourcePosition originalPosition, NodeSourcePosition decodedSourcePosition) {
        if (originalPosition == null) {
            assert (decodedSourcePosition == null);
            return;
        }
        assert (originalPosition.getBCI() == decodedSourcePosition.getBCI()) : decodedSourcePosition;
        assert (originalPosition.getMethod().equals((Object)decodedSourcePosition.getMethod())) : decodedSourcePosition;
        DeoptimizationSourcePositionEncoder.verifySourcePosition(originalPosition.getCaller(), decodedSourcePosition.getCaller());
    }
}

