/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.UnsafeMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={UnsafeMemorySupport.class})
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public class UnsafeMemoryUtil
implements UnsafeMemorySupport {
    public void unsafeCopyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        if (srcBase != null || destBase != null) {
            JavaMemoryUtil.copyOnHeap(srcBase, WordFactory.unsigned((long)srcOffset), destBase, WordFactory.unsigned((long)destOffset), WordFactory.unsigned((long)bytes));
        } else {
            UnmanagedMemoryUtil.copy((Pointer)WordFactory.pointer((long)srcOffset), (Pointer)WordFactory.pointer((long)destOffset), WordFactory.unsigned((long)bytes));
        }
    }

    public void unsafeSetMemory(Object destBase, long destOffset, long bytes, byte bvalue) {
        if (destBase != null) {
            JavaMemoryUtil.fillOnHeap(destBase, destOffset, bytes, bvalue);
        } else {
            JavaMemoryUtil.fill((Pointer)WordFactory.pointer((long)destOffset), WordFactory.unsigned((long)bytes), bvalue);
        }
    }

    public void unsafeCopySwapMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        if (srcBase != null || destBase != null) {
            JavaMemoryUtil.copySwapOnHeap(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
        } else {
            JavaMemoryUtil.copySwap((Pointer)WordFactory.unsigned((long)srcOffset), (Pointer)WordFactory.unsigned((long)destOffset), WordFactory.unsigned((long)bytes), WordFactory.unsigned((long)elemSize));
        }
    }
}

