/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

@AutomaticallyRegisteredFeature
public class MethodHandleFeature
implements InternalFeature {
    private Method memberNameIsMethod;
    private Method memberNameIsConstructor;
    private Method memberNameIsField;
    private Method memberNameGetMethodType;
    private Field lambdaFormLFIdentity;
    private Field lambdaFormLFZero;
    private Field lambdaFormNFIdentity;
    private Field lambdaFormNFZero;
    private Field typedAccessors;
    private Field typedCollectors;
    private Object runtimeMethodTypeInternTable;
    private Method referencedKeySetAdd;
    private MethodHandleInvokerRenamingSubstitutionProcessor substitutionProcessor;

    public void duringSetup(Feature.DuringSetupAccess access) {
        Class memberNameClass = access.findClassByName("java.lang.invoke.MemberName");
        this.memberNameIsMethod = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isMethod", (Class[])new Class[0]);
        this.memberNameIsConstructor = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isConstructor", (Class[])new Class[0]);
        this.memberNameIsField = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isField", (Class[])new Class[0]);
        this.memberNameGetMethodType = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"getMethodType", (Class[])new Class[0]);
        Class lambdaFormClass = access.findClassByName("java.lang.invoke.LambdaForm");
        this.lambdaFormLFIdentity = ReflectionUtil.lookupField((Class)lambdaFormClass, (String)"LF_identity");
        this.lambdaFormLFZero = ReflectionUtil.lookupField((Class)lambdaFormClass, (String)"LF_zero");
        this.lambdaFormNFIdentity = ReflectionUtil.lookupField((Class)lambdaFormClass, (String)"NF_identity");
        this.lambdaFormNFZero = ReflectionUtil.lookupField((Class)lambdaFormClass, (String)"NF_zero");
        Class arrayAccessorClass = access.findClassByName("java.lang.invoke.MethodHandleImpl$ArrayAccessor");
        this.typedAccessors = ReflectionUtil.lookupField((Class)arrayAccessorClass, (String)"TYPED_ACCESSORS");
        Class methodHandleImplClass = access.findClassByName("java.lang.invoke.MethodHandleImpl$Makers");
        this.typedCollectors = ReflectionUtil.lookupField((Class)methodHandleImplClass, (String)"TYPED_COLLECTORS");
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            try {
                Class referencedKeySetClass = access.findClassByName("jdk.internal.util.ReferencedKeySet");
                Method create = ReflectionUtil.lookupMethod((Class)referencedKeySetClass, (String)"create", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE, Supplier.class});
                this.runtimeMethodTypeInternTable = create.invoke(null, false, true, () -> new ConcurrentHashMap(512));
                this.referencedKeySetAdd = ReflectionUtil.lookupMethod((Class)referencedKeySetClass, (String)"add", (Class[])new Class[]{Object.class});
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        } else {
            Class concurrentWeakInternSetClass = access.findClassByName("java.lang.invoke.MethodType$ConcurrentWeakInternSet");
            this.runtimeMethodTypeInternTable = ReflectionUtil.newInstance((Class)concurrentWeakInternSetClass);
            this.referencedKeySetAdd = ReflectionUtil.lookupMethod((Class)concurrentWeakInternSetClass, (String)"add", (Class[])new Class[]{Object.class});
        }
        if (!SubstrateOptions.UseOldMethodHandleIntrinsics.getValue().booleanValue()) {
            FeatureImpl.DuringSetupAccessImpl accessImpl = (FeatureImpl.DuringSetupAccessImpl)access;
            this.substitutionProcessor = new MethodHandleInvokerRenamingSubstitutionProcessor(accessImpl.getBigBang());
            accessImpl.registerSubstitutionProcessor(this.substitutionProcessor);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"getFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplConstantHandlesForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"makeConstantHandle", (Class[])new Class[]{Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplCountingWrapperFunctionsForReflection, new Object[]{access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper")});
        access.registerReachabilityHandler(MethodHandleFeature::registerInvokersFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.Invokers"), (String)"getFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionBoxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"boxExact", (Class[])new Class[]{Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionUnboxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"unbox", (Class[])new Class[]{Wrapper.class, Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionConvertFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"convertPrimitive", (Class[])new Class[]{Wrapper.class, Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionIgnoreForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[0])});
        access.registerClassInitializerReachabilityHandler(MethodHandleFeature::registerDelegatingMHFunctionsForReflection, access.findClassByName("java.lang.invoke.DelegatingMethodHandle"));
        access.registerReachabilityHandler(MethodHandleFeature::registerCallSiteGetTargetForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTargetHandle", (Class[])new Class[0])});
        access.registerReachabilityHandler(MethodHandleFeature::registerUninitializedCallSiteForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSiteHandle", (Class[])new Class[0])});
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::registerVarHandleMethodsForReflection, access.findClassByName("java.lang.invoke.VarHandle"));
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::scanBoundMethodHandle, access.findClassByName("java.lang.invoke.BoundMethodHandle"));
        final AnalysisMetaAccess metaAccess = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getMetaAccess();
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.ClassSpecializer"), (String)"cache"), (FieldValueTransformer)new FieldValueTransformerWithAvailability(){
            private static final Class<?> speciesDataClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.ClassSpecializer$SpeciesData");

            @Override
            public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
                return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
            }

            public Object transform(Object receiver, Object originalValue) {
                ConcurrentHashMap originalMap = (ConcurrentHashMap)originalValue;
                ConcurrentHashMap filteredMap = new ConcurrentHashMap();
                originalMap.forEach((key, speciesData) -> {
                    if (this.isSpeciesReachable(speciesData)) {
                        filteredMap.put(key, speciesData);
                    }
                });
                return filteredMap;
            }

            private boolean isSpeciesReachable(Object speciesData) {
                Class speciesClass = (Class)ReflectionUtil.readField(speciesDataClass, (String)"speciesCode", (Object)speciesData);
                Optional analysisType = metaAccess.optionalLookupJavaType(speciesClass);
                return analysisType.isPresent() && ((AnalysisType)analysisType.get()).isReachable();
            }
        });
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.MethodType"), (String)"internTable"), (receiver, originalValue) -> this.runtimeMethodTypeInternTable);
    }

    private static void registerMHImplFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"checkSpreadArgument", (Class[])new Class[]{Object.class, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"guardWithCatch", (Class[])new Class[]{MethodHandle.class, Class.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"tryFinally", (Class[])new Class[]{MethodHandle.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"loop", (Class[])new Class[]{access.findClassByName("[Ljava.lang.invoke.LambdaForm$BasicType;"), access.findClassByName("java.lang.invoke.MethodHandleImpl$LoopClauses"), Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"throwException", (Class[])new Class[]{Throwable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"profileBoolean", (Class[])new Class[]{Boolean.TYPE, int[].class})});
    }

    private static void registerMHImplConstantHandlesForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"selectAlternative", (Class[])new Class[]{Boolean.TYPE, MethodHandle.class, MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopPredicate", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopStep", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"initIterator", (Class[])new Class[]{Iterable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iteratePredicate", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iterateNext", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(Array.class, (String)"newInstance", (Class[])new Class[]{Class.class, Integer.TYPE})});
    }

    private static void registerMHImplCountingWrapperFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper"), (String)"maybeStopCounting", (Class[])new Class[]{Object.class})});
    }

    private static void registerInvokersFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class invokersClazz = access.findClassByName("java.lang.invoke.Invokers");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkExactType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkGenericType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"getCallSiteTarget", (Class[])new Class[]{CallSite.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkCustomized", (Class[])new Class[]{MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleGenericType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleExactType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"directVarHandleTarget", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle")})});
    }

    private static void registerValueConversionBoxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("box" + type.wrapperSimpleName()), (Class[])new Class[]{type.primitiveType()})});
        }
    }

    private static void registerValueConversionUnboxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{type.wrapperType()})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{Object.class, Boolean.TYPE})});
        }
    }

    private static void registerValueConversionConvertFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper src : Wrapper.values()) {
            for (Wrapper dest : Wrapper.values()) {
                if (src == dest || !src.primitiveType().isPrimitive() || src == Wrapper.VOID || !dest.primitiveType().isPrimitive() || dest == Wrapper.VOID) continue;
                RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)MethodHandleFeature.valueConverterName(src, dest), (Class[])new Class[]{src.primitiveType()})});
            }
        }
    }

    private static String valueConverterName(Wrapper src, Wrapper dest) {
        String srcType = src.primitiveSimpleName();
        String destType = dest.primitiveSimpleName();
        return srcType + "To" + destType.substring(0, 1).toUpperCase() + destType.substring(1);
    }

    private static void registerValueConversionIgnoreForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[]{Object.class})});
    }

    private static void registerDelegatingMHFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class delegatingMHClazz = access.findClassByName("java.lang.invoke.DelegatingMethodHandle");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)delegatingMHClazz, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerCallSiteGetTargetForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerUninitializedCallSiteForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSite", (Class[])new Class[]{Object[].class})});
    }

    private static void registerVarHandleMethodsForReflection(Feature.FeatureAccess access, Class<?> subtype) {
        if (subtype.getPackage().getName().equals("java.lang.invoke") && subtype != access.findClassByName("java.lang.invoke.VarHandle")) {
            RuntimeReflection.register((Executable[])subtype.getDeclaredMethods());
        }
    }

    public void registerHeapMethodType(MethodType methodType) {
        try {
            this.referencedKeySetAdd.invoke(this.runtimeMethodTypeInternTable, methodType);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void registerHeapMemberName(Member memberName) {
        try {
            Class<?> declaringClass = memberName.getDeclaringClass();
            boolean isMethod = (Boolean)this.memberNameIsMethod.invoke((Object)memberName, new Object[0]);
            boolean isConstructor = (Boolean)this.memberNameIsConstructor.invoke((Object)memberName, new Object[0]);
            boolean isField = (Boolean)this.memberNameIsField.invoke((Object)memberName, new Object[0]);
            String name = isMethod || isField ? memberName.getName() : null;
            Class<?>[] paramTypes = null;
            if (isMethod || isConstructor) {
                MethodType methodType = (MethodType)this.memberNameGetMethodType.invoke((Object)memberName, new Object[0]);
                paramTypes = methodType.parameterArray();
            }
            if (isMethod) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredMethod(name, paramTypes)});
            } else if (isConstructor) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredConstructor(paramTypes)});
            } else if (isField) {
                RuntimeReflection.register((Field[])new Field[]{declaringClass.getDeclaredField(name)});
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException declaringClass) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.rescanRoot(this.lambdaFormLFIdentity);
        access.rescanRoot(this.lambdaFormLFZero);
        access.rescanRoot(this.lambdaFormNFIdentity);
        access.rescanRoot(this.lambdaFormNFZero);
        access.rescanRoot(this.typedAccessors);
        access.rescanRoot(this.typedCollectors);
        access.rescanObject(this.runtimeMethodTypeInternTable);
    }

    private static void scanBoundMethodHandle(Feature.DuringAnalysisAccess a, Class<?> bmhSubtype) {
        for (Field field : bmhSubtype.getDeclaredFields()) {
            if (!field.getName().startsWith("arg")) continue;
            RuntimeReflection.register((Field[])new Field[]{field});
            if (field.getType().isPrimitive()) continue;
            field.setAccessible(true);
        }
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.getBigBang().postTask(unused -> {
            Field bmhSpeciesField = ReflectionUtil.lookupField((boolean)true, (Class)bmhSubtype, (String)"BMH_SPECIES");
            if (bmhSpeciesField != null) {
                access.rescanRoot(bmhSpeciesField);
            }
        });
        if (!access.getBigBang().executorIsStarted()) {
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (this.substitutionProcessor == null || this.substitutionProcessor.checkAllTypeNames());
    }
}

