/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.management.LibManagementExtSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class JNIRegistrationManagementExt
extends JNIRegistrationUtil
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JNIRegistrationManagementExt.rerunClassInit((Feature.FeatureAccess)access, "com.sun.management.internal.OperatingSystemImpl");
        access.registerReachabilityHandler(this::linkManagementExt, new Object[]{JNIRegistrationManagementExt.clazz((Feature.FeatureAccess)access, "com.sun.management.internal.OperatingSystemImpl")});
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_management_internal_OperatingSystemImpl");
    }

    private void linkManagementExt(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)access).getNativeLibraries();
        nativeLibraries.addStaticNonJniLibrary("management_ext", "java");
        if (JNIRegistrationManagementExt.isWindows()) {
            nativeLibraries.addDynamicNonJniLibrary("psapi");
        } else {
            Method method = ReflectionUtil.lookupMethod(LibManagementExtSupport.class, (String)"throwInternalError", (Class[])new Class[]{IsolateThread.class, CCharPointer.class});
            CEntryPointCallStubSupport.singleton().registerStubForMethod(method, () -> CEntryPointData.create(method));
        }
    }
}

