/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class SubstrateInstalledCodeImpl
extends InstalledCode
implements SubstrateInstalledCode {
    public SubstrateInstalledCodeImpl(SharedRuntimeMethod method) {
        super(method.format("%H.%n#(%p)"));
    }

    public SubstrateInstalledCodeImpl(String name, SharedRuntimeMethod method) {
        super(name != null ? name : method.format("%H.%n#(%p)"));
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return null;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getAddress() {
        return this.address;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAlive() {
        return this.address != 0L;
    }

    @Override
    public void setAddress(long address, long entryPoint, ResolvedJavaMethod method) {
        assert (VMOperation.isInProgressAtSafepoint());
        this.address = address;
        this.entryPoint = entryPoint;
    }

    @Override
    public void clearAddress() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.entryPoint = 0L;
        this.address = 0L;
    }

    @Override
    public void invalidate() {
        CodeInfoTable.invalidateInstalledCode(this);
    }

    @Override
    public void invalidateWithoutDeoptimization() {
        assert (VMOperation.isInProgressAtSafepoint());
        throw VMError.unimplemented("cannot invalidate without deoptimization");
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return null;
    }

    @Override
    public void setCompilationId(CompilationIdentifier id) {
    }

    public long getStart() {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }

    public byte[] getCode() {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }

    public Object executeVarargs(Object ... args) {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }
}

