/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.UnsignedWord;

public interface StackOverflowCheck {
    @Fold
    public static StackOverflowCheck singleton() {
        return (StackOverflowCheck)ImageSingletons.lookup(StackOverflowCheck.class);
    }

    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public boolean initialize();

    public boolean isWithinBounds(UnsignedWord var1);

    public void makeYellowZoneAvailable();

    public boolean isYellowZoneAvailable();

    public void protectYellowZone();

    public int yellowAndRedZoneSize();

    public int getState();

    public void setState(int var1);

    @Uninterruptible(reason="Called by fatal error handling that is uninterruptible.")
    public void disableStackOverflowChecksForFatalError();

    public void updateStackOverflowBoundary();

    public UnsignedWord getStackOverflowBoundary();

    public static interface PlatformSupport {
        @Fold
        public static PlatformSupport singleton() {
            return (PlatformSupport)ImageSingletons.lookup(PlatformSupport.class);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean lookupStack(WordPointer var1, WordPointer var2);
    }

    public static class Options {
        public static final HostedOptionKey<Integer> StackYellowZoneSize = new HostedOptionKey<Integer>(32768);
        public static final HostedOptionKey<Integer> StackRedZoneSize = new HostedOptionKey<Integer>(8192);
    }
}

