/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.ReflectionMetadataDecoder;
import com.oracle.svm.core.reflect.Target_java_lang_reflect_RecordComponent;
import com.oracle.svm.core.reflect.target.ReflectionMetadataEncoding;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Parameter;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.function.Function;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredImageSingleton(value={ReflectionMetadataDecoder.class})
public class ReflectionMetadataDecoderImpl
implements ReflectionMetadataDecoder {
    public static final int FIRST_ERROR_INDEX = -2;
    public static final int NO_METHOD_METADATA = -1;
    public static final int NULL_OBJECT = -1;
    public static final int COMPLETE_FLAG_INDEX = 31;
    public static final int COMPLETE_FLAG_MASK = Integer.MIN_VALUE;
    public static final int IN_HEAP_FLAG_INDEX = 30;
    public static final int IN_HEAP_FLAG_MASK = 0x40000000;
    public static final int HIDING_FLAG_INDEX = 29;
    public static final int HIDING_FLAG_MASK = 0x20000000;
    public static final int NEGATIVE_FLAG_INDEX = 28;
    public static final int NEGATIVE_FLAG_MASK = 0x10000000;
    public static final int ALL_FLAGS_MASK = -268435456;
    public static final int ALL_FIELDS_FLAG = 65536;
    public static final int ALL_DECLARED_FIELDS_FLAG = 131072;
    public static final int ALL_METHODS_FLAG = 262144;
    public static final int ALL_DECLARED_METHODS_FLAG = 524288;
    public static final int ALL_CONSTRUCTORS_FLAG = 0x100000;
    public static final int ALL_DECLARED_CONSTRUCTORS_FLAG = 0x200000;
    public static final int ALL_CLASSES_FLAG = 0x400000;
    public static final int ALL_DECLARED_CLASSES_FLAG = 0x800000;
    public static final int ALL_RECORD_COMPONENTS_FLAG = 0x1000000;
    public static final int ALL_PERMITTED_SUBCLASSES_FLAG = 0x2000000;
    public static final int ALL_NEST_MEMBERS_FLAG = 0x4000000;
    public static final int ALL_SIGNERS_FLAG = 0x8000000;
    public static final int CLASS_ACCESS_FLAGS_MASK = 8191;

    static byte[] getEncoding() {
        return ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).getEncoding();
    }

    @Override
    public Field[] parseFields(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Field.class, i -> (Field)ReflectionMetadataDecoderImpl.decodeField(reader, DynamicHub.toClass(declaringType), publicOnly, true));
    }

    @Override
    public ReflectionMetadataDecoder.FieldDescriptor[] parseReachableFields(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, ReflectionMetadataDecoder.FieldDescriptor.class, i -> (ReflectionMetadataDecoder.FieldDescriptor)ReflectionMetadataDecoderImpl.decodeField(reader, DynamicHub.toClass(declaringType), false, false));
    }

    @Override
    public Method[] parseMethods(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Method.class, i -> (Method)ReflectionMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), publicOnly, true, true));
    }

    @Override
    public ReflectionMetadataDecoder.MethodDescriptor[] parseReachableMethods(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, ReflectionMetadataDecoder.MethodDescriptor.class, i -> (ReflectionMetadataDecoder.MethodDescriptor)ReflectionMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), false, false, true));
    }

    @Override
    public Constructor<?>[] parseConstructors(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Constructor.class, i -> (Constructor)ReflectionMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), publicOnly, true, false));
    }

    @Override
    public ReflectionMetadataDecoder.ConstructorDescriptor[] parseReachableConstructors(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, ReflectionMetadataDecoder.ConstructorDescriptor.class, i -> (ReflectionMetadataDecoder.ConstructorDescriptor)ReflectionMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), false, false, false));
    }

    @Override
    public Class<?>[] parseClasses(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(reader));
    }

    @Override
    public Target_java_lang_reflect_RecordComponent[] parseRecordComponents(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Target_java_lang_reflect_RecordComponent.class, i -> ReflectionMetadataDecoderImpl.decodeRecordComponent(reader, DynamicHub.toClass(declaringType)));
    }

    @Override
    public Object[] parseObjects(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Object.class, i -> ReflectionMetadataDecoderImpl.decodeObject(reader));
    }

    @Override
    public Parameter[] parseReflectParameters(Executable executable, byte[] encoding) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])encoding, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Parameter.class, i -> ReflectionMetadataDecoderImpl.decodeReflectParameter(reader, executable, i));
    }

    @Override
    public Object[] parseEnclosingMethod(int index) {
        if (ReflectionMetadataDecoderImpl.isErrorIndex(index)) {
            ReflectionMetadataDecoderImpl.decodeAndThrowError(index);
        }
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        Class<?> declaringClass = ReflectionMetadataDecoderImpl.decodeType(reader);
        String name = ReflectionMetadataDecoderImpl.decodeName(reader);
        String descriptor = ReflectionMetadataDecoderImpl.decodeName(reader);
        return new Object[]{declaringClass, name, descriptor};
    }

    @Override
    public byte[] parseByteArray(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeByteArray(reader);
    }

    @Override
    public boolean isHiding(int modifiers) {
        return (modifiers & 0x20000000) != 0;
    }

    @Override
    public boolean isNegative(int modifiers) {
        return (modifiers & 0x10000000) != 0;
    }

    @Override
    public int getMetadataByteLength() {
        return ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).getEncoding().length;
    }

    public static boolean isErrorIndex(int index) {
        return index < -1;
    }

    private static <T extends Throwable> void decodeAndThrowError(int index) throws T {
        assert (ReflectionMetadataDecoderImpl.isErrorIndex(index));
        int decodedIndex = -2 - index;
        throw (Throwable)((ReflectionMetadataDecoder.MetadataAccessor)ImageSingletons.lookup(ReflectionMetadataDecoder.MetadataAccessor.class)).getObject(decodedIndex);
    }

    private static Object decodeField(UnsafeArrayTypeReader buf, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly) {
        Class<?> type;
        boolean negative;
        boolean hiding;
        boolean complete;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean bl = complete = (modifiers & Integer.MIN_VALUE) != 0;
        if (inHeap) {
            Field field = (Field)ReflectionMetadataDecoderImpl.decodeObject(buf);
            if (publicOnly && !Modifier.isPublic(field.getModifiers())) {
                Target_java_lang_reflect_Field negativeField = new Target_java_lang_reflect_Field();
                negativeField.constructor(declaringClass, field.getName(), Object.class, field.getModifiers() | 0x10000000, false, -1, null, null);
                field = SubstrateUtil.cast(negativeField, Field.class);
            }
            if (reflectOnly) {
                return complete ? field : null;
            }
            return new ReflectionMetadataDecoder.FieldDescriptor(field);
        }
        boolean bl2 = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        boolean bl3 = negative = (modifiers & 0x10000000) != 0;
        assert (!negative || !complete && !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = ReflectionMetadataDecoderImpl.decodeName(buf);
        Class<Object> clazz = type = complete || hiding ? ReflectionMetadataDecoderImpl.decodeType(buf) : null;
        if (!complete) {
            if (reflectOnly != (hiding || negative)) {
                return null;
            }
            if (!reflectOnly) {
                return new ReflectionMetadataDecoder.FieldDescriptor(declaringClass, name);
            }
            Target_java_lang_reflect_Field field = new Target_java_lang_reflect_Field();
            field.constructor(declaringClass, name, negative ? Object.class : type, modifiers, false, -1, null, null);
            return SubstrateUtil.cast(field, Field.class);
        }
        boolean trustedFinal = buf.getU1() == 1;
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        int offset = buf.getSVInt();
        String deletedReason = ReflectionMetadataDecoderImpl.decodeName(buf);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            modifiers |= 0x10000000;
        }
        Target_java_lang_reflect_Field field = new Target_java_lang_reflect_Field();
        field.constructor(declaringClass, name, type, modifiers, trustedFinal, -1, signature, annotations);
        field.offset = offset;
        field.deletedReason = deletedReason;
        SubstrateUtil.cast((Object)field, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations = typeAnnotations;
        Field reflectField = SubstrateUtil.cast(field, Field.class);
        return reflectOnly ? reflectField : new ReflectionMetadataDecoder.FieldDescriptor(reflectField);
    }

    private static Object decodeExecutable(UnsafeArrayTypeReader buf, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly, boolean isMethod) {
        Target_java_lang_reflect_Executable executable;
        Class<?> returnType;
        boolean negative;
        boolean hiding;
        boolean complete;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean bl = complete = (modifiers & Integer.MIN_VALUE) != 0;
        if (inHeap) {
            Executable executable2 = (Executable)ReflectionMetadataDecoderImpl.decodeObject(buf);
            if (publicOnly && !Modifier.isPublic(executable2.getModifiers())) {
                if (isMethod) {
                    Target_java_lang_reflect_Method negativeMethod = new Target_java_lang_reflect_Method();
                    negativeMethod.constructor(declaringClass, executable2.getName(), executable2.getParameterTypes(), Object.class, null, modifiers | 0x10000000, -1, null, null, null, null);
                    executable2 = SubstrateUtil.cast(negativeMethod, Executable.class);
                } else {
                    Target_java_lang_reflect_Constructor negativeConstructor = new Target_java_lang_reflect_Constructor();
                    negativeConstructor.constructor(declaringClass, executable2.getParameterTypes(), null, modifiers | 0x10000000, -1, null, null, null);
                    executable2 = SubstrateUtil.cast(negativeConstructor, Executable.class);
                }
            }
            if (reflectOnly) {
                return complete ? executable2 : null;
            }
            if (isMethod) {
                Method method = (Method)executable2;
                return new ReflectionMetadataDecoder.MethodDescriptor(method);
            }
            Constructor constructor = (Constructor)executable2;
            return new ReflectionMetadataDecoder.ConstructorDescriptor(constructor);
        }
        boolean bl2 = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        boolean bl3 = negative = (modifiers & 0x10000000) != 0;
        assert (!negative || !complete && !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = isMethod ? ReflectionMetadataDecoderImpl.decodeName(buf) : null;
        Object[] parameterTypes = complete || hiding || negative ? ReflectionMetadataDecoderImpl.decodeArray(buf, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(buf)) : ReflectionMetadataDecoderImpl.decodeArray(buf, String.class, i -> ReflectionMetadataDecoderImpl.decodeName(buf));
        Class<?> clazz = returnType = isMethod && (complete || hiding) ? ReflectionMetadataDecoderImpl.decodeType(buf) : null;
        if (!complete) {
            if (reflectOnly != (hiding || negative)) {
                return null;
            }
            if (isMethod) {
                if (!reflectOnly) {
                    return new ReflectionMetadataDecoder.MethodDescriptor(declaringClass, name, (String[])parameterTypes);
                }
                Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
                method.constructor(declaringClass, name, (Class[])parameterTypes, negative ? Object.class : returnType, null, modifiers, -1, null, null, null, null);
                return SubstrateUtil.cast(method, Executable.class);
            }
            if (!reflectOnly) {
                return new ReflectionMetadataDecoder.ConstructorDescriptor(declaringClass, (String[])parameterTypes);
            }
            Target_java_lang_reflect_Constructor constructor = new Target_java_lang_reflect_Constructor();
            constructor.constructor(declaringClass, (Class[])parameterTypes, null, modifiers, -1, null, null, null);
            return SubstrateUtil.cast(constructor, Executable.class);
        }
        Class[] exceptionTypes = ReflectionMetadataDecoderImpl.decodeArray(buf, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(buf));
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] parameterAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] annotationDefault = isMethod && declaringClass.isAnnotation() ? ReflectionMetadataDecoderImpl.decodeByteArray(buf) : null;
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] reflectParameters = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        Object accessor = ReflectionMetadataDecoderImpl.decodeObject(buf);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            modifiers |= 0x10000000;
        }
        if (isMethod) {
            Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
            method.constructor(declaringClass, name, (Class[])parameterTypes, returnType, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations, annotationDefault);
            method.methodAccessor = (Target_jdk_internal_reflect_MethodAccessor)accessor;
            if (!reflectOnly) {
                return new ReflectionMetadataDecoder.MethodDescriptor(SubstrateUtil.cast(method, Method.class));
            }
            executable = SubstrateUtil.cast(method, Target_java_lang_reflect_Executable.class);
        } else {
            Target_java_lang_reflect_Constructor constructor = new Target_java_lang_reflect_Constructor();
            constructor.constructor(declaringClass, (Class[])parameterTypes, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations);
            constructor.constructorAccessor = (Target_jdk_internal_reflect_ConstructorAccessor)accessor;
            if (!reflectOnly) {
                return new ReflectionMetadataDecoder.ConstructorDescriptor(SubstrateUtil.cast(constructor, Constructor.class));
            }
            executable = SubstrateUtil.cast(constructor, Target_java_lang_reflect_Executable.class);
        }
        executable.rawParameters = reflectParameters;
        SubstrateUtil.cast((Object)executable, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations = typeAnnotations;
        return SubstrateUtil.cast(executable, Executable.class);
    }

    private static Target_java_lang_reflect_RecordComponent decodeRecordComponent(UnsafeArrayTypeReader buf, Class<?> declaringClass) {
        String name = ReflectionMetadataDecoderImpl.decodeName(buf);
        Class<?> type = ReflectionMetadataDecoderImpl.decodeType(buf);
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        Target_java_lang_reflect_RecordComponent recordComponent = new Target_java_lang_reflect_RecordComponent();
        recordComponent.clazz = declaringClass;
        recordComponent.name = name;
        recordComponent.type = type;
        recordComponent.signature = signature;
        try {
            recordComponent.accessor = declaringClass.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere("Record component accessors should have been registered by the analysis.");
        }
        recordComponent.annotations = annotations;
        recordComponent.typeAnnotations = typeAnnotations;
        return recordComponent;
    }

    private static Parameter decodeReflectParameter(UnsafeArrayTypeReader buf, Executable executable, int i) {
        String name = ReflectionMetadataDecoderImpl.decodeName(buf);
        int modifiers = buf.getUVInt();
        Target_java_lang_reflect_Parameter parameter = new Target_java_lang_reflect_Parameter();
        parameter.constructor(name, modifiers, executable, i);
        return SubstrateUtil.cast(parameter, Parameter.class);
    }

    private static Class<?> decodeType(UnsafeArrayTypeReader buf) {
        int classIndex = buf.getSVInt();
        if (classIndex == -1) {
            return null;
        }
        return ((ReflectionMetadataDecoder.MetadataAccessor)ImageSingletons.lookup(ReflectionMetadataDecoder.MetadataAccessor.class)).getClass(classIndex);
    }

    private static String decodeName(UnsafeArrayTypeReader buf) {
        int nameIndex = buf.getSVInt();
        String name = ((ReflectionMetadataDecoder.MetadataAccessor)ImageSingletons.lookup(ReflectionMetadataDecoder.MetadataAccessor.class)).getString(nameIndex);
        return name == null ? null : name.intern();
    }

    private static Object decodeObject(UnsafeArrayTypeReader buf) {
        int objectIndex = buf.getSVInt();
        if (objectIndex == -1) {
            return null;
        }
        return ((ReflectionMetadataDecoder.MetadataAccessor)ImageSingletons.lookup(ReflectionMetadataDecoder.MetadataAccessor.class)).getObject(objectIndex);
    }

    private static <T> T[] decodeArray(UnsafeArrayTypeReader buf, Class<T> elementType, Function<Integer, T> elementDecoder) {
        int length = buf.getSVInt();
        if (ReflectionMetadataDecoderImpl.isErrorIndex(length)) {
            ReflectionMetadataDecoderImpl.decodeAndThrowError(length);
        }
        Object[] result = (Object[])Array.newInstance(elementType, length);
        int valueCount = 0;
        for (int i = 0; i < length; ++i) {
            T element = elementDecoder.apply(i);
            if (element == null) continue;
            result[valueCount++] = element;
        }
        return Arrays.copyOf(result, valueCount);
    }

    private static byte[] decodeByteArray(UnsafeArrayTypeReader buf) {
        int length = buf.getUVInt();
        if (length == -1) {
            return null;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buf.getS1();
        }
        return result;
    }

    @AutomaticallyRegisteredImageSingleton(value={ReflectionMetadataDecoder.MetadataAccessor.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public static class MetadataAccessorImpl
    implements ReflectionMetadataDecoder.MetadataAccessor {
        @Override
        public <T> T getObject(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return (T)NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoObjectConstants(info), index);
        }

        @Override
        public Class<?> getClass(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(info), index);
        }

        @Override
        public String getString(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            String name = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(info), index);
            return name;
        }

        private static CodeInfo getCodeInfo() {
            return CodeInfoTable.getImageCodeInfo();
        }
    }
}

