/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.linux.LinuxVMSemaphore;
import com.oracle.svm.core.posix.linux.LinuxVMSemaphoreSupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class LinuxVMSemaphoreFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(this, VMSemaphore.class){

        @Override
        protected VMSemaphore createReplacement(VMSemaphore source) {
            return new LinuxVMSemaphore(source.getName());
        }
    };

    LinuxVMSemaphoreFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(PosixVMSemaphoreSupport.class, (Object)new LinuxVMSemaphoreSupport());
        access.registerObjectReplacer(this.semaphoreReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        LinuxVMSemaphoreSupport semaphoreSupport = (LinuxVMSemaphoreSupport)PosixVMSemaphoreSupport.singleton();
        semaphoreSupport.semaphores = this.semaphoreReplacer.getReplacements().toArray(new LinuxVMSemaphore[0]);
    }
}

