/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.IsolateListenerSupportFeature;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jfr.JfrExecutionSamplerSupported;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.posix.PosixSubstrateSigprofHandler;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.ThreadListenerSupportFeature;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class PosixSubstrateSigProfHandlerFeature
implements InternalFeature {
    PosixSubstrateSigProfHandlerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(ThreadListenerSupportFeature.class, IsolateListenerSupportFeature.class, JfrFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (JfrExecutionSamplerSupported.isSupported() && PosixSubstrateSigprofHandler.isSignalHandlerBasedExecutionSamplerEnabled()) {
            PosixSubstrateSigprofHandler sampler = new PosixSubstrateSigprofHandler();
            ImageSingletons.add(JfrExecutionSampler.class, (Object)sampler);
            ImageSingletons.add(SubstrateSigprofHandler.class, (Object)sampler);
            ThreadListenerSupport.get().register(sampler);
            IsolateListenerSupport.singleton().register(sampler);
        }
    }
}

