/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class, onlyWith={JDK21OrEarlier.class, HasJfrSupport.class})
final class Target_jdk_jfr_internal_JVM_JDK21 {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private volatile boolean nativeOK;

    Target_jdk_jfr_internal_JVM_JDK21() {
    }

    @Substitute
    public void markChunkFinal() {
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    public void beginRecording() {
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    public boolean isRecording() {
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    public void endRecording() {
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    public List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    public long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    public String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    public long getStackTraceId(int skipCount) {
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    public long getThreadId(Thread t) {
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    public long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    public synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    public void setEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setFileNotification(long delta) {
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    public void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    public void setGlobalBufferSize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    public void setMemorySize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    public void setMethodSamplingPeriod(long type, long intervalMillis) {
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    public void setOutput(String file) {
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    public void setForceInstrumentation(boolean force) {
    }

    @Substitute
    public void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    public void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    public void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    public boolean setThreshold(long eventTypeId, long ticks) {
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    public void storeMetadataDescriptor(byte[] bytes) {
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    public boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    private boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    private boolean destroyJFR() {
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    public boolean isAvailable() {
        return true;
    }

    @Substitute
    public double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    public long getTypeId(Class<?> clazz) {
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public void flush() {
        SubstrateJVM.get().flush();
    }

    @Substitute
    public void setRepositoryLocation(String dirText) {
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    public void setDumpPath(String dumpPathText) {
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    public String getDumpPath() {
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    public void abort(String errorMsg) {
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    public boolean setCutoff(long eventTypeId, long cutoffTicks) {
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    public boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        return true;
    }

    @Substitute
    public void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
    }

    @Substitute
    public boolean shouldRotateDisk() {
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    public void include(Thread thread) {
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    public void exclude(Thread thread) {
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    public boolean isExcluded(Thread thread) {
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    public boolean isExcluded(Class<? extends Event> eventClass) {
        return false;
    }

    @Substitute
    public boolean isInstrumented(Class<? extends Event> eventClass) {
        return true;
    }

    @Substitute
    public long getChunkStartNanos() {
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    public boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    public Object getConfiguration(Class<? extends Event> eventClass) {
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    public long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    public boolean isContainerized() {
        return Containers.isContainerized();
    }

    @Substitute
    public long hostTotalMemory() {
        return 0L;
    }
}

