/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;
import sun.util.resources.Bundles;

public class LocalizationSupport {
    public final Map<String, Charset> charsets = new HashMap<String, Charset>();
    public final Locale defaultLocale;
    public final Locale[] allLocales;
    public final Set<String> supportedLanguageTags;
    public final ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    public final Charset defaultCharset;

    public LocalizationSupport(Locale defaultLocale, Set<Locale> locales, Charset defaultCharset) {
        this.defaultLocale = defaultLocale;
        this.allLocales = locales.toArray(new Locale[0]);
        this.defaultCharset = defaultCharset;
        this.supportedLanguageTags = locales.stream().map(Locale::toString).collect(Collectors.toSet());
    }

    public boolean optimizedMode() {
        return false;
    }

    public boolean jvmMode() {
        return !this.optimizedMode();
    }

    public boolean substituteLoadLookup() {
        return false;
    }

    public OptimizedLocalizationSupport asOptimizedSupport() {
        GraalError.guarantee((boolean)this.optimizedMode(), (String)"Optimized support only available in optimized localization mode.");
        return (OptimizedLocalizationSupport)this;
    }

    public Map<String, Object> getBundleContentOf(Object bundle) {
        throw VMError.unsupportedFeature("Resource bundle lookup must be loaded during native image generation: " + String.valueOf(bundle.getClass()));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Function<String, Optional<Module>> findModule, Locale locale) {
        this.registerRequiredReflectionAndResourcesForBundle(bundleName, Set.of(locale));
        if (!(bundle instanceof PropertyResourceBundle)) {
            this.registerNullaryConstructor(bundle.getClass());
        }
        if (bundle instanceof PropertyResourceBundle) {
            String[] bundleNameWithModule = SubstrateUtil.split(bundleName, ":", 2);
            if (bundleNameWithModule.length < 2) {
                String resourceName = StringUtil.toSlashSeparated((String)this.control.toBundleName(bundleName, locale)).concat(".properties");
                Map<String, Set<Module>> packageToModules = ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).getPackageToModules();
                Set modules = packageToModules.getOrDefault(LocalizationSupport.packageName(bundleName), Collections.emptySet());
                for (Module m2 : modules) {
                    ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(m2, resourceName);
                }
                if (modules.isEmpty()) {
                    ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(null, resourceName);
                }
            } else if (findModule != null) {
                String resourceName = StringUtil.toSlashSeparated((String)this.control.toBundleName(bundleNameWithModule[1], locale)).concat(".properties");
                Optional<Module> module = findModule.apply(bundleNameWithModule[0]);
                String finalResourceName = resourceName;
                module.ifPresent(m -> ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(m, finalResourceName));
            }
        }
        this.onBundlePrepared(bundle);
    }

    private static String packageName(String bundleName) {
        String uniformBundleName = StringUtil.toDotSeparated((String)bundleName);
        int classSep = uniformBundleName.lastIndexOf(46);
        if (classSep == -1) {
            return "";
        }
        return uniformBundleName.substring(0, classSep);
    }

    public String getResultingPattern(String bundleName, Locale locale) {
        String fixedBundleName = bundleName.replace("$", "\\$");
        return this.getBundleName(fixedBundleName, locale);
    }

    private String getBundleName(String fixedBundleName, Locale locale) {
        String[] bundleNameWithModule = SubstrateUtil.split(fixedBundleName, ":", 2);
        if (bundleNameWithModule.length < 2) {
            return StringUtil.toSlashSeparated((String)this.control.toBundleName(fixedBundleName, locale));
        }
        String patternWithLocale = StringUtil.toSlashSeparated((String)this.control.toBundleName(bundleNameWithModule[1], locale));
        return bundleNameWithModule[0] + ":" + patternWithLocale;
    }

    public void registerRequiredReflectionAndResourcesForBundle(String baseName, Collection<Locale> wantedLocales) {
        int i = baseName.lastIndexOf(46);
        if (i > 0) {
            String name = baseName.substring(i + 1) + "Provider";
            String providerName = baseName.substring(0, i) + ".spi." + name;
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(ConfigurationCondition.alwaysTrue(), providerName);
        }
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(ConfigurationCondition.alwaysTrue(), baseName);
        for (Locale locale : wantedLocales) {
            this.registerRequiredReflectionAndResourcesForBundleAndLocale(baseName, locale);
        }
    }

    private void registerRequiredReflectionAndResourcesForBundleAndLocale(String baseName, Locale baseLocale) {
        for (Locale locale : this.control.getCandidateLocales(baseName, baseLocale)) {
            String bundleWithLocale = this.control.toBundleName(baseName, locale);
            RuntimeReflection.registerClassLookup((String)bundleWithLocale);
            Resources.singleton().registerNegativeQuery(bundleWithLocale.replace('.', '/') + ".properties");
            String otherBundleName = Bundles.toOtherBundleName(baseName, bundleWithLocale, locale);
            if (otherBundleName.equals(bundleWithLocale)) continue;
            RuntimeReflection.registerClassLookup((String)otherBundleName);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onBundlePrepared(ResourceBundle bundle) {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onClassBundlePrepared(Class<?> bundleClass) {
    }

    public boolean shouldSubstituteLoadLookup(String className) {
        return false;
    }

    public void prepareNonCompliant(Class<?> clazz) throws ReflectiveOperationException {
    }

    public boolean isNotIncluded(String bundleName) {
        return false;
    }

    public static Locale parseLocaleFromTag(String tag) {
        try {
            return new Locale.Builder().setLanguageTag(tag).build();
        }
        catch (IllformedLocaleException ex) {
            String[] parts = tag.split("-");
            switch (parts.length) {
                case 1: {
                    return new Locale(parts[0]);
                }
                case 2: {
                    return new Locale(parts[0], parts[1]);
                }
                case 3: {
                    return new Locale(parts[0], parts[1], parts[2]);
                }
            }
            return null;
        }
    }

    public void prepareClassResourceBundle(String basename, Class<?> bundleClass) {
        this.registerNullaryConstructor(bundleClass);
        this.onClassBundlePrepared(bundleClass);
    }

    private void registerNullaryConstructor(Class<?> bundleClass) {
        Constructor<?> nullaryConstructor;
        RuntimeReflection.register((Class[])new Class[]{bundleClass});
        try {
            nullaryConstructor = bundleClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            RuntimeReflection.registerConstructorLookup(bundleClass, (Class[])new Class[0]);
            return;
        }
        RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
    }
}

