/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.jdk.NativeLibraries;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton
public final class NativeLibrarySupport
extends NativeLibraries {
    private final ReentrantLock lock = new ReentrantLock();
    private final List<PlatformNativeLibrarySupport.NativeLibrary> knownLibraries = new CopyOnWriteArrayList<PlatformNativeLibrarySupport.NativeLibrary>();
    private final Deque<PlatformNativeLibrarySupport.NativeLibrary> currentLoadContext = new ArrayDeque<PlatformNativeLibrarySupport.NativeLibrary>();
    private LibraryInitializer libraryInitializer;

    public static NativeLibrarySupport singleton() {
        return (NativeLibrarySupport)ImageSingletons.lookup(NativeLibrarySupport.class);
    }

    NativeLibrarySupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerLibraryInitializer(LibraryInitializer initializer) {
        assert (this.libraryInitializer == null);
        this.libraryInitializer = initializer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void preregisterUninitializedBuiltinLibrary(String name) {
        this.knownLibraries.add(PlatformNativeLibrarySupport.singleton().createLibrary(name, true));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isPreregisteredBuiltinLibrary(String name) {
        return this.knownLibraries.stream().anyMatch(l -> l.isBuiltin() && l.getCanonicalIdentifier().equals(name));
    }

    @Override
    protected boolean addLibrary(String canonical, boolean builtin) {
        return this.addLibrary(builtin, canonical, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLibrary(boolean asBuiltin, String canonical, boolean initialize) {
        this.lock.lock();
        try {
            PlatformNativeLibrarySupport.NativeLibrary lib = null;
            for (PlatformNativeLibrarySupport.NativeLibrary known : this.knownLibraries) {
                if (!canonical.equals(known.getCanonicalIdentifier())) continue;
                if (known.isLoaded()) {
                    boolean bl = true;
                    return bl;
                }
                assert (known.isBuiltin()) : "non-built-in libraries must always have been loaded";
                assert (asBuiltin) : "must have tried loading as built-in first";
                lib = known;
                break;
            }
            if (asBuiltin && lib == null && (this.libraryInitializer == null || !this.libraryInitializer.isBuiltinLibrary(canonical))) {
                boolean bl = false;
                return bl;
            }
            for (PlatformNativeLibrarySupport.NativeLibrary loading : this.currentLoadContext) {
                if (!canonical.equals(loading.getCanonicalIdentifier())) continue;
                boolean bl = true;
                return bl;
            }
            boolean created = false;
            if (lib == null) {
                lib = PlatformNativeLibrarySupport.singleton().createLibrary(canonical, asBuiltin);
                created = true;
            }
            this.currentLoadContext.push(lib);
            try {
                if (!lib.load()) {
                    boolean loading = false;
                    return loading;
                }
                if (initialize && this.libraryInitializer != null) {
                    this.libraryInitializer.initialize(lib);
                }
            }
            finally {
                PlatformNativeLibrarySupport.NativeLibrary top = this.currentLoadContext.pop();
                assert (top == lib);
            }
            if (created) {
                this.knownLibraries.add(lib);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PointerBase findSymbol(String name) {
        this.lock.lock();
        try {
            PointerBase pointerBase = NativeLibrarySupport.findSymbol(this.knownLibraries, name);
            return pointerBase;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registerInitializedBuiltinLibrary(String name) {
        boolean success = this.addLibrary(true, name, false);
        assert (success);
    }

    public static interface LibraryInitializer {
        public boolean isBuiltinLibrary(String var1);

        public void initialize(PlatformNativeLibrarySupport.NativeLibrary var1);
    }
}

