/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ChunksAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class YoungGeneration
extends Generation {
    private final Space eden = new Space("Eden", "E", true, 0);
    private final Space[] survivorFromSpaces;
    private final Space[] survivorToSpaces;
    private final GreyObjectsWalker[] survivorGreyObjectsWalkers;
    private final ChunksAccounting survivorsToSpacesAccounting;
    private final int maxSurvivorSpaces = HeapParameters.getMaxSurvivorSpaces();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    YoungGeneration(String name) {
        super(name);
        this.survivorFromSpaces = new Space[this.maxSurvivorSpaces];
        this.survivorToSpaces = new Space[this.maxSurvivorSpaces];
        this.survivorGreyObjectsWalkers = new GreyObjectsWalker[this.maxSurvivorSpaces];
        this.survivorsToSpacesAccounting = new ChunksAccounting();
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            int age = i + 1;
            this.survivorFromSpaces[i] = new Space("Survivor-" + age, "S" + age, true, age);
            this.survivorToSpaces[i] = new Space("Survivor-" + age + " To", "S" + age, false, age, this.survivorsToSpacesAccounting);
            this.survivorGreyObjectsWalkers[i] = new GreyObjectsWalker();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getMaxSurvivorSpaces() {
        return this.maxSurvivorSpaces;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        ThreadLocalAllocation.tearDown();
        this.eden.tearDown();
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            this.survivorFromSpaces[i].tearDown();
            this.survivorToSpaces[i].tearDown();
        }
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        if (!this.getEden().walkObjects(visitor)) {
            return false;
        }
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            if (!this.survivorFromSpaces[i].walkObjects(visitor)) {
                return false;
            }
            if (this.survivorToSpaces[i].walkObjects(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void logUsage(Log log) {
        this.getEden().logUsage(log, true);
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            this.survivorFromSpaces[i].logUsage(log, false);
            this.survivorToSpaces[i].logUsage(log, false);
        }
    }

    @Override
    public void logChunks(Log log) {
        this.getEden().logChunks(log);
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            this.survivorFromSpaces[i].logChunks(log);
            this.survivorToSpaces[i].logChunks(log);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getEden() {
        return this.eden;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getSurvivorToSpaceAt(int index) {
        assert (index >= 0 && index < this.maxSurvivorSpaces) : "Survivor index should be between 0 and NumberOfSurvivorSpaces";
        return this.survivorToSpaces[index];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getSurvivorFromSpaceAt(int index) {
        assert (index >= 0 && index < this.maxSurvivorSpaces) : "Survivor index should be between 0 and NumberOfSurvivorSpaces";
        return this.survivorFromSpaces[index];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private GreyObjectsWalker getSurvivorGreyObjectsWalker(int index) {
        return this.survivorGreyObjectsWalkers[index];
    }

    void releaseSpaces(GCImpl.ChunkReleaser chunkReleaser) {
        this.getEden().releaseChunks(chunkReleaser);
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            this.getSurvivorFromSpaceAt(i).releaseChunks(chunkReleaser);
        }
    }

    void swapSpaces() {
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            assert (this.getSurvivorFromSpaceAt(i).isEmpty()) : "Survivor fromSpace should be empty.";
            assert (this.getSurvivorFromSpaceAt(i).getChunkBytes().equal(0)) : "Chunk bytes must be 0";
            this.getSurvivorFromSpaceAt(i).absorb(this.getSurvivorToSpaceAt(i));
        }
        assert (this.survivorsToSpacesAccounting.getChunkBytes().equal(0));
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        if (this.getEden().walkHeapChunks(visitor)) {
            for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
                if (this.getSurvivorFromSpaceAt(i).walkHeapChunks(visitor) && this.getSurvivorToSpaceAt(i).walkHeapChunks(visitor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void prepareForPromotion() {
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            assert (this.getSurvivorToSpaceAt(i).isEmpty()) : "SurvivorToSpace should be empty.";
            this.getSurvivorGreyObjectsWalker(i).setScanStart(this.getSurvivorToSpaceAt(i));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean scanGreyObjects() {
        int i;
        boolean needScan = false;
        for (i = 0; i < this.maxSurvivorSpaces; ++i) {
            if (!this.getSurvivorGreyObjectsWalker(i).haveGreyObjects()) continue;
            needScan = true;
            break;
        }
        if (!needScan) {
            return false;
        }
        for (i = 0; i < this.maxSurvivorSpaces; ++i) {
            this.getSurvivorGreyObjectsWalker(i).walkGreyObjects();
        }
        return true;
    }

    UnsignedWord getChunkBytes() {
        return this.getEden().getChunkBytes().add(this.getSurvivorChunkBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getSurvivorChunkBytes() {
        UnsignedWord chunkBytes = (UnsignedWord)WordFactory.zero();
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            chunkBytes = chunkBytes.add(this.getSurvivorChunkBytes(i));
        }
        return chunkBytes;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getSurvivorChunkBytes(int survivorIndex) {
        return this.survivorFromSpaces[survivorIndex].getChunkBytes().add(this.survivorToSpaces[survivorIndex].getChunkBytes());
    }

    UnsignedWord getAlignedChunkBytes() {
        return this.getEden().getAlignedChunkBytes().add(this.getSurvivorAlignedChunkBytes());
    }

    UnsignedWord getSurvivorAlignedChunkBytes() {
        UnsignedWord chunkBytes = (UnsignedWord)WordFactory.zero();
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            chunkBytes = chunkBytes.add(this.survivorFromSpaces[i].getAlignedChunkBytes());
            chunkBytes = chunkBytes.add(this.survivorToSpaces[i].getAlignedChunkBytes());
        }
        return chunkBytes;
    }

    UnsignedWord computeObjectBytes() {
        return this.getEden().computeObjectBytes().add(this.computeSurvivorObjectBytes());
    }

    UnsignedWord computeSurvivorObjectBytes() {
        UnsignedWord usedObjectBytes = (UnsignedWord)WordFactory.zero();
        for (int i = 0; i < this.maxSurvivorSpaces; ++i) {
            usedObjectBytes = usedObjectBytes.add(this.survivorFromSpaces[i].computeObjectBytes());
            usedObjectBytes = usedObjectBytes.add(this.survivorToSpaces[i].computeObjectBytes());
        }
        return usedObjectBytes;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean contains(Object object) {
        boolean young;
        if (!HeapImpl.usesImageHeapCardMarking()) {
            return HeapChunk.getSpace(HeapChunk.getEnclosingHeapChunk(object)).isYoungSpace();
        }
        Word header = ObjectHeader.readHeaderFromObject(object);
        boolean bl = young = !ObjectHeaderImpl.hasRememberedSet((UnsignedWord)header);
        assert (young == HeapChunk.getSpace(HeapChunk.getEnclosingHeapChunk(object)).isYoungSpace());
        return young;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object promoteAlignedObject(Object original, AlignedHeapChunk.AlignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        assert (ObjectHeaderImpl.isAlignedObject(original));
        assert (originalSpace.getAge() < this.maxSurvivorSpaces);
        int age = originalSpace.getNextAgeForPromotion();
        Space toSpace = this.getSurvivorToSpaceAt(age - 1);
        return toSpace.promoteAlignedObject(original, originalSpace);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object promoteUnalignedObject(Object original, UnalignedHeapChunk.UnalignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        assert (originalSpace.getAge() < this.maxSurvivorSpaces);
        if (!this.unalignedChunkFitsInSurvivors(originalChunk)) {
            return null;
        }
        int age = originalSpace.getNextAgeForPromotion();
        Space toSpace = this.getSurvivorToSpaceAt(age - 1);
        toSpace.promoteUnalignedHeapChunk(originalChunk, originalSpace);
        return original;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean promoteChunk(HeapChunk.Header<?> originalChunk, boolean isAligned, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        assert (originalSpace.getAge() < this.maxSurvivorSpaces);
        if (!this.fitsInSurvivors(originalChunk, isAligned)) {
            return false;
        }
        int age = originalSpace.getNextAgeForPromotion();
        Space toSpace = this.getSurvivorToSpaceAt(age - 1);
        if (isAligned) {
            toSpace.promoteAlignedHeapChunk((AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace);
        } else {
            toSpace.promoteUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean fitsInSurvivors(HeapChunk.Header<?> chunk, boolean isAligned) {
        if (isAligned) {
            return this.alignedChunkFitsInSurvivors();
        }
        return this.unalignedChunkFitsInSurvivors((UnalignedHeapChunk.UnalignedHeader)chunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean alignedChunkFitsInSurvivors() {
        UnsignedWord sum = this.survivorsToSpacesAccounting.getChunkBytes().add(HeapParameters.getAlignedHeapChunkSize());
        return sum.belowOrEqual(GCImpl.getPolicy().getSurvivorSpacesCapacity());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean unalignedChunkFitsInSurvivors(UnalignedHeapChunk.UnalignedHeader chunk) {
        UnsignedWord size = UnalignedHeapChunk.getCommittedObjectMemory(chunk);
        UnsignedWord sum = this.survivorsToSpacesAccounting.getChunkBytes().add(size);
        return sum.belowOrEqual(GCImpl.getPolicy().getSurvivorSpacesCapacity());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader requestAlignedSurvivorChunk() {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        if (!this.alignedChunkFitsInSurvivors()) {
            return (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
        return HeapImpl.getChunkProvider().produceAlignedChunk();
    }
}

