/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import java.util.Arrays;

public enum ConfigurationFile {
    DYNAMIC_PROXY("proxy", true),
    RESOURCES("resource", true),
    JNI("jni", true),
    FOREIGN("foreign", false),
    REFLECTION("reflect", true),
    SERIALIZATION("serialization", true),
    SERIALIZATION_DENY("serialization-deny", false),
    PREDEFINED_CLASSES_NAME("predefined-classes", true);

    public static final String DEFAULT_FILE_NAME_SUFFIX = "-config.json";
    private final String name;
    private final boolean canAgentGenerate;
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_SUBDIR = "agent-extracted-predefined-classes";
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_NAME_SUFFIX = ".classdata";
    public static final String PARTIAL_CONFIGURATION_WITH_ORIGINS = "partial-config-with-origins.json";
    private static final ConfigurationFile[] agentGeneratedFiles;

    private ConfigurationFile(String name, boolean canAgentGenerate) {
        this.name = name;
        this.canAgentGenerate = canAgentGenerate;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.name + DEFAULT_FILE_NAME_SUFFIX;
    }

    public String getFileName(String suffix) {
        return this.name + suffix;
    }

    public boolean canBeGeneratedByAgent() {
        return this.canAgentGenerate;
    }

    public static ConfigurationFile getByName(String name) {
        for (ConfigurationFile file : ConfigurationFile.values()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public static ConfigurationFile[] agentGeneratedFiles() {
        return agentGeneratedFiles;
    }

    private static ConfigurationFile[] computeAgentGeneratedFiles() {
        return (ConfigurationFile[])Arrays.stream(ConfigurationFile.values()).filter(ConfigurationFile::canBeGeneratedByAgent).toArray(ConfigurationFile[]::new);
    }

    static {
        agentGeneratedFiles = ConfigurationFile.computeAgentGeneratedFiles();
    }
}

