/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateDataStorage;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public final class CIsolateData<T extends PointerBase> {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final String name;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final long size;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private UnsignedWord offset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    CIsolateData(String name, long size) {
        this.name = name;
        this.size = size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public T get() {
        return CIsolateDataStorage.singleton().get(this);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public long getSize() {
        return this.size;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getOffset() {
        return this.offset;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setOffset(UnsignedWord offset) {
        assert (this.offset == null);
        this.offset = offset;
    }
}

