/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.util.StringJoiner;
import java.util.function.Function;

class RuntimeAssertionsOptionTransformer
implements Function<Object, Object> {
    private static final String SEPARATOR = ",";
    private final char prefix;

    RuntimeAssertionsOptionTransformer(char prefix) {
        this.prefix = prefix;
    }

    @Override
    public Object apply(Object o) {
        StringJoiner joiner = new StringJoiner(SEPARATOR);
        for (String entry : o.toString().split(SEPARATOR)) {
            String s = this.prefix + entry;
            joiner.add(s);
        }
        return joiner.toString();
    }

    static class Disable
    extends RuntimeAssertionsOptionTransformer {
        Disable() {
            super('-');
        }
    }

    static class Enable
    extends RuntimeAssertionsOptionTransformer {
        Enable() {
            super('+');
        }
    }
}

