/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.xml;

import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

public abstract class XMLParsersRegistration
extends JNIRegistrationUtil {
    public void registerConfigs(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        List<String> parserClasses = this.xmlParserClasses();
        XMLParsersRegistration.registerReflectionClasses(access, parserClasses);
        this.registerResources();
        if (!access.concurrentReachabilityHandlers()) {
            access.requireAnalysisIteration();
        }
    }

    abstract List<String> xmlParserClasses();

    void registerResources() {
    }

    private static void registerReflectionClasses(FeatureImpl.DuringAnalysisAccessImpl access, List<String> parserClasses) {
        for (String className : parserClasses) {
            RuntimeReflection.register((Class[])new Class[]{XMLParsersRegistration.clazz(access, className)});
            RuntimeReflection.register((Executable[])new Executable[]{XMLParsersRegistration.constructor(access, className, new Class[0])});
        }
    }

    static class TransformerClassesAndResources
    extends XMLParsersRegistration {
        TransformerClassesAndResources() {
        }

        @Override
        void registerResources() {
            ClassInitializationSupport classInitializationSupport = (ClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
            classInitializationSupport.setConfigurationSealed(false);
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResourceBundles(ConfigurationCondition.alwaysTrue(), "com.sun.org.apache.xml.internal.serializer.utils.SerializerMessages");
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResourceBundles(ConfigurationCondition.alwaysTrue(), "com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMessages");
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "com.sun.*.properties");
            classInitializationSupport.setConfigurationSealed(true);
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
    }

    static class StAXParserClasses
    extends XMLParsersRegistration {
        StAXParserClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Arrays.asList("com.sun.xml.internal.stream.events.XMLEventFactoryImpl", "com.sun.xml.internal.stream.XMLInputFactoryImpl", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        }
    }

    static class BuiltinSchemaGrammarClasses
    extends XMLParsersRegistration {
        BuiltinSchemaGrammarClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.impl.dv.xs.ExtendedSchemaDVFactoryImpl");
        }
    }

    static class SchemaDVFactoryClasses
    extends XMLParsersRegistration {
        SchemaDVFactoryClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl");
        }
    }

    static class SAXParserClasses
    extends XMLParsersRegistration {
        SAXParserClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        }
    }

    static class DOMParserClasses
    extends XMLParsersRegistration {
        DOMParserClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        }
    }

    static class DOMImplementationRegistryClasses
    extends XMLParsersRegistration {
        DOMImplementationRegistryClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
        }
    }

    static class DatatypeFactoryClasses
    extends XMLParsersRegistration {
        DatatypeFactoryClasses() {
        }

        @Override
        List<String> xmlParserClasses() {
            return Collections.singletonList("com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
        }
    }
}

