/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NonSnippetLowerings;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ImplicitExceptionsFeature
implements InternalFeature {
    ImplicitExceptionsFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : ImplicitExceptions.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Implicit exception foreign calls, registered in " + ImplicitExceptionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
        if (SubstrateOptions.VerifyTypes.getValue().booleanValue()) {
            access.getBigBang().addRootMethod((AnalysisMethod)NonSnippetLowerings.REPORT_VERIFY_TYPES_ERROR.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Type verification support in foreign calls, registered in " + ImplicitExceptionsFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(ImplicitExceptions.FOREIGN_CALLS);
        if (SubstrateOptions.VerifyTypes.getValue().booleanValue()) {
            foreignCalls.register(NonSnippetLowerings.REPORT_VERIFY_TYPES_ERROR);
        }
    }
}

