/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Objects;

public final class RecordUtils {
    public static Method[] getRecordComponentAccessorMethods(Class<?> clazz) {
        return (Method[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getAccessor).filter(Objects::nonNull).toArray(Method[]::new);
    }

    public static Constructor<?> getCanonicalRecordConstructor(Class<?> clazz) {
        Class[] paramTypes = (Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            Constructor<?> ctr = clazz.getDeclaredConstructor(paramTypes);
            ctr.setAccessible(true);
            return ctr;
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere("Malformed record class that does not declare a canonical constructor: " + clazz.getTypeName());
        }
    }
}

