/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerAbortException;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerCluster;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerClusterMember;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerConstantFieldProvider;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerGraphDecoder;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerPolicy;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerResult;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerStatus;
import com.oracle.svm.hosted.fieldfolding.MarkStaticFinalFieldInitializedNode;
import com.oracle.svm.util.ClassUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.UnreachableControlSinkNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.FinalFieldBarrierNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.ImageSingletons;

public class SimulateClassInitializerSupport {
    protected final ClassInitializationSupport classInitializationSupport = ClassInitializationSupport.singleton();
    protected final SimulateClassInitializerPolicy simulateClassInitializerPolicy;
    protected final SimulateClassInitializerConstantFieldProvider simulatedFieldValueConstantFieldProvider;
    protected final ConcurrentMap<AnalysisType, SimulateClassInitializerResult> analyzedClasses = new ConcurrentHashMap<AnalysisType, SimulateClassInitializerResult>();
    protected final boolean enabled = ClassInitializationOptions.SimulateClassInitializer.getValue() != false && SubstrateOptions.parseOnce();
    protected final boolean collectAllReasons = ClassInitializationOptions.SimulateClassInitializerCollectAllReasons.getValue();
    protected final int maxInlineDepth = ClassInitializationOptions.SimulateClassInitializerMaxInlineDepth.getValue();
    protected final int maxLoopIterations = ClassInitializationOptions.SimulateClassInitializerMaxLoopIterations.getValue();
    protected final int maxAllocatedBytes = ClassInitializationOptions.SimulateClassInitializerMaxAllocatedBytes.getValue();

    public static SimulateClassInitializerSupport singleton() {
        return (SimulateClassInitializerSupport)ImageSingletons.lookup(SimulateClassInitializerSupport.class);
    }

    public SimulateClassInitializerSupport(AnalysisMetaAccess aMetaAccess, SVMHost hostVM) {
        this.simulateClassInitializerPolicy = new SimulateClassInitializerPolicy(hostVM, this);
        this.simulatedFieldValueConstantFieldProvider = new SimulateClassInitializerConstantFieldProvider((MetaAccessProvider)aMetaAccess, hostVM, this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean trySimulateClassInitializer(BigBang bb, AnalysisType type) {
        boolean bl;
        block10: {
            SimulateClassInitializerResult existingResult = this.lookupPublishedSimulateClassInitializerResult(type);
            if (existingResult != null) {
                return existingResult.simulatedInitialized;
            }
            DebugContext debug = new DebugContext.Builder(bb.getOptions()).build();
            DebugContext.Scope scope = debug.scope((Object)"SimulateClassInitializer", (Object)type);
            try {
                SimulateClassInitializerCluster cluster = new SimulateClassInitializerCluster(this, bb);
                boolean result = this.trySimulateClassInitializer(debug, type, cluster, null);
                for (SimulateClassInitializerClusterMember clusterMember : cluster.clusterMembers.getValues()) {
                    VMError.guarantee(clusterMember.status.published, "All members of the cluster must be published at the end of the analysis");
                }
                bl = result;
                if (scope == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw debug.handle(ex);
                }
            }
            scope.close();
        }
        return bl;
    }

    boolean trySimulateClassInitializer(DebugContext debug, AnalysisType type, SimulateClassInitializerClusterMember dependant) {
        SimulateClassInitializerResult existingResult = this.lookupPublishedSimulateClassInitializerResult(type);
        if (existingResult != null) {
            return existingResult.simulatedInitialized;
        }
        return this.trySimulateClassInitializer(debug, type, dependant.cluster, dependant);
    }

    public ConstantNode tryCanonicalize(final BigBang bb, final LoadFieldNode node) {
        AnalysisField field = (AnalysisField)node.field();
        final JavaConstant simulatedFieldValue = this.getSimulatedFieldValue(field);
        if (simulatedFieldValue == null) {
            return null;
        }
        return this.simulatedFieldValueConstantFieldProvider.readConstantField((ResolvedJavaField)field, new ConstantFieldProvider.ConstantFieldTool<ConstantNode>(){

            public JavaConstant readValue() {
                return simulatedFieldValue;
            }

            public JavaConstant getReceiver() {
                return null;
            }

            public Object getReason() {
                return node.getNodeSourcePosition();
            }

            public ConstantNode foldConstant(JavaConstant constant) {
                return constant == null ? null : ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)bb.getMetaAccess());
            }

            public ConstantNode foldStableArray(JavaConstant constant, int stableDimensions, boolean isDefaultStable) {
                return constant == null ? null : ConstantNode.forConstant((JavaConstant)constant, (int)stableDimensions, (boolean)isDefaultStable, (MetaAccessProvider)bb.getMetaAccess());
            }

            public OptionValues getOptions() {
                return bb.getOptions();
            }
        });
    }

    public JavaConstant getSimulatedFieldValue(AnalysisField field) {
        if (!this.enabled || !field.isStatic()) {
            return null;
        }
        SimulateClassInitializerResult existingResult = (SimulateClassInitializerResult)this.analyzedClasses.get(field.getDeclaringClass());
        if (existingResult == null || !existingResult.simulatedInitialized) {
            return null;
        }
        JavaConstant simulatedFieldValue = (JavaConstant)existingResult.staticFieldValues.get((Object)field);
        if (simulatedFieldValue != null) {
            return simulatedFieldValue;
        }
        return null;
    }

    public boolean isClassInitializerSimulated(AnalysisType type) {
        SimulateClassInitializerResult existingResult = this.lookupPublishedSimulateClassInitializerResult(type);
        if (existingResult != null) {
            return existingResult.simulatedInitialized;
        }
        return false;
    }

    private SimulateClassInitializerResult lookupPublishedSimulateClassInitializerResult(AnalysisType type) {
        if (!type.isLinked()) {
            return SimulateClassInitializerResult.NOT_SIMULATED_INITIALIZED;
        }
        if (type.isInitialized()) {
            return SimulateClassInitializerResult.INITIALIZED_HOSTED;
        }
        VMError.guarantee(!type.isArray() && !type.isPrimitive(), "array and primitive types are always initialized at build time");
        if (!this.enabled) {
            return SimulateClassInitializerResult.NOT_SIMULATED_INITIALIZED;
        }
        return (SimulateClassInitializerResult)this.analyzedClasses.get(type);
    }

    boolean trySimulateClassInitializer(DebugContext debug, AnalysisType type, SimulateClassInitializerCluster cluster, SimulateClassInitializerClusterMember dependant) {
        SimulateClassInitializerClusterMember existingClusterMember = (SimulateClassInitializerClusterMember)cluster.clusterMembers.get((Object)type);
        if (existingClusterMember != null) {
            assert (!existingClusterMember.status.published) : type + ": " + existingClusterMember.status;
            dependant.dependencies.add((Object)existingClusterMember);
            return false;
        }
        SimulateClassInitializerClusterMember clusterMember = new SimulateClassInitializerClusterMember(cluster, type);
        if (dependant != null) {
            dependant.dependencies.add((Object)clusterMember);
        }
        this.checkStrictlyInitializeAtRunTime(clusterMember);
        if (clusterMember.notInitializedReasons.size() == 0 || this.collectAllReasons) {
            this.addSuperDependencies(debug, clusterMember);
        }
        if (clusterMember.notInitializedReasons.size() == 0 || this.collectAllReasons) {
            this.addClassInitializerDependencies(clusterMember);
        }
        clusterMember.status = SimulateClassInitializerStatus.INIT_CANDIDATE;
        EconomicSet transitiveDependencies = EconomicSet.create();
        boolean dependenciesMissing = this.collectTransitiveDependencies(clusterMember, (EconomicSet<SimulateClassInitializerClusterMember>)transitiveDependencies);
        if (dependenciesMissing) {
            return false;
        }
        boolean allDependenciesSimulated = true;
        for (SimulateClassInitializerClusterMember dependency : transitiveDependencies) {
            assert (dependency.status != SimulateClassInitializerStatus.COLLECTING_DEPENDENCIES) : dependency.type + ": " + dependency.status;
            if (dependency.status != SimulateClassInitializerStatus.PUBLISHED_AS_NOT_INITIALIZED && dependency.notInitializedReasons.size() <= 0) continue;
            allDependenciesSimulated = false;
            break;
        }
        this.publishResults(debug, allDependenciesSimulated, (EconomicSet<SimulateClassInitializerClusterMember>)transitiveDependencies);
        return allDependenciesSimulated;
    }

    private void checkStrictlyInitializeAtRunTime(SimulateClassInitializerClusterMember clusterMember) {
        Class clazz = clusterMember.type.getJavaClass();
        if (this.classInitializationSupport.specifiedInitKindFor(clazz) == InitKind.RUN_TIME && this.classInitializationSupport.isStrictlyDefined(clazz).booleanValue()) {
            clusterMember.notInitializedReasons.add("Class is strictly defined as initialize at run time");
        }
    }

    private void addSuperDependencies(DebugContext debug, SimulateClassInitializerClusterMember clusterMember) {
        if (clusterMember.type.isInterface()) {
            return;
        }
        AnalysisType supertype = clusterMember.type.getSuperclass();
        if (supertype != null) {
            this.addDependency(debug, clusterMember, supertype, supertype);
        }
        this.addInterfaceDependencies(debug, clusterMember.type, clusterMember);
    }

    private void addInterfaceDependencies(DebugContext debug, AnalysisType type, SimulateClassInitializerClusterMember clusterMember) {
        for (AnalysisType iface : type.getInterfaces()) {
            if (iface.declaresDefaultMethods()) {
                this.addDependency(debug, clusterMember, iface, iface);
                continue;
            }
            this.addInterfaceDependencies(debug, iface, clusterMember);
        }
    }

    private void addDependency(DebugContext debug, SimulateClassInitializerClusterMember clusterMember, AnalysisType newDependency, Object reason) {
        SimulateClassInitializerResult dependencyResult = this.lookupPublishedSimulateClassInitializerResult(newDependency);
        if (dependencyResult != null) {
            if (!dependencyResult.simulatedInitialized) {
                clusterMember.notInitializedReasons.add(reason);
            }
            return;
        }
        this.trySimulateClassInitializer(debug, newDependency, clusterMember.cluster, clusterMember);
    }

    private void addClassInitializerDependencies(SimulateClassInitializerClusterMember clusterMember) {
        StructuredGraph graph;
        AnalysisMethod classInitializer = clusterMember.type.getClassInitializer();
        if (classInitializer == null) {
            return;
        }
        try {
            graph = this.decodeGraph(clusterMember, classInitializer);
        }
        catch (SimulateClassInitializerAbortException ignored) {
            VMError.guarantee(!clusterMember.notInitializedReasons.isEmpty(), "Reason must be added before throwing the abort-exception");
            return;
        }
        for (Node node : graph.getNodes()) {
            SimulateClassInitializerSupport.processEffectsOfNode(clusterMember, node);
        }
    }

    private StructuredGraph decodeGraph(SimulateClassInitializerClusterMember clusterMember, AnalysisMethod classInitializer) {
        StructuredGraph structuredGraph;
        block8: {
            BigBang bb = clusterMember.cluster.bb;
            AnalysisParsedGraph analysisParsedGraph = classInitializer.ensureGraphParsed(bb);
            DebugContext.Description description = new DebugContext.Description((Object)classInitializer, ClassUtil.getUnqualifiedName(classInitializer.getClass()) + ":" + classInitializer.getId());
            DebugContext debug = new DebugContext.Builder(bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(bb.getProviders(classInitializer).getSnippetReflection())).description(description).build();
            StructuredGraph result = new StructuredGraph.Builder(bb.getOptions(), debug).method((ResolvedJavaMethod)classInitializer).recordInlinedMethods(false).trackNodeSourcePosition(analysisParsedGraph.getEncodedGraph().trackNodeSourcePosition()).build();
            DebugContext.Scope scope = debug.scope((Object)"SimulateClassInitializerGraphDecoder", (Object)result);
            try {
                SimulateClassInitializerGraphDecoder decoder = this.createGraphDecoder(clusterMember, bb, result);
                decoder.decode((ResolvedJavaMethod)classInitializer);
                debug.dump(1, (Object)result, "SimulateClassInitializer after decode");
                CanonicalizerPhase.create().apply(result, (Object)clusterMember.cluster.providers);
                structuredGraph = result;
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw debug.handle(ex);
                }
            }
            scope.close();
        }
        return structuredGraph;
    }

    protected SimulateClassInitializerGraphDecoder createGraphDecoder(SimulateClassInitializerClusterMember clusterMember, BigBang bb, StructuredGraph result) {
        return new SimulateClassInitializerGraphDecoder(bb, this.simulateClassInitializerPolicy, clusterMember, result);
    }

    private static void processEffectsOfNode(SimulateClassInitializerClusterMember clusterMember, Node node) {
        JavaConstant constantValue;
        StoreFieldNode storeFieldNode;
        AnalysisField field;
        if (node instanceof StartNode || node instanceof BeginNode || node instanceof UnreachableBeginNode || node instanceof UnreachableControlSinkNode || node instanceof FullInfopointNode) {
            return;
        }
        if (node instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)node;
            assert (returnNode.result() == null) : "Class initializer always has return type void";
            return;
        }
        if (node instanceof VirtualState) {
            return;
        }
        if (node instanceof VirtualObjectNode) {
            return;
        }
        if (node instanceof ConstantNode) {
            return;
        }
        if (node instanceof FinalFieldBarrierNode) {
            return;
        }
        if (node instanceof MarkStaticFinalFieldInitializedNode) {
            return;
        }
        if (node instanceof StoreFieldNode && (field = (AnalysisField)(storeFieldNode = (StoreFieldNode)node).field()).isStatic() && field.getDeclaringClass().equals((Object)clusterMember.type) && (constantValue = storeFieldNode.value().asJavaConstant()) != null) {
            clusterMember.staticFieldValues.put((Object)field, (Object)constantValue);
            return;
        }
        clusterMember.notInitializedReasons.add(node);
    }

    private void publishResults(DebugContext debug, boolean simulatedInitialized, EconomicSet<SimulateClassInitializerClusterMember> transitiveDependencies) {
        for (SimulateClassInitializerClusterMember clusterMember : transitiveDependencies) {
            SimulateClassInitializerResult existingResult;
            if (clusterMember.status.published) continue;
            assert (clusterMember.status == SimulateClassInitializerStatus.INIT_CANDIDATE) : clusterMember.type + ": " + clusterMember.status;
            if (simulatedInitialized) {
                assert (clusterMember.notInitializedReasons.isEmpty()) : clusterMember.type + ": " + clusterMember.notInitializedReasons;
                if (debug.isLogEnabled(1)) {
                    debug.log("simulated: %s", (Object)clusterMember.type.toJavaName(true));
                }
                existingResult = this.analyzedClasses.putIfAbsent(clusterMember.type, SimulateClassInitializerResult.forInitialized(clusterMember.staticFieldValues));
                clusterMember.status = SimulateClassInitializerStatus.PUBLISHED_AS_INITIALIZED;
            } else {
                if (debug.isLogEnabled(1)) {
                    debug.log("not simulated: %s:%n    %s", (Object)clusterMember.type.toJavaName(true), (Object)clusterMember.notInitializedReasons.stream().map(reason -> SimulateClassInitializerSupport.reasonToString(clusterMember.cluster.providers, reason)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(System.lineSeparator() + "    ")));
                }
                existingResult = this.analyzedClasses.putIfAbsent(clusterMember.type, SimulateClassInitializerResult.NOT_SIMULATED_INITIALIZED);
                clusterMember.status = SimulateClassInitializerStatus.PUBLISHED_AS_NOT_INITIALIZED;
            }
            if (existingResult == null || simulatedInitialized == existingResult.simulatedInitialized) continue;
            StringBuilder msg = new StringBuilder("mismatch with existing registration: ").append(clusterMember.type.toJavaName(true)).append(", existingResult: ").append(existingResult.simulatedInitialized).append(", new: ").append(simulatedInitialized).append(System.lineSeparator()).append("Cluster members:");
            for (SimulateClassInitializerClusterMember m : clusterMember.cluster.clusterMembers.getValues()) {
                msg.append(System.lineSeparator()).append("  ").append(m.type.toJavaName(true)).append(": ").append((Object)m.status).append(", ").append(m.staticFieldValues.size()).append(", ").append(m.notInitializedReasons.isEmpty() ? "(no reasons)" : SimulateClassInitializerSupport.reasonToString(clusterMember.cluster.providers, m.notInitializedReasons.get(0)));
            }
            throw VMError.shouldNotReachHere(msg.toString());
        }
    }

    private boolean collectTransitiveDependencies(SimulateClassInitializerClusterMember clusterMember, EconomicSet<SimulateClassInitializerClusterMember> transitiveDependencies) {
        if (clusterMember.status == SimulateClassInitializerStatus.COLLECTING_DEPENDENCIES) {
            return true;
        }
        if (clusterMember.status.published) {
            transitiveDependencies.add((Object)clusterMember);
        } else {
            assert (clusterMember.status == SimulateClassInitializerStatus.INIT_CANDIDATE) : clusterMember.type + ": " + clusterMember.status;
            if (transitiveDependencies.add((Object)clusterMember)) {
                for (SimulateClassInitializerClusterMember dependency : clusterMember.dependencies) {
                    if (!this.collectTransitiveDependencies(dependency, transitiveDependencies)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String reasonToString(HostedProviders providers, Object reason) {
        EnsureClassInitializedNode node;
        if (reason instanceof AnalysisType) {
            AnalysisType type = (AnalysisType)reason;
            return "superclass/interface: " + type.toJavaName(true);
        }
        if (reason instanceof EnsureClassInitializedNode && (node = (EnsureClassInitializedNode)((Object)reason)).constantTypeOrNull(providers.getConstantReflection()) != null) {
            return "class initializer dependency: " + ((EnsureClassInitializedNode)((Object)reason)).constantTypeOrNull(providers.getConstantReflection()).toJavaName(true) + " " + node.getNodeSourcePosition();
        }
        if (reason instanceof Node) {
            Node node2 = (Node)reason;
            if (node2 instanceof BeginNode || node2 instanceof ExceptionObjectNode || node2 instanceof MergeNode || node2 instanceof EndNode) {
                return null;
            }
            return "node " + node2 + " " + node2.getNodeSourcePosition();
        }
        return String.valueOf(reason);
    }
}

