/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.SubstrateUnsupportedFeatures;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.WordTypes;

public class NativeImageReachabilityAnalysisEngine
extends ReachabilityAnalysisEngine
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final boolean strengthenGraalGraphs;
    private final CustomTypeFieldHandler unknownFieldHandler;

    public NativeImageReachabilityAnalysisEngine(OptionValues options, AnalysisUniverse universe, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForkJoinPool executor, Runnable heartbeatCallback, TimerCollection timerCollection, ReachabilityMethodProcessingHandler reachabilityMethodProcessingHandler) {
        super(options, universe, universe.hostVM(), metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, executor, heartbeatCallback, new SubstrateUnsupportedFeatures(), timerCollection, reachabilityMethodProcessingHandler);
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.strengthenGraalGraphs = SubstrateOptions.parseOnce();
        this.dynamicHubInitializer = new DynamicHubInitializer(this);
        this.unknownFieldHandler = new CustomTypeFieldHandler(this, metaAccess){

            @Override
            protected void injectFieldTypes(AnalysisField aField, AnalysisType ... declaredTypes) {
                assert (aField.getJavaKind().isObject());
                NativeImageReachabilityAnalysisEngine.this.markFieldAccessed(aField, "@UnknownObjectField annotated field.");
                for (AnalysisType declaredType : declaredTypes) {
                    NativeImageReachabilityAnalysisEngine.this.registerTypeAsReachable(declaredType, "injected field types for unknown annotated field " + aField.format("%H.%n"));
                }
            }
        };
    }

    public boolean strengthenGraalGraphs() {
        return this.strengthenGraalGraphs;
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.unknownFieldHandler.handleField(field);
    }

    public void onTypeReachable(AnalysisType type) {
        this.postTask(d -> type.getInitializeMetaDataTask().ensureDone());
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.unknownFieldHandler.cleanupAfterAnalysis();
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void checkUserLimitations() {
        UserLimitationsChecker.check(this);
    }

    public void initializeMetaData(AnalysisType type) {
        this.dynamicHubInitializer.initializeMetaData(this.universe.getHeapScanner(), type);
    }
}

