/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;

public class SubstrateMethodPointerStamp
extends AbstractPointerStamp {
    private static final SubstrateMethodPointerStamp METHOD_NON_NULL = new SubstrateMethodPointerStamp(true, false);
    private static final SubstrateMethodPointerStamp METHOD_ALWAYS_NULL = new SubstrateMethodPointerStamp(false, true);
    private static final SubstrateMethodPointerStamp METHOD = new SubstrateMethodPointerStamp(false, false);

    protected SubstrateMethodPointerStamp(boolean nonNull, boolean alwaysNull) {
        super(nonNull, alwaysNull);
    }

    public static SubstrateMethodPointerStamp methodNonNull() {
        return METHOD_NON_NULL;
    }

    protected AbstractPointerStamp copyWith(boolean newNonNull, boolean newAlwaysNull) {
        if (newNonNull) {
            assert (!newAlwaysNull);
            return METHOD_NON_NULL;
        }
        if (newAlwaysNull) {
            return METHOD_ALWAYS_NULL;
        }
        return METHOD;
    }

    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        throw GraalError.shouldNotReachHere((String)"pointer has no Java type");
    }

    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getWordKind();
    }

    public Stamp join(Stamp other) {
        return this.defaultPointerJoin(other);
    }

    public Stamp empty() {
        return this;
    }

    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (JavaConstant.NULL_POINTER.equals(c)) {
            return METHOD_ALWAYS_NULL;
        }
        assert (c instanceof SubstrateMethodPointerConstant);
        return METHOD_NON_NULL;
    }

    public boolean isCompatible(Stamp other) {
        return other instanceof SubstrateMethodPointerStamp;
    }

    public boolean isCompatible(Constant constant) {
        return constant instanceof SubstrateMethodPointerConstant;
    }

    public boolean hasValues() {
        return true;
    }

    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        return null;
    }

    public String toString() {
        return "SVMMethod*";
    }
}

