/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;

public class JavaMonitorInflateEvent {
    public static void emit(Object obj, long startTicks, MonitorInflationCause cause) {
        if (HasJfrSupport.get()) {
            JavaMonitorInflateEvent.emit0(obj, startTicks, cause);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit0(Object obj, long startTicks, MonitorInflationCause cause) {
        long duration = JfrTicks.duration(startTicks);
        if (JfrEvent.JavaMonitorInflate.shouldEmit(duration)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaMonitorInflate);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, duration);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.JavaMonitorInflate, 0));
            JfrNativeEventWriter.putClass(data, obj.getClass());
            JfrNativeEventWriter.putLong(data, Word.objectToUntrackedPointer((Object)obj).rawValue());
            JfrNativeEventWriter.putLong(data, JavaMonitorInflateEvent.getId(cause));
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getId(MonitorInflationCause cause) {
        return cause.ordinal();
    }
}

