/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JavaNetSubstitutions;
import com.oracle.svm.core.util.VMError;
import java.util.HashSet;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class JavaNetFeature
implements InternalFeature {
    JavaNetFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        HashSet disabledURLProtocols = new HashSet(SubstrateOptions.DisableURLProtocols.getValue().values());
        JavaNetSubstitutions.defaultProtocols.forEach(protocol -> {
            if (!disabledURLProtocols.contains(protocol)) {
                boolean registered = JavaNetSubstitutions.addURLStreamHandler(protocol);
                VMError.guarantee(registered, "The URL protocol %s is not available.", protocol);
            }
        });
        for (String protocol2 : SubstrateOptions.EnableURLProtocols.getValue().values()) {
            boolean registered;
            if (disabledURLProtocols.contains(protocol2)) continue;
            if (JavaNetSubstitutions.defaultProtocols.contains(protocol2)) {
                JavaNetFeature.printWarning("The URL protocol " + protocol2 + " is enabled by default. The option " + JavaNetSubstitutions.enableProtocolsOption + protocol2 + " is not needed.");
                continue;
            }
            if (JavaNetSubstitutions.onDemandProtocols.contains(protocol2)) {
                registered = JavaNetSubstitutions.addURLStreamHandler(protocol2);
                VMError.guarantee(registered, "The URL protocol %s is not available.", protocol2);
                continue;
            }
            JavaNetFeature.printWarning("The URL protocol " + protocol2 + " is not tested and might not work as expected." + System.lineSeparator() + JavaNetSubstitutions.supportedProtocols());
            registered = JavaNetSubstitutions.addURLStreamHandler(protocol2);
            if (registered) continue;
            JavaNetFeature.printWarning("Registering the " + protocol2 + " URL protocol failed. It will not be available at runtime." + System.lineSeparator());
        }
    }

    private static void printWarning(String warningMessage) {
        System.out.println(warningMessage);
    }
}

