/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public final class CEntryPointEnterNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CEntryPointEnterNode> TYPE = NodeClass.create(CEntryPointEnterNode.class);
    protected final EnterAction enterAction;
    @Node.OptionalInput
    protected ValueNode parameter;
    private final boolean startedByIsolate;
    private final boolean ensureJavaThread;

    public static CEntryPointEnterNode createIsolate(ValueNode parameters) {
        return new CEntryPointEnterNode(EnterAction.CreateIsolate, parameters, false, false);
    }

    public static CEntryPointEnterNode attachThread(ValueNode isolate, boolean startedByIsolate, boolean ensureJavaThread) {
        return new CEntryPointEnterNode(EnterAction.AttachThread, isolate, startedByIsolate, ensureJavaThread);
    }

    public static CEntryPointEnterNode enter(ValueNode isolateThread) {
        return new CEntryPointEnterNode(EnterAction.Enter, isolateThread, false, false);
    }

    public static CEntryPointEnterNode enterByIsolate(ValueNode isolate) {
        return new CEntryPointEnterNode(EnterAction.EnterByIsolate, isolate, false, false);
    }

    protected CEntryPointEnterNode(EnterAction enterAction, ValueNode parameter, boolean startedByCurrentIsolate, boolean ensureJavaThread) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        this.enterAction = enterAction;
        this.parameter = parameter;
        this.startedByIsolate = startedByCurrentIsolate;
        this.ensureJavaThread = ensureJavaThread;
    }

    public EnterAction getEnterAction() {
        return this.enterAction;
    }

    public ValueNode getParameter() {
        return this.parameter;
    }

    public boolean getStartedByIsolate() {
        return this.startedByIsolate;
    }

    public boolean getEnsureJavaThread() {
        return this.ensureJavaThread;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }

    public static enum EnterAction {
        CreateIsolate,
        AttachThread,
        Enter,
        EnterByIsolate;

    }
}

