/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nodes.CFunctionPrologueDataNode;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public abstract class SubstrateBackend
extends Backend {
    private static final LocationIdentity JIT_VTABLE_IDENTITY = NamedLocationIdentity.mutable((String)"DynamicHub.vtable@jit");
    private RuntimeConfiguration runtimeConfiguration;
    private ResolvedJavaMethod runtimeToRuntimeInvokeMethod;

    protected SubstrateBackend(Providers providers) {
        super(providers);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setRuntimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
        this.runtimeConfiguration = runtimeConfiguration;
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        assert (this.runtimeConfiguration != null) : "Access before initialization";
        return this.runtimeConfiguration;
    }

    public void setRuntimeToRuntimeInvokeMethod(Method method) {
        VMError.guarantee(this.runtimeToRuntimeInvokeMethod == null, "can only be set once");
        this.runtimeToRuntimeInvokeMethod = this.getProviders().getMetaAccess().lookupJavaMethod((Executable)method);
    }

    protected boolean isRuntimeToRuntimeCall(LIRFrameState callState) {
        if (SubstrateUtil.HOSTED) {
            return false;
        }
        if (this.runtimeToRuntimeInvokeMethod != null && callState != null && callState.topFrame != null) {
            ResolvedJavaMethod m = callState.topFrame.getMethod();
            return this.runtimeToRuntimeInvokeMethod.equals(m);
        }
        return false;
    }

    public SuitesProvider getSuites() {
        throw VMError.intentionallyUnimplemented();
    }

    public CompilationResult newCompilationResult(CompilationIdentifier compilationIdentifier, String name) {
        return new CompilationResult(compilationIdentifier, name){

            public void close(OptionValues options) {
            }
        };
    }

    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new RegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    public static boolean hasJavaFrameAnchor(CallTargetNode callTarget) {
        return SubstrateBackend.getPrologueData(callTarget) != null;
    }

    public static ValueNode getJavaFrameAnchor(CallTargetNode callTarget) {
        ValueNode frameAnchor = SubstrateBackend.getPrologueData(callTarget).frameAnchor();
        assert (frameAnchor != null);
        return frameAnchor;
    }

    public static boolean shouldEmitOnlyIndirectCalls() {
        return !SubstrateUtil.HOSTED;
    }

    public static LocationIdentity getVTableIdentity() {
        return SubstrateUtil.HOSTED ? NamedLocationIdentity.FINAL_LOCATION : JIT_VTABLE_IDENTITY;
    }

    protected static void verifyCallTarget(LoweredCallTargetNode callTarget) {
        if (SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
            if (callTarget instanceof IndirectCallTargetNode) {
                VMError.guarantee(!((IndirectCallTargetNode)callTarget).computedAddress().isConstant(), "Runtime-compiled code must not contain calls with absolute addresses");
            } else if (!(callTarget instanceof ComputedIndirectCallTargetNode)) {
                throw VMError.shouldNotReachHere("Call uses non-indirect target when only indirect calls are permitted: " + callTarget);
            }
        }
    }

    private static CFunctionPrologueDataNode getPrologueData(CallTargetNode callTarget) {
        return (CFunctionPrologueDataNode)callTarget.invoke().classInit();
    }

    public static int getNewThreadStatus(CallTargetNode callTarget) {
        CFunctionPrologueDataNode prologueData = SubstrateBackend.getPrologueData(callTarget);
        if (prologueData != null) {
            return prologueData.getNewThreadStatus();
        }
        return -1;
    }

    public abstract BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider var1);

    public abstract CompilationResult createJNITrampolineMethod(ResolvedJavaMethod var1, CompilationIdentifier var2, RegisterValue var3, int var4, RegisterValue var5, int var6);

    public boolean stackOverflowCheckedInPrologue(SharedMethod method) {
        return false;
    }

    public boolean safepointCheckedInEpilogue(SharedMethod method) {
        return false;
    }

    public static enum SubstrateMarkId implements CompilationResult.MarkId
    {
        PROLOGUE_START(true),
        PROLOGUE_DECD_RSP(true),
        PROLOGUE_SAVED_REGS(true),
        PROLOGUE_END(true),
        EPILOGUE_START(false),
        EPILOGUE_INCD_RSP(true),
        EPILOGUE_END(true);

        final boolean isMarkAfter;

        private SubstrateMarkId(boolean isMarkAfter) {
            this.isMarkAfter = isMarkAfter;
        }

        public String getName() {
            return this.name();
        }
    }
}

