/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.hub.DynamicHub;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class RuntimeCodeCacheReachabilityAnalyzer
implements ObjectReferenceVisitor {
    private boolean unreachableObjects;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheReachabilityAnalyzer() {
    }

    public void initialize() {
        this.unreachableObjects = false;
    }

    public boolean hasUnreachableObjects() {
        return this.unreachableObjects;
    }

    @Override
    public boolean visitObjectReference(Pointer ptrPtrToObject, boolean compressed, Object holderObject) {
        assert (!this.unreachableObjects);
        Word ptrToObj = ReferenceAccess.singleton().readObjectAsUntrackedPointer(ptrPtrToObject, compressed);
        if (ptrToObj.isNonNull() && !RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)ptrToObj)) {
            this.unreachableObjects = true;
            return false;
        }
        return true;
    }

    public static boolean isReachable(Pointer ptrToObj) {
        assert (ptrToObj.isNonNull());
        if (HeapImpl.getHeapImpl().isInImageHeap(ptrToObj)) {
            return true;
        }
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Word header = ObjectHeader.readHeaderFromPointer(ptrToObj);
        if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
            return true;
        }
        Space space = HeapChunk.getSpace(HeapChunk.getEnclosingHeapChunk(ptrToObj, (UnsignedWord)header));
        if (!space.isFromSpace()) {
            return true;
        }
        Class<?> clazz = DynamicHub.toClass(ohi.dynamicHubFromObjectHeader(header));
        return RuntimeCodeCacheReachabilityAnalyzer.isAssumedReachable(clazz);
    }

    private static boolean isAssumedReachable(Class<?> clazz) {
        Class<?>[] classesAssumedReachable = RuntimeCodeCacheCleaner.CLASSES_ASSUMED_REACHABLE;
        for (int i = 0; i < classesAssumedReachable.length; ++i) {
            if (!classesAssumedReachable[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

