/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.BasicCollectionPolicies;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GenScavengeGCCause;
import com.oracle.svm.core.genscavenge.GenScavengeMemoryPoolMXBeans;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapAccounting;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.JfrGCEvents;
import com.oracle.svm.core.genscavenge.JfrGCHeapSummaryEvent;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheWalker;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.heap.AbstractPinnedObjectSupport;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrGCWhen;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GCImpl
implements GC {
    private static final long K = 1024L;
    static final long M = 0x100000L;
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor = new GreyToBlackObjRefVisitor();
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor = new GreyToBlackObjectVisitor(this.greyToBlackObjRefVisitor);
    private final RuntimeCodeCacheWalker runtimeCodeCacheWalker = new RuntimeCodeCacheWalker(this.greyToBlackObjRefVisitor);
    private final RuntimeCodeCacheCleaner runtimeCodeCacheCleaner = new RuntimeCodeCacheCleaner();
    private final GCAccounting accounting = new GCAccounting();
    private final Timers timers = new Timers();
    private final CollectionVMOperation collectOperation = new CollectionVMOperation();
    private final ChunkReleaser chunkReleaser = new ChunkReleaser();
    private final CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord collectionEpoch = (UnsignedWord)WordFactory.zero();
    private long lastWholeHeapExaminedTimeMillis = -1L;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCImpl() {
        this.policy = CollectionPolicy.getInitialPolicy();
        RuntimeSupport.getRuntimeSupport().addShutdownHook(isFirstIsolate -> GCImpl.printGCSummary());
    }

    @Override
    public String getName() {
        if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
            return "Epsilon GC";
        }
        return "Serial GC";
    }

    @Override
    public String getDefaultMaxHeapSize() {
        return String.format("%s%% of RAM", SerialAndEpsilonGCOptions.MaximumHeapSizePercent.getValue());
    }

    @Override
    public void collect(GCCause cause) {
        this.collect(cause, false);
    }

    public void maybeCollectOnAllocation() {
        boolean outOfMemory = false;
        if (GCImpl.hasNeverCollectPolicy()) {
            UnsignedWord edenUsed = HeapImpl.getAccounting().getEdenUsedBytes();
            outOfMemory = edenUsed.aboveThan(GCImpl.getPolicy().getMaximumHeapSize());
        } else if (GCImpl.getPolicy().shouldCollectOnAllocation()) {
            outOfMemory = this.collectWithoutAllocating(GenScavengeGCCause.OnAllocation, false);
        }
        if (outOfMemory) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
    }

    @Override
    public void maybeCauseUserRequestedCollection(GCCause cause, boolean fullGC) {
        if (this.policy.shouldCollectOnRequest(cause, fullGC)) {
            this.collect(cause, fullGC);
        }
    }

    private void collect(GCCause cause, boolean forceFullGC) {
        boolean outOfMemory;
        if (!GCImpl.hasNeverCollectPolicy() && (outOfMemory = this.collectWithoutAllocating(cause, forceFullGC))) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
    }

    @Uninterruptible(reason="Avoid races with other threads that also try to trigger a GC")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    boolean collectWithoutAllocating(GCCause cause, boolean forceFullGC) {
        VMError.guarantee(!GCImpl.hasNeverCollectPolicy());
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch(this.getCollectionEpoch());
        data.setRequestingNanoTime(System.nanoTime());
        data.setForceFullGC(forceFullGC);
        this.enqueueCollectOperation(data);
        boolean outOfMemory = data.getOutOfMemory();
        if (outOfMemory && GCImpl.shouldIgnoreOutOfMemory()) {
            outOfMemory = false;
        }
        return outOfMemory;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean shouldIgnoreOutOfMemory() {
        return SerialGCOptions.IgnoreMaxHeapSizeWhileInVMOperation.getValue() != false && GCImpl.inVMInternalCode();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean inVMInternalCode() {
        return VMOperation.isInProgress() || ReferenceHandlerThread.isReferenceHandlerThread();
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private void enqueueCollectOperation(CollectionVMOperationData data) {
        this.collectOperation.enqueue(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectOperation(CollectionVMOperationData data) {
        assert (VMOperation.isGCInProgress());
        assert (this.getCollectionEpoch().equal(data.getRequestingEpoch()));
        this.timers.mutator.closeAt(data.getRequestingNanoTime());
        this.timers.resetAllExceptMutator();
        this.completeCollection = false;
        JfrGCHeapSummaryEvent.emit(JfrGCWhen.BEFORE_GC);
        GCCause cause = GCCause.fromId(data.getCauseId());
        this.printGCBefore(cause);
        try (Timer collectionTimer = this.timers.collection.open();){
            ThreadLocalAllocation.disableAndFlushForAllThreads();
            GenScavengeMemoryPoolMXBeans.notifyBeforeCollection();
            HeapImpl.getAccounting().notifyBeforeCollection();
            this.verifyHeap(HeapVerifier.Occasion.Before);
            boolean outOfMemory = this.collectImpl(cause, data.getRequestingNanoTime(), data.getForceFullGC());
            data.setOutOfMemory(outOfMemory);
            this.verifyHeap(HeapVerifier.Occasion.After);
        }
        this.accounting.updateCollectionCountAndTime(this.completeCollection, collectionTimer.getMeasuredNanos());
        HeapImpl.getAccounting().notifyAfterCollection();
        GenScavengeMemoryPoolMXBeans.notifyAfterCollection();
        ChunkBasedCommittedMemoryProvider.get().afterGarbageCollection();
        this.printGCAfter(cause);
        JfrGCHeapSummaryEvent.emit(JfrGCWhen.AFTER_GC);
        this.collectionEpoch = this.collectionEpoch.add(1);
        this.timers.mutator.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectImpl(GCCause cause, long requestingNanoTime, boolean forceFullGC) {
        boolean outOfMemory;
        block6: {
            long startTicks = JfrTicks.elapsedTicks();
            try {
                outOfMemory = this.doCollectImpl(cause, requestingNanoTime, forceFullGC, false);
                if (!outOfMemory) break block6;
                ReferenceObjectProcessing.setSoftReferencesAreWeak(true);
                try {
                    this.verifyHeap(HeapVerifier.Occasion.During);
                    outOfMemory = this.doCollectImpl(cause, requestingNanoTime, true, true);
                }
                finally {
                    ReferenceObjectProcessing.setSoftReferencesAreWeak(false);
                }
            }
            finally {
                JfrGCEvents.emitGarbageCollectionEvent(this.getCollectionEpoch(), cause, startTicks);
            }
        }
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCollectImpl(GCCause cause, long requestingNanoTime, boolean forceFullGC, boolean forceNoIncremental) {
        long startTicks;
        GCImpl.precondition();
        ChunkBasedCommittedMemoryProvider.get().beforeGarbageCollection();
        boolean incremental = !forceNoIncremental && !this.policy.shouldCollectCompletely(false);
        boolean outOfMemory = false;
        if (incremental) {
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                outOfMemory = this.doCollectOnce(cause, requestingNanoTime, false, false);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Incremental GC", startTicks);
            }
        }
        if (!incremental || outOfMemory || forceFullGC || this.policy.shouldCollectCompletely(incremental)) {
            if (incremental) {
                ChunkBasedCommittedMemoryProvider.get().uncommitUnusedMemory();
                this.verifyHeap(HeapVerifier.Occasion.During);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                outOfMemory = this.doCollectOnce(cause, requestingNanoTime, true, incremental);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Full GC", startTicks);
            }
        }
        HeapImpl.getChunkProvider().freeExcessAlignedChunks();
        ChunkBasedCommittedMemoryProvider.get().uncommitUnusedMemory();
        GCImpl.postcondition();
        return outOfMemory;
    }

    private boolean doCollectOnce(GCCause cause, long requestingNanoTime, boolean complete, boolean followsIncremental) {
        assert (!followsIncremental || complete) : "An incremental collection cannot be followed by another incremental collection";
        assert (!this.completeCollection || complete) : "After a complete collection, no further incremental collections may happen";
        this.completeCollection = complete;
        this.accounting.beforeCollectOnce(this.completeCollection);
        this.policy.onCollectionBegin(this.completeCollection, requestingNanoTime);
        this.scavenge(!complete);
        if (complete) {
            this.lastWholeHeapExaminedTimeMillis = System.currentTimeMillis();
        }
        this.accounting.afterCollectOnce(this.completeCollection);
        this.policy.onCollectionEnd(this.completeCollection, cause);
        UnsignedWord usedBytes = GCImpl.getChunkBytes();
        UnsignedWord freeBytes = this.policy.getCurrentHeapCapacity().subtract(usedBytes);
        ReferenceObjectProcessing.afterCollection(freeBytes);
        return usedBytes.aboveThan(this.policy.getMaximumHeapSize());
    }

    private void verifyHeap(HeapVerifier.Occasion occasion) {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue() && GCImpl.shouldVerify(occasion)) {
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
                this.printGCPrefixAndTime().string("Verifying ").string(occasion.name()).string(" GC ").newline();
            }
            long start = System.nanoTime();
            boolean success = true;
            success &= HeapVerifier.verify(occasion);
            if (!(success &= StackVerifier.verifyAllThreads())) {
                String kind = this.getGCKind();
                Log.log().string("Heap verification ").string(occasion.name()).string(" GC failed (").string(kind).string(" garbage collection)").newline();
                throw VMError.shouldNotReachHere("Heap verification failed");
            }
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
                this.printGCPrefixAndTime().string("Verifying ").string(occasion.name()).string(" GC ").rational(TimeUtils.nanoSecondsSince(start), 1000000L, 3L).string("ms").newline();
            }
        }
    }

    private static boolean shouldVerify(HeapVerifier.Occasion occasion) {
        return switch (occasion) {
            case HeapVerifier.Occasion.Before -> SerialGCOptions.VerifyBeforeGC.getValue();
            case HeapVerifier.Occasion.During -> SerialGCOptions.VerifyDuringGC.getValue();
            case HeapVerifier.Occasion.After -> SerialGCOptions.VerifyAfterGC.getValue();
            default -> throw VMError.shouldNotReachHere("Unexpected heap verification occasion.");
        };
    }

    private String getGCKind() {
        return this.isCompleteCollection() ? "complete" : "incremental";
    }

    public static UnsignedWord getChunkBytes() {
        UnsignedWord youngBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
        UnsignedWord oldBytes = HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
        return youngBytes.add(oldBytes);
    }

    private void printGCBefore(GCCause cause) {
        if (!SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            return;
        }
        if (this.getCollectionEpoch().equal(0)) {
            this.printGCPrefixAndTime().string("Using ").string(this.getName()).newline();
            Log log = this.printGCPrefixAndTime().spaces(2).string("Memory: ");
            if (!PhysicalMemory.isInitialized()) {
                log.string("unknown").newline();
            } else {
                log.rational(PhysicalMemory.getCachedSize(), 0x100000L, 0L).string("M").newline();
            }
            this.printGCPrefixAndTime().spaces(2).string("GC policy: ").string(GCImpl.getPolicy().getName()).newline();
            this.printGCPrefixAndTime().spaces(2).string("Maximum young generation size: ").rational(GCImpl.getPolicy().getMaximumYoungGenerationSize(), 0x100000L, 0L).string("M").newline();
            this.printGCPrefixAndTime().spaces(2).string("Maximum heap size: ").rational(GCImpl.getPolicy().getMaximumHeapSize(), 0x100000L, 0L).string("M").newline();
            this.printGCPrefixAndTime().spaces(2).string("Minimum heap size: ").rational(GCImpl.getPolicy().getMinimumHeapSize(), 0x100000L, 0L).string("M").newline();
            this.printGCPrefixAndTime().spaces(2).string("Aligned chunk size: ").rational(HeapParameters.getAlignedHeapChunkSize(), 1024L, 0L).string("K").newline();
            this.printGCPrefixAndTime().spaces(2).string("Large array threshold: ").rational(HeapParameters.getLargeArrayThreshold(), 1024L, 0L).string("K").newline();
        }
        this.printGCPrefixAndTime().string(cause.getName()).newline();
    }

    private void printGCAfter(GCCause cause) {
        HeapAccounting heapAccounting = HeapImpl.getAccounting();
        HeapAccounting.HeapSizes beforeGc = heapAccounting.getHeapSizesBeforeGc();
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            this.printHeapSizeChange("Eden", beforeGc.eden, heapAccounting.getEdenUsedBytes());
            this.printHeapSizeChange("Survivor", beforeGc.survivor, heapAccounting.getSurvivorUsedBytes());
            this.printHeapSizeChange("Old", beforeGc.old, heapAccounting.getOldUsedBytes());
            this.printHeapSizeChange("Free", beforeGc.free, heapAccounting.getBytesInUnusedChunks());
            if (SerialGCOptions.PrintGCTimes.getValue().booleanValue()) {
                this.timers.logAfterCollection(Log.log());
            }
            if (SerialGCOptions.TraceHeapChunks.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().logChunks(Log.log(), false);
            }
        }
        if (SubstrateGCOptions.PrintGC.getValue().booleanValue() || SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            String collectionType = this.completeCollection ? "Full GC" : "Incremental GC";
            this.printGCPrefixAndTime().string(collectionType).string(" (").string(cause.getName()).string(") ").rational(beforeGc.totalUsed(), 0x100000L, 2L).string("M->").rational(heapAccounting.getUsedBytes(), 0x100000L, 2L).string("M ").rational(this.timers.collection.getMeasuredNanos(), 1000000L, 3L).string("ms").newline();
        }
    }

    private void printHeapSizeChange(String text, UnsignedWord before, UnsignedWord after) {
        this.printGCPrefixAndTime().string("  ").string(text).string(": ").rational(before, 0x100000L, 2L).string("M->").rational(after, 0x100000L, 2L).string("M").newline();
    }

    private Log printGCPrefixAndTime() {
        long uptimeMs = Isolates.getCurrentUptimeMillis();
        return Log.log().string("[").rational(uptimeMs, 1000L, 3L).string("s").string("] GC(").unsigned((WordBase)this.collectionEpoch).string(") ");
    }

    private static void precondition() {
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
    }

    private static void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        assert (youngGen.getEden().isEmpty()) : "youngGen.getEden() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
    }

    @Fold
    static boolean runtimeAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(GCImpl.class);
    }

    @Fold
    public static GCImpl getGCImpl() {
        GCImpl gcImpl = HeapImpl.getGCImpl();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Override
    public void collectCompletely(GCCause cause) {
        this.collect(cause, true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isCompleteCollection() {
        return this.completeCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge(boolean incremental) {
        try (GreyToBlackObjRefVisitor.Counters counters = this.greyToBlackObjRefVisitor.openCounters();){
            long startTicks;
            try (Timer rootScanTimer = this.timers.rootScan.open();){
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    this.cheneyScan(incremental);
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), incremental ? "Incremental Scan" : "Scan", startTicks);
                }
                catch (Throwable throwable) {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), incremental ? "Incremental Scan" : "Scan", startTicks);
                    throw throwable;
                }
            }
            try (Timer referenceObjectsTimer = this.timers.referenceObjects.open();){
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    Reference<?> newlyPendingList = ReferenceObjectProcessing.processRememberedReferences();
                    HeapImpl.getHeapImpl().addToReferencePendingList(newlyPendingList);
                }
                finally {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Process Remembered References", startTicks);
                }
            }
            if (RuntimeCompilation.isEnabled()) {
                try (Timer cleanCodeCacheTimer = this.timers.cleanCodeCache.open();){
                    startTicks = JfrGCEvents.startGCPhasePause();
                    try {
                        this.cleanRuntimeCodeCache();
                    }
                    finally {
                        JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Clean Runtime CodeCache", startTicks);
                    }
                }
            }
            try (Timer releaseSpacesTimer = this.timers.releaseSpaces.open();){
                assert (this.chunkReleaser.isEmpty());
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    this.releaseSpaces();
                    boolean keepAllAlignedChunks = incremental;
                    this.chunkReleaser.release(keepAllAlignedChunks);
                }
                finally {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Release Spaces", startTicks);
                }
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.swapSpaces();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Swap Spaces", startTicks);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void walkRuntimeCodeCache() {
        try (Timer walkRuntimeCodeCacheTimer = this.timers.walkRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheWalker);
        }
    }

    private void cleanRuntimeCodeCache() {
        try (Timer cleanRuntimeCodeCacheTimer = this.timers.cleanRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheCleaner);
        }
    }

    @Uninterruptible(reason="We don't want any safepoint checks in the core part of the GC.")
    private void cheneyScan(boolean incremental) {
        if (incremental) {
            this.cheneyScanFromDirtyRoots();
        } else {
            this.cheneyScanFromRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cheneyScanFromRoots() {
        try (Timer cheneyScanFromRootsTimer = this.timers.cheneyScanFromRoots.open();){
            long startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.prepareForPromotion(false);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Snapshot Heap", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.promoteChunksWithPinnedObjects();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Pinned Objects", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.blackenStackRoots();
                this.walkThreadLocals();
                this.blackenImageHeapRoots();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan Roots", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.scanGreyObjects(false);
                if (RuntimeCompilation.isEnabled()) {
                    this.walkRuntimeCodeCache();
                    this.scanGreyObjects(false);
                }
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan From Roots", startTicks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cheneyScanFromDirtyRoots() {
        try (Timer cheneyScanFromDirtyRootsTimer = this.timers.cheneyScanFromDirtyRoots.open();){
            long startTicks = JfrGCEvents.startGCPhasePause();
            try {
                OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
                oldGen.emptyFromSpaceIntoToSpace();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Old Generation", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.prepareForPromotion(true);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Snapshot Heap", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.promoteChunksWithPinnedObjects();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Pinned Objects", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.blackenDirtyCardRoots();
                this.blackenStackRoots();
                this.walkThreadLocals();
                this.blackenDirtyImageHeapRoots();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan Roots", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.scanGreyObjects(true);
                if (RuntimeCompilation.isEnabled()) {
                    this.walkRuntimeCodeCache();
                    this.scanGreyObjects(true);
                }
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan From Roots", startTicks);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void promoteChunksWithPinnedObjects() {
        try (Timer promotePinnedObjectsTimer = this.timers.promotePinnedObjects.open();){
            for (AbstractPinnedObjectSupport.PinnedObjectImpl cur = AbstractPinnedObjectSupport.singleton().removeClosedObjectsAndGetFirstOpenObject(); cur != null; cur = cur.getNext()) {
                this.promotePinnedObject(cur.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.")
    private void blackenStackRoots() {
        try (Timer blackenStackRootsTimer = this.timers.blackenStackRoots.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
            JavaStackWalker.initWalk(walk, sp, ip);
            this.walkStack(walk);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread() && JavaStackWalker.initWalk(walk, vmThread)) {
                        this.walkStack(walk);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
        }
    }

    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.")
    private void walkStack(JavaStackWalk walk) {
        DeoptimizedFrame deoptFrame;
        SimpleCodeInfoQueryResult queryResult;
        assert (VMOperation.isGCInProgress()) : "This methods accesses a CodeInfo without a tether";
        do {
            queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
            Pointer sp = walk.getSP();
            CodePointer ip = walk.getPossiblyStaleIP();
            CodeInfo codeInfo = CodeInfoAccess.convert(walk.getIPCodeInfo());
            deoptFrame = Deoptimizer.checkDeoptimized(sp);
            if (deoptFrame == null) {
                if (codeInfo.isNull()) {
                    throw JavaStackWalker.reportUnknownFrameEncountered(sp, ip, deoptFrame);
                }
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                assert (Deoptimizer.checkDeoptimized(sp) == null) : "We are at a safepoint, so no deoptimization can have happened";
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) {
                    throw CodeInfoTable.reportNoReferenceMap(sp, ip, codeInfo);
                }
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, this.greyToBlackObjRefVisitor, null);
            }
            if (!RuntimeCompilation.isEnabled() || codeInfo == CodeInfoTable.getImageCodeInfo()) continue;
            RuntimeCodeInfoAccess.walkTether(codeInfo, this.greyToBlackObjRefVisitor);
        } while (JavaStackWalker.continueWalk(walk, queryResult, deoptFrame));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void walkThreadLocals() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            try (Timer walkThreadLocalsTimer = this.timers.walkThreadLocals.open();){
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    VMThreadLocalMTSupport.singleton().walk(isolateThread, this.greyToBlackObjRefVisitor);
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void blackenDirtyImageHeapRoots() {
        if (!HeapImpl.usesImageHeapCardMarking()) {
            this.blackenImageHeapRoots();
            return;
        }
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            ImageHeapInfo auxInfo;
            ImageHeapInfo info = HeapImpl.getImageHeapInfo();
            this.blackenDirtyImageHeapChunkRoots(info.getFirstWritableAlignedChunk(), info.getFirstWritableUnalignedChunk());
            if (AuxiliaryImageHeap.isPresent() && (auxInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                this.blackenDirtyImageHeapChunkRoots(auxInfo.getFirstWritableAlignedChunk(), auxInfo.getFirstWritableUnalignedChunk());
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void blackenDirtyImageHeapChunkRoots(AlignedHeapChunk.AlignedHeader firstAligned, UnalignedHeapChunk.UnalignedHeader firstUnaligned) {
        boolean clean = this.completeCollection;
        AlignedHeapChunk.AlignedHeader aligned = firstAligned;
        while (aligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(aligned, this.greyToBlackObjectVisitor, clean);
            aligned = HeapChunk.getNext(aligned);
        }
        UnalignedHeapChunk.UnalignedHeader unaligned = firstUnaligned;
        while (unaligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(unaligned, this.greyToBlackObjectVisitor, clean);
            unaligned = HeapChunk.getNext(unaligned);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void blackenImageHeapRoots() {
        if (HeapImpl.usesImageHeapCardMarking()) {
            this.blackenDirtyImageHeapRoots();
            return;
        }
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            ImageHeapInfo auxImageHeapInfo;
            this.blackenImageHeapRoots(HeapImpl.getImageHeapInfo());
            if (AuxiliaryImageHeap.isPresent() && (auxImageHeapInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                this.blackenImageHeapRoots(auxImageHeapInfo);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void blackenImageHeapRoots(ImageHeapInfo imageHeapInfo) {
        ImageHeapWalker.walkPartitionInline(imageHeapInfo.firstWritableReferenceObject, imageHeapInfo.lastWritableReferenceObject, this.greyToBlackObjectVisitor, true);
        ImageHeapWalker.walkPartitionInline(imageHeapInfo.firstWritableHugeObject, imageHeapInfo.lastWritableHugeObject, this.greyToBlackObjectVisitor, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void blackenDirtyCardRoots() {
        try (Timer blackenDirtyCardRootsTimer = this.timers.blackenDirtyCardRoots.open();){
            Space oldGenToSpace = HeapImpl.getHeapImpl().getOldGeneration().getToSpace();
            RememberedSet.get().walkDirtyObjects(oldGenToSpace, this.greyToBlackObjectVisitor, true);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void prepareForPromotion(boolean isIncremental) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getOldGeneration().prepareForPromotion();
        if (isIncremental) {
            heap.getYoungGeneration().prepareForPromotion();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void scanGreyObjects(boolean isIncremental) {
        try (Timer scanGreyObjectsTimer = this.timers.scanGreyObjects.open();){
            if (isIncremental) {
                GCImpl.scanGreyObjectsLoop();
            } else {
                HeapImpl.getHeapImpl().getOldGeneration().scanGreyObjects();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void scanGreyObjectsLoop() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        do {
            boolean hasGrey = youngGen.scanGreyObjects();
        } while (hasGrey |= oldGen.scanGreyObjects());
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object promoteObject(Object original, UnsignedWord header) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        boolean isAligned = ObjectHeaderImpl.isAlignedHeader(header);
        HeapChunk.Header<?> originalChunk = GCImpl.getChunk(original, isAligned);
        Space originalSpace = HeapChunk.getSpace(originalChunk);
        if (!originalSpace.isFromSpace()) {
            return original;
        }
        Object result = null;
        if (!this.completeCollection && originalSpace.getNextAgeForPromotion() < this.policy.getTenuringAge() && (result = isAligned ? heap.getYoungGeneration().promoteAlignedObject(original, (AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace) : heap.getYoungGeneration().promoteUnalignedObject(original, (UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace)) == null) {
            this.accounting.onSurvivorOverflowed();
        }
        if (result == null) {
            result = isAligned ? heap.getOldGeneration().promoteAlignedObject(original, (AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace) : heap.getOldGeneration().promoteUnalignedObject(original, (UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
            assert (result != null) : "promotion failure in old generation must have been handled";
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static HeapChunk.Header<?> getChunk(Object obj, boolean isAligned) {
        if (isAligned) {
            return AlignedHeapChunk.getEnclosingChunk(obj);
        }
        assert (ObjectHeaderImpl.isUnalignedObject(obj));
        return UnalignedHeapChunk.getEnclosingChunk(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void promotePinnedObject(Object pinned) {
        assert (pinned != null);
        assert (!Heap.getHeap().isInImageHeap(pinned));
        assert (HeapChunk.getEnclosingHeapChunk(pinned).getPinnedObjectCount() > 0);
        HeapImpl heap = HeapImpl.getHeapImpl();
        boolean isAligned = ObjectHeaderImpl.isAlignedObject(pinned);
        HeapChunk.Header<?> originalChunk = GCImpl.getChunk(pinned, isAligned);
        Space originalSpace = HeapChunk.getSpace(originalChunk);
        if (originalSpace.isFromSpace()) {
            boolean promoted = false;
            if (!this.completeCollection && originalSpace.getNextAgeForPromotion() < this.policy.getTenuringAge() && !(promoted = heap.getYoungGeneration().promoteChunk(originalChunk, isAligned, originalSpace))) {
                this.accounting.onSurvivorOverflowed();
            }
            if (!promoted) {
                heap.getOldGeneration().promoteChunk(originalChunk, isAligned, originalSpace);
            }
        }
    }

    private static void swapSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        heap.getYoungGeneration().swapSpaces();
        oldGen.swapSpaces();
    }

    private void releaseSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces(this.chunkReleaser);
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces(this.chunkReleaser);
        }
    }

    static void doReferenceHandling() {
        assert (!VMOperation.isInProgress()) : "could result in deadlocks";
        assert (PlatformThreads.isCurrentAssigned()) : "thread is not fully initialized yet";
        if (HeapImpl.getHeapImpl().hasReferencePendingListUnsafe()) {
            long startTime = System.nanoTime();
            ReferenceHandler.processPendingReferencesInRegularThread();
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && SerialGCOptions.PrintGCTimes.getValue().booleanValue()) {
                long executionTime = System.nanoTime() - startTime;
                Log.log().string("[GC epilogue reference processing and cleaners: ").signed(executionTime).string("]").newline();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    public long getMillisSinceLastWholeHeapExamined() {
        long startMillis = this.lastWholeHeapExaminedTimeMillis < 0L ? Isolates.getCurrentStartTimeMillis() : this.lastWholeHeapExaminedTimeMillis;
        return System.currentTimeMillis() - startMillis;
    }

    @Fold
    public static GCAccounting getAccounting() {
        return GCImpl.getGCImpl().accounting;
    }

    @Fold
    public static CollectionPolicy getPolicy() {
        return GCImpl.getGCImpl().policy;
    }

    @Fold
    public static boolean hasNeverCollectPolicy() {
        return GCImpl.getPolicy() instanceof BasicCollectionPolicies.NeverCollect;
    }

    @Fold
    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    private static void printGCSummary() {
        if (!SerialGCOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        PrintGCSummaryOperation vmOp = new PrintGCSummaryOperation();
        vmOp.enqueue();
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory("CollectionVMOperation", false);

        CollectionVMOperation() {
            super(VMOperationInfos.get(CollectionVMOperation.class, "Garbage collection", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isGC() {
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
                CollectionVMOperation.collect((CollectionVMOperationData)data);
            }
        }

        private static void collect(CollectionVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                HeapImpl.getGCImpl().collectOperation(data);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        @Override
        protected boolean hasWork(NativeVMOperationData data) {
            CollectionVMOperationData d = (CollectionVMOperationData)data;
            return HeapImpl.getGCImpl().getCollectionEpoch().equal(d.getRequestingEpoch());
        }
    }

    public static class ChunkReleaser {
        private AlignedHeapChunk.AlignedHeader firstAligned;
        private UnalignedHeapChunk.UnalignedHeader firstUnaligned;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ChunkReleaser() {
        }

        public boolean isEmpty() {
            return this.firstAligned.isNull() && this.firstUnaligned.isNull();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void add(AlignedHeapChunk.AlignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstAligned.isNonNull()) {
                    AlignedHeapChunk.AlignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstAligned);
                    HeapChunk.setPrevious(this.firstAligned, lastNewChunk);
                }
                this.firstAligned = chunks;
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void add(UnalignedHeapChunk.UnalignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstUnaligned.isNonNull()) {
                    UnalignedHeapChunk.UnalignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstUnaligned);
                    HeapChunk.setPrevious(this.firstUnaligned, lastNewChunk);
                }
                this.firstUnaligned = chunks;
            }
        }

        void release(boolean keepAllAlignedChunks) {
            if (this.firstAligned.isNonNull()) {
                HeapImpl.getChunkProvider().consumeAlignedChunks(this.firstAligned, keepAllAlignedChunks);
                this.firstAligned = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
            }
            if (this.firstUnaligned.isNonNull()) {
                HeapChunkProvider.consumeUnalignedChunks(this.firstUnaligned);
                this.firstUnaligned = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static <T extends HeapChunk.Header<T>> T getLast(T chunks) {
            T prev = chunks;
            Object next = HeapChunk.getNext(prev);
            while (next.isNonNull()) {
                prev = next;
                next = HeapChunk.getNext(prev);
            }
            return prev;
        }
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public long getRequestingNanoTime();

        @RawField
        public void setRequestingNanoTime(long var1);

        @RawField
        public boolean getForceFullGC();

        @RawField
        public void setForceFullGC(boolean var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }

    private static class PrintGCSummaryOperation
    extends JavaVMOperation {
        protected PrintGCSummaryOperation() {
            super(VMOperationInfos.get(PrintGCSummaryOperation.class, "Print GC summary", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            ThreadLocalAllocation.disableAndFlushForAllThreads();
            Log log = Log.log();
            log.string("GC summary").indent(true);
            HeapImpl heap = HeapImpl.getHeapImpl();
            Space edenSpace = heap.getYoungGeneration().getEden();
            UnsignedWord youngChunkBytes = edenSpace.getChunkBytes();
            UnsignedWord youngObjectBytes = edenSpace.computeObjectBytes();
            GCAccounting accounting = GCImpl.getAccounting();
            UnsignedWord allocatedChunkBytes = accounting.getTotalAllocatedChunkBytes().add(youngChunkBytes);
            UnsignedWord allocatedObjectBytes = accounting.getAllocatedObjectBytes().add(youngObjectBytes);
            log.string("Collected chunk bytes: ").rational(accounting.getTotalCollectedChunkBytes(), 0x100000L, 2L).string("M").newline();
            log.string("Collected object bytes: ").rational(accounting.getTotalCollectedObjectBytes(), 0x100000L, 2L).string("M").newline();
            log.string("Allocated chunk bytes: ").rational(allocatedChunkBytes, 0x100000L, 2L).string("M").newline();
            log.string("Allocated object bytes: ").rational(allocatedObjectBytes, 0x100000L, 2L).string("M").newline();
            long incrementalNanos = accounting.getIncrementalCollectionTotalNanos();
            log.string("Incremental GC count: ").signed(accounting.getIncrementalCollectionCount()).newline();
            log.string("Incremental GC time: ").rational(incrementalNanos, 1000000000L, 3L).string("s").newline();
            long completeNanos = accounting.getCompleteCollectionTotalNanos();
            log.string("Complete GC count: ").signed(accounting.getCompleteCollectionCount()).newline();
            log.string("Complete GC time: ").rational(completeNanos, 1000000000L, 3L).string("s").newline();
            long gcNanos = incrementalNanos + completeNanos;
            long mutatorNanos = GCImpl.getGCImpl().timers.mutator.getMeasuredNanos();
            long totalNanos = gcNanos + mutatorNanos;
            long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
            log.string("GC time: ").rational(gcNanos, 1000000000L, 3L).string("s").newline();
            log.string("Run time: ").rational(totalNanos, 1000000000L, 3L).string("s").newline();
            log.string("GC load: ").signed(roundedGCLoad).string("%").indent(false);
        }
    }
}

