/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.target.EncodedReflectionMetadataSupplier;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.image.HostedInstantReferenceAdjuster;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class NativeImageCodeCache {
    protected final NativeImageHeap imageHeap;
    private final Map<HostedMethod, CompilationResult> compilations;
    private final List<Pair<HostedMethod, CompilationResult>> orderedCompilations;
    protected final Platform targetPlatform;
    private final DataSection dataSection;
    private final Map<Constant, String> constantReasons = new HashMap<Constant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        this(compilationResultMap, imageHeap, (Platform)ImageSingletons.lookup(Platform.class));
    }

    public void purge() {
        this.compilations.clear();
        this.orderedCompilations.clear();
    }

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
        this.targetPlatform = targetPlatform;
        this.orderedCompilations = this.computeCompilationOrder(compilations);
    }

    public abstract int getCodeCacheSize();

    public abstract int getCodeAreaSize();

    public Pair<HostedMethod, CompilationResult> getFirstCompilation() {
        return this.orderedCompilations.get(0);
    }

    public Pair<HostedMethod, CompilationResult> getLastCompilation() {
        return this.orderedCompilations.get(this.orderedCompilations.size() - 1);
    }

    protected List<Pair<HostedMethod, CompilationResult>> computeCompilationOrder(Map<HostedMethod, CompilationResult> compilationMap) {
        return compilationMap.entrySet().stream().map(e -> Pair.create((Object)((HostedMethod)e.getKey()), (Object)((CompilationResult)e.getValue()))).sorted(Comparator.comparing(o -> ((HostedMethod)o.getLeft()).wrapped.format("%H.%n(%P):%R"))).collect(Collectors.toList());
    }

    public List<Pair<HostedMethod, CompilationResult>> getOrderedCompilations() {
        return this.orderedCompilations;
    }

    public abstract int codeSizeFor(HostedMethod var1);

    protected CompilationResult compilationResultFor(HostedMethod method) {
        return this.compilations.get(method);
    }

    public abstract void layoutMethods(DebugContext var1, BigBang var2, ForkJoinPool var3);

    public void layoutConstants() {
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            JavaConstant constant;
            CompilationResult compilation = (CompilationResult)pair.getRight();
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put((Constant)constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
            for (DataPatch patch : compilation.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                constant = ((ConstantReference)patch.reference).getConstant();
                this.constantReasons.put((Constant)constant, compilation.getName());
            }
        }
        this.dataSection.close(HostedOptionValues.singleton(), 1);
    }

    public void addConstantsToHeap() {
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            JavaConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
            this.addConstantToHeap((Constant)constant, (Object)NativeImageHeap.HeapInclusionReason.DataSection);
        }
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            CompilationResult compilationResult = (CompilationResult)pair.getRight();
            for (DataPatch patch : compilationResult.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                this.addConstantToHeap((Constant)((ConstantReference)patch.reference).getConstant(), compilationResult.getName());
            }
            for (CompilationResult.CodeAnnotation codeAnnotation : compilationResult.getCodeAnnotations()) {
                if (!(codeAnnotation instanceof HostedImageHeapConstantPatch)) continue;
                this.addConstantToHeap((Constant)((HostedImageHeapConstantPatch)codeAnnotation).constant, compilationResult.getName());
            }
        }
    }

    private void addConstantToHeap(Constant constant, Object reason) {
        if (constant instanceof SubstrateMethodPointerConstant) {
            return;
        }
        HostedType hostedType = this.imageHeap.hMetaAccess.lookupJavaType((JavaConstant)constant);
        if (!hostedType.isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + hostedType.getName() + "." + (String)(reason != null ? " Method: " + reason : ""));
        }
        this.imageHeap.addConstant((JavaConstant)constant, false, reason != null ? reason : this.constantReasons.get(constant));
    }

    protected int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public void buildRuntimeMetadata(SnippetReflectionProvider snippetReflection, ForkJoinPool threadPool, CFunctionPointer firstMethod, UnsignedWord codeSize) {
        String name;
        HostedType declaringType;
        HostedFrameInfoCustomization frameInfoCustomization = new HostedFrameInfoCustomization();
        CodeInfoEncoder.Encoders encoders = new CodeInfoEncoder.Encoders();
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization, encoders);
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            this.encodeMethod(codeInfoEncoder, pair);
        }
        HostedUniverse hUniverse = this.imageHeap.hUniverse;
        HostedMetaAccess hMetaAccess = this.imageHeap.hMetaAccess;
        ReflectionMetadataEncoder reflectionMetadataEncoder = ((ReflectionMetadataEncoderFactory)ImageSingletons.lookup(ReflectionMetadataEncoderFactory.class)).create(hUniverse.getSnippetReflection(), encoders);
        ReflectionHostedSupport reflectionSupport = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        Map<Class<?>, Set<Class<?>>> innerClasses = reflectionSupport.getReflectionInnerClasses();
        Set<?> heapDynamicHubs = reflectionSupport.getHeapDynamicHubs();
        for (HostedType type : hUniverse.getTypes()) {
            if (!type.getWrapped().isReachable() || !heapDynamicHubs.contains(type.getHub())) continue;
            Class[] typeInnerClasses = innerClasses.getOrDefault(type.getJavaClass(), Collections.emptySet()).toArray(new Class[0]);
            reflectionMetadataEncoder.addClassMetadata((MetaAccessProvider)hMetaAccess, type, typeInnerClasses);
        }
        HashSet<AnalysisField> includedFields = new HashSet<AnalysisField>();
        HashSet<AnalysisMethod> includedMethods = new HashSet<AnalysisMethod>();
        Map<AnalysisField, Field> configurationFields = reflectionSupport.getReflectionFields();
        Map<AnalysisMethod, Executable> configurationExecutables = reflectionSupport.getReflectionExecutables();
        reflectionSupport.getHeapReflectionFields().forEach((analysisField, reflectField) -> {
            if (includedFields.add((AnalysisField)analysisField)) {
                HostedField hostedField = hUniverse.lookup((JavaField)analysisField);
                reflectionMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedField, (AccessibleObject)reflectField, configurationFields.containsKey(analysisField));
            }
        });
        reflectionSupport.getHeapReflectionExecutables().forEach((analysisMethod, reflectMethod) -> {
            if (includedMethods.add((AnalysisMethod)analysisMethod)) {
                HostedMethod hostedMethod = hUniverse.lookup((JavaMethod)analysisMethod);
                reflectionMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedMethod, (AccessibleObject)reflectMethod, configurationExecutables.containsKey(analysisMethod));
            }
        });
        configurationFields.forEach((analysisField, reflectField) -> {
            if (includedFields.add((AnalysisField)analysisField)) {
                HostedField hostedField = hUniverse.lookup((JavaField)analysisField);
                reflectionMetadataEncoder.addReflectionFieldMetadata((MetaAccessProvider)hMetaAccess, hostedField, (Field)reflectField);
            }
        });
        configurationExecutables.forEach((analysisMethod, reflectMethod) -> {
            if (includedMethods.add((AnalysisMethod)analysisMethod)) {
                HostedMethod method = hUniverse.lookup((JavaMethod)analysisMethod);
                Object accessor = reflectionSupport.getAccessor((AnalysisMethod)analysisMethod);
                reflectionMetadataEncoder.addReflectionExecutableMetadata((MetaAccessProvider)hMetaAccess, method, (Executable)reflectMethod, accessor);
            }
        });
        for (Object obj : reflectionSupport.getHidingReflectionFields()) {
            AnalysisField analysisField2 = (AnalysisField)obj;
            if (!includedFields.add(analysisField2)) continue;
            declaringType = hUniverse.lookup((JavaType)analysisField2.getDeclaringClass());
            name = analysisField2.getName();
            HostedType type = hUniverse.lookup((JavaType)analysisField2.getType());
            int modifiers = analysisField2.getModifiers();
            reflectionMetadataEncoder.addHidingFieldMetadata(analysisField2, declaringType, name, type, modifiers);
        }
        for (Object obj : reflectionSupport.getHidingReflectionMethods()) {
            AnalysisMethod analysisMethod2 = (AnalysisMethod)obj;
            if (!includedMethods.add(analysisMethod2)) continue;
            declaringType = hUniverse.lookup((JavaType)analysisMethod2.getDeclaringClass());
            name = analysisMethod2.getName();
            JavaType[] analysisParameterTypes = analysisMethod2.getSignature().toParameterTypes(null);
            HostedType[] parameterTypes = new HostedType[analysisParameterTypes.length];
            for (int i = 0; i < analysisParameterTypes.length; ++i) {
                parameterTypes[i] = hUniverse.lookup(analysisParameterTypes[i]);
            }
            int modifiers = analysisMethod2.getModifiers();
            HostedType returnType = hUniverse.lookup(analysisMethod2.getSignature().getReturnType(null));
            reflectionMetadataEncoder.addHidingMethodMetadata(analysisMethod2, declaringType, name, parameterTypes, modifiers, returnType);
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (HostedField hostedField : hUniverse.getFields()) {
                if (!hostedField.isAccessed() || includedFields.contains(hostedField.getWrapped())) continue;
                reflectionMetadataEncoder.addReachableFieldMetadata(hostedField);
            }
            for (HostedMethod hostedMethod : hUniverse.getMethods()) {
                if (!hostedMethod.getWrapped().isReachable() || hostedMethod.getWrapped().isIntrinsicMethod() || includedMethods.contains(hostedMethod.getWrapped())) continue;
                reflectionMetadataEncoder.addReachableExecutableMetadata(hostedMethod);
            }
        }
        if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            reflectionSupport.getNegativeFieldQueries().forEach((analysisType, fieldNames) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (String fieldName : fieldNames) {
                        reflectionMetadataEncoder.addNegativeFieldQueryMetadata(hostedType, fieldName);
                    }
                }
            });
            reflectionSupport.getNegativeMethodQueries().forEach((analysisType, methodSignatures) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (AnalysisMethod.Signature methodSignature : methodSignatures) {
                        HostedType[] parameterTypes = hUniverse.optionalLookup((JavaType[])methodSignature.parameterTypes());
                        if (parameterTypes == null) continue;
                        reflectionMetadataEncoder.addNegativeMethodQueryMetadata(hostedType, methodSignature.name(), parameterTypes);
                    }
                }
            });
            reflectionSupport.getNegativeConstructorQueries().forEach((analysisType, constructorSignatures) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (AnalysisType[] analysisParameterTypes : constructorSignatures) {
                        HostedType[] parameterTypes = hUniverse.optionalLookup((JavaType[])analysisParameterTypes);
                        if (parameterTypes == null) continue;
                        reflectionMetadataEncoder.addNegativeConstructorQueryMetadata(hostedType, parameterTypes);
                    }
                }
            });
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
            System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
        }
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = this.installCodeInfo(snippetReflection, firstMethod, codeSize, codeInfoEncoder, reflectionMetadataEncoder);
        if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
            System.out.println("****Start Code Info Encoder Counters****");
            for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                System.out.println(counter.getName() + " ; " + counter.getValue());
            }
            System.out.println("****End Code Info Encoder Counters****");
        }
        if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
            this.verifyDeoptEntries(imageCodeInfo);
        }
        assert (this.verifyMethods(hUniverse, threadPool, codeInfoEncoder, imageCodeInfo));
    }

    protected ImageCodeInfo.HostedImageCodeInfo installCodeInfo(SnippetReflectionProvider snippetReflection, CFunctionPointer firstMethod, UnsignedWord codeSize, CodeInfoEncoder codeInfoEncoder, ReflectionMetadataEncoder reflectionMetadataEncoder) {
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache().getHostedImageCodeInfo();
        codeInfoEncoder.encodeAllAndInstall(imageCodeInfo, new HostedInstantReferenceAdjuster(snippetReflection));
        reflectionMetadataEncoder.encodeAllAndInstall();
        imageCodeInfo.setCodeStart((CodePointer)firstMethod);
        imageCodeInfo.setCodeSize(codeSize);
        imageCodeInfo.setDataOffset(codeSize);
        imageCodeInfo.setDataSize((UnsignedWord)WordFactory.zero());
        imageCodeInfo.setCodeAndDataMemorySize(codeSize);
        return imageCodeInfo;
    }

    protected void encodeMethod(CodeInfoEncoder codeInfoEncoder, Pair<HostedMethod, CompilationResult> pair) {
        HostedMethod method = (HostedMethod)pair.getLeft();
        CompilationResult compilation = (CompilationResult)pair.getRight();
        codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset(), this.codeSizeFor(method));
    }

    private void verifyDeoptEntries(CodeInfo codeInfo) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Map<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Map<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo>>>(SubstrateCompilationDirectives.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort(Comparator.comparing(e -> ((AnalysisMethod)e.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.hUniverse.lookup((JavaMethod)((AnalysisMethod)entry.getKey()).getMultiMethod(MultiMethod.ORIGINAL_METHOD));
            if (method.hasCalleeSavedRegisters()) {
                System.out.println("DeoptEntry has callee saved registers: " + method.format("%H.%n(%p)"));
                hasError = true;
            }
            ArrayList sourceFrameInfos = new ArrayList(((Map)entry.getValue()).entrySet());
            sourceFrameInfos.sort(Comparator.comparingLong(Map.Entry::getKey));
            for (Map.Entry entry2 : sourceFrameInfos) {
                hasError = NativeImageCodeCache.verifyDeoptEntry(codeInfo, method, entry2) || hasError;
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(CodeInfo codeInfo, HostedMethod method, Map.Entry<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo> sourceFrameInfo) {
        boolean hasExceptionHandler;
        int deoptOffsetInImage = method.getDeoptOffsetInImage();
        long encodedBci = sourceFrameInfo.getKey();
        if (sourceFrameInfo.getValue() == SubstrateCompilationDirectives.DeoptSourceFrameInfo.INVALID_DEOPT_SOURCE_FRAME) {
            return NativeImageCodeCache.error(method, encodedBci, "Incompatible source frames; multiple frames with different sizes of locals, locks, and/or stack values exist");
        }
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(codeInfo, deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        FrameInfoQueryResult targetFrame = result.getFrameInfo();
        if (targetFrame == null || !targetFrame.isDeoptEntry() || targetFrame.getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        boolean bl = hasExceptionHandler = result.getExceptionOffset() != 0L;
        if (!targetFrame.duringCall() && !targetFrame.rethrowException()) {
            if (!hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "no exception handler registered for deopt entry");
            }
        } else if (!targetFrame.duringCall() && targetFrame.rethrowException()) {
            if (hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "exception handler registered for rethrowException");
            }
        } else if (targetFrame.duringCall() && !targetFrame.rethrowException()) {
            if (!hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "no exception handler registered for deopt entry");
            }
        } else {
            return NativeImageCodeCache.error(method, encodedBci, "invalid encoded bci");
        }
        SubstrateCompilationDirectives.DeoptSourceFrameInfo sourceFrame = sourceFrameInfo.getValue();
        FrameInfoQueryResult.ValueInfo[] targetValues = targetFrame.getValueInfos();
        List<JavaKind> sourceKinds = Arrays.asList(sourceFrame.expectedKinds);
        if (targetFrame.getNumLocals() != sourceFrame.numLocals || targetFrame.getNumStack() != sourceFrame.numStack || targetFrame.getNumLocks() != sourceFrame.numLocks) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Mismatch between number of expected values in target and source.").append(System.lineSeparator());
            errorMessage.append(String.format("Target: locals-%d, stack-%d, locks-%d.%n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            errorMessage.append(String.format("Source: locals-%d, stack-%d, locks-%d.%n", sourceFrame.numLocals, sourceFrame.numStack, sourceFrame.numLocks));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        boolean validTarget = true;
        for (int i = 0; i < targetValues.length; ++i) {
            JavaKind targetKind = targetValues[i].getKind();
            if (targetKind == JavaKind.Illegal || targetKind == sourceKinds.get(i)) continue;
            validTarget = false;
            break;
        }
        if (!validTarget) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(String.format("Deoptimization source frame is not a superset of the target frame.%n", new Object[0]));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        return false;
    }

    private static void appendFrameInfo(StringBuilder builder, boolean isTarget, List<JavaKind> javaKinds) {
        builder.append(String.format("***%s Frame***%n", isTarget ? "Target" : "Source"));
        for (int i = 0; i < javaKinds.size(); ++i) {
            builder.append(String.format("index %d: %s%n", i, javaKinds.get(i)));
        }
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "):" + System.lineSeparator() + msg);
        return true;
    }

    protected boolean verifyMethods(HostedUniverse hUniverse, ForkJoinPool threadPool, CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo) {
        Inflation bb = hUniverse.getBigBang();
        CompletionExecutor executor = new CompletionExecutor((BigBang)bb, threadPool, bb.getHeartbeatCallback());
        try {
            executor.init();
            executor.start();
            for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
                HostedMethod method = (HostedMethod)pair.getLeft();
                executor.execute(ignore -> CodeInfoEncoder.verifyMethod(method, (CompilationResult)pair.getRight(), method.getCodeAddressOffset(), this.codeSizeFor(method), codeInfo));
            }
            executor.complete();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere("Failed to verify methods");
        }
        codeInfoEncoder.verifyFrameInfo(codeInfo);
        return true;
    }

    public abstract void patchMethods(DebugContext var1, RelocatableBuffer var2, ObjectFile var3);

    public abstract void writeCode(RelocatableBuffer var1);

    public void writeConstants(NativeImageHeapWriter writer, RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getByteBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> writer.writeReference(buffer, position, (JavaConstant)constant, "VMConstant: " + constant));
    }

    public abstract NativeImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer var1, ObjectFile var2, NativeImageCodeCache var3);

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        return new Path[]{tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix())};
    }

    public abstract List<ObjectFile.Symbol> getSymbols(ObjectFile var1);

    public void printCompilationResults() {
        String reportsPath = SubstrateOptions.reportsPath();
        ReportUtils.report((String)"compilation results", (String)reportsPath, (String)"universe_compilation", (String)"txt", writer -> this.printCompilationResults((PrintWriter)writer));
    }

    private void printCompilationResults(PrintWriter writer) {
        writer.println("--- compiled methods");
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CompilationResult result = (CompilationResult)pair.getRight();
            writer.format("%8d %5d %s: frame %d%n", method.getCodeAddressOffset(), result.getTargetCodeSize(), method.getQualifiedName(), result.getTotalFrameSize());
        }
        writer.println("--- vtables:");
        for (HostedType type : this.imageHeap.hUniverse.getTypes()) {
            for (int i = 0; i < type.getVTable().length; ++i) {
                CompilationResult comp;
                HostedMethod method = type.getVTable()[i];
                if (method == null || (comp = this.compilationResultFor(type.getVTable()[i])) == null) continue;
                writer.format("%d %s @ %d: %s = 0x%x%n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    private static class HostedFrameInfoCustomization
    extends FrameInfoEncoder.SourceFieldsFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private HostedFrameInfoCustomization() {
        }

        @Override
        protected Class<?> getDeclaringJavaClass(ResolvedJavaMethod method) {
            HostedType type = (HostedType)method.getDeclaringClass();
            assert (type.getWrapped().isReachable()) : "Declaring class not marked as used, therefore the DynamicHub is not initialized properly: " + method.format("%H.%n(%p)");
            return type.getJavaClass();
        }

        @Override
        protected boolean storeDeoptTargetMethod() {
            return false;
        }

        @Override
        protected void recordFrame(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
            super.recordFrame(method, infopoint, isDeoptEntry);
            if (isDeoptEntry) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput(infopoint);
                }
            }
        }

        @Override
        protected boolean includeLocalValues(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
            BytecodeFrame topFrame;
            if (isDeoptEntry || ((HostedMethod)method).compilationInfo.canDeoptForTesting()) {
                return true;
            }
            for (BytecodeFrame frame = topFrame = infopoint.debugInfo.frame(); frame != null; frame = frame.caller()) {
                if (!SubstrateCompilationDirectives.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, CompilationResult compilation, Infopoint infopoint) {
            return DeoptimizationUtils.isDeoptEntry((HostedMethod)method, compilation, infopoint);
        }
    }

    public static interface ReflectionMetadataEncoderFactory {
        public ReflectionMetadataEncoder create(SnippetReflectionProvider var1, CodeInfoEncoder.Encoders var2);
    }

    public static interface ReflectionMetadataEncoder
    extends EncodedReflectionMetadataSupplier {
        public static final Method getRoot = ReflectionUtil.lookupMethod(AccessibleObject.class, (String)"getRoot", (Class[])new Class[0]);

        public void addClassMetadata(MetaAccessProvider var1, HostedType var2, Class<?>[] var3);

        public void addReflectionFieldMetadata(MetaAccessProvider var1, HostedField var2, Field var3);

        public void addReflectionExecutableMetadata(MetaAccessProvider var1, HostedMethod var2, Executable var3, Object var4);

        public void addHeapAccessibleObjectMetadata(MetaAccessProvider var1, WrappedElement var2, AccessibleObject var3, boolean var4);

        public void addHidingFieldMetadata(AnalysisField var1, HostedType var2, String var3, HostedType var4, int var5);

        public void addHidingMethodMetadata(AnalysisMethod var1, HostedType var2, String var3, HostedType[] var4, int var5, HostedType var6);

        public void addReachableFieldMetadata(HostedField var1);

        public void addReachableExecutableMetadata(HostedMethod var1);

        public void addNegativeFieldQueryMetadata(HostedType var1, String var2);

        public void addNegativeMethodQueryMetadata(HostedType var1, String var2, HostedType[] var3);

        public void addNegativeConstructorQueryMetadata(HostedType var1, HostedType[] var2);

        public void encodeAllAndInstall();

        public static AccessibleObject getHolder(AccessibleObject accessibleObject) {
            try {
                AccessibleObject root = (AccessibleObject)getRoot.invoke((Object)accessibleObject, new Object[0]);
                return root == null ? accessibleObject : root;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

