/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.diagnostic;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.diagnostic.HostedHeapDump;
import com.oracle.svm.util.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class HostedHeapDumpFeature
implements InternalFeature {
    private List<String> phases;
    private Path dumpLocation;
    private String imageName;
    private String timeStamp;
    private int iteration;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        List validPhases = Stream.of(Phases.values()).map(Phases::getName).collect(Collectors.toList());
        List values = Options.DumpHeap.getValue().values();
        this.phases = new ArrayList<String>();
        for (String value : values) {
            if (validPhases.contains(value)) {
                this.phases.add(value);
                continue;
            }
            throw UserError.abort("Invalid value %s given for %s. Valid values are %s.", value, SubstrateOptionsParser.commandArgument(Options.DumpHeap, ""), StringUtil.joinSingleQuoted(validPhases));
        }
        return !this.phases.isEmpty();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        this.dumpLocation = HostedHeapDumpFeature.getDumpLocation();
        this.imageName = ReportUtils.extractImageName((String)config.getHostVM().getImageName());
        this.timeStamp = HostedHeapDumpFeature.getTimeStamp();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.phases.contains(Phases.DuringAnalysis.getName())) {
            this.dumpHeap(Phases.DuringAnalysis.getName() + "-" + this.iteration++);
        }
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        this.dumpHeap(Phases.AfterAnalysis);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        this.dumpHeap(Phases.BeforeCompilation);
    }

    public void beforeInlining() {
        this.dumpHeap(Phases.CompileQueueBeforeInlining);
    }

    public void afterInlining() {
        this.dumpHeap(Phases.CompileQueueAfterInlining);
    }

    public void compileQueueAfterCompilation() {
        this.dumpHeap(Phases.CompileQueueAfterCompilation);
    }

    private void dumpHeap(Phases phase) {
        if (this.phases.contains(phase.getName())) {
            this.dumpHeap(phase.getName());
        }
    }

    private void dumpHeap(String reason) {
        String outputFile = this.dumpLocation.resolve(this.imageName + "-" + reason + "-" + this.timeStamp + ".hprof").toString();
        System.out.println("Dumping heap " + reason.replace("-", " ") + " to " + outputFile);
        HostedHeapDump.take(outputFile);
    }

    private static Path getDumpLocation() {
        try {
            Path folder = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "dumps").toAbsolutePath();
            return Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Error("Cannot create heap dumps directory.", e);
        }
    }

    private static String getTimeStamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        return LocalDateTime.now().format(formatter);
    }

    static enum Phases {
        DuringAnalysis("during-analysis"),
        AfterAnalysis("after-analysis"),
        BeforeCompilation("before-compilation"),
        CompileQueueBeforeInlining("compile-queue-before-inlining"),
        CompileQueueAfterInlining("compile-queue-after-inlining"),
        CompileQueueAfterCompilation("compile-queue-after-compilation");

        final String name;

        private Phases(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DumpHeap = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());

        Options() {
        }
    }
}

