/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.hosted.code.CFunctionPointerCallStubMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.nativeimage.ImageSingletons;

public final class CFunctionPointerCallStubSupport {
    private AnalysisUniverse universe;
    private final Map<AnalysisMethod, AnalysisMethod> methodToStub = new ConcurrentHashMap<AnalysisMethod, AnalysisMethod>();

    static void initialize(AnalysisUniverse universe) {
        ImageSingletons.add(CFunctionPointerCallStubSupport.class, (Object)new CFunctionPointerCallStubSupport(universe));
    }

    public static CFunctionPointerCallStubSupport singleton() {
        return (CFunctionPointerCallStubSupport)ImageSingletons.lookup(CFunctionPointerCallStubSupport.class);
    }

    private CFunctionPointerCallStubSupport(AnalysisUniverse universe) {
        this.universe = universe;
    }

    public boolean isStub(AnalysisMethod method) {
        return this.methodToStub.containsValue(method);
    }

    public AnalysisMethod getOrCreateStubForMethod(AnalysisMethod method) {
        assert (!this.isStub(method));
        return this.methodToStub.computeIfAbsent(method, m -> {
            assert (!this.universe.sealed());
            CFunctionPointerCallStubMethod stub = CFunctionPointerCallStubMethod.create(method);
            return this.universe.lookup((JavaMethod)stub);
        });
    }
}

