/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;

class CodeBreakdownProvider {
    private final Map<String, Long> codeBreakdown;

    CodeBreakdownProvider(Collection<CompileQueue.CompileTask> compilationTasks) {
        HashMap<String, Long> nameToSizeMap = new HashMap<String, Long>();
        for (CompileQueue.CompileTask task : compilationTasks) {
            String key = null;
            Class<?> javaClass = task.method.getDeclaringClass().getJavaClass();
            Module module = javaClass.getModule();
            if (module.isNamed()) {
                key = module.getName();
                if ("org.graalvm.nativeimage.builder".equals(key)) {
                    key = "svm.jar (Native Image)";
                }
            } else {
                key = CodeBreakdownProvider.findJARFile(javaClass);
                if (key == null) {
                    key = CodeBreakdownProvider.findPackageOrClassName(task.method);
                }
            }
            nameToSizeMap.merge(key, Long.valueOf(task.result.getTargetCodeSize()), Long::sum);
        }
        this.codeBreakdown = Collections.unmodifiableMap(nameToSizeMap);
    }

    public static Map<String, Long> get() {
        return ((CodeBreakdownProvider)ImageSingletons.lookup(CodeBreakdownProvider.class)).codeBreakdown;
    }

    private static String findJARFile(Class<?> javaClass) {
        String path;
        CodeSource codeSource = javaClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null && (path = codeSource.getLocation().getPath()).endsWith(".jar")) {
            return path.substring(Math.max(path.lastIndexOf(47) + 1, path.lastIndexOf(92) + 1));
        }
        return null;
    }

    private static String findPackageOrClassName(HostedMethod method) {
        String qualifier = method.format("%H");
        int lastDotIndex = qualifier.lastIndexOf(46);
        if (lastDotIndex > 0) {
            qualifier = qualifier.substring(0, lastDotIndex);
        }
        return qualifier;
    }
}

