/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.util.Collections;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class UserError {
    public static UserException abort(String format, Object ... args) {
        throw new UserException(String.format(format, UserError.formatArguments(args)));
    }

    public static UserException abort(Throwable cause, String format, Object ... args) {
        throw (UserException)new UserException(String.format(format, UserError.formatArguments(args))).initCause(cause);
    }

    public static void guarantee(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw UserError.abort(format, args);
        }
    }

    static Object[] formatArguments(Object ... args) {
        return VMError.formatArguments(args);
    }

    public static UserException abort(Iterable<String> messages) {
        throw new UserException(messages);
    }

    public static UserException invalidOptionValue(OptionKey<?> option, String value, String reason) {
        return UserError.abort("Invalid option '%s'. %s.", SubstrateOptionsParser.commandArgument(option, value), reason);
    }

    public static UserException invalidOptionValue(OptionKey<?> option, Boolean value, String reason) {
        return UserError.invalidOptionValue(option, value != false ? "+" : "-", reason);
    }

    public static UserException invalidOptionValue(OptionKey<?> option, Number value, String reason) {
        return UserError.invalidOptionValue(option, String.valueOf(value), reason);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class UserException
    extends Error {
        static final long serialVersionUID = 75431290632980L;
        private final Iterable<String> messages;

        protected UserException(String msg) {
            this(Collections.singletonList(msg));
        }

        protected UserException(Iterable<String> messages) {
            super(String.join((CharSequence)System.lineSeparator(), messages));
            this.messages = messages;
        }

        public Iterable<String> getMessages() {
            return this.messages;
        }
    }
}

