/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.heap.AbstractMXBean;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import sun.management.Util;

public abstract class AbstractMemoryPoolMXBean
extends AbstractMXBean
implements MemoryPoolMXBean {
    private final String name;
    private final String[] managerNames;
    protected final UninterruptibleUtils.AtomicUnsigned peakUsage = new UninterruptibleUtils.AtomicUnsigned();
    private static final UnsignedWord UNDEFINED = (UnsignedWord)WordFactory.zero();
    protected UnsignedWord initialValue = UNDEFINED;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected AbstractMemoryPoolMXBean(String name, String ... managerNames) {
        this.name = name;
        this.managerNames = managerNames;
    }

    UnsignedWord getInitialValue() {
        if (this.initialValue.equal(UNDEFINED)) {
            this.initialValue = this.computeInitialValue();
        }
        return this.initialValue;
    }

    abstract UnsignedWord computeInitialValue();

    abstract UnsignedWord getMaximumValue();

    abstract void beforeCollection();

    abstract void afterCollection();

    MemoryUsage memoryUsage(UnsignedWord usedAndCommitted) {
        return this.memoryUsage(usedAndCommitted, usedAndCommitted);
    }

    MemoryUsage memoryUsage(UnsignedWord used, UnsignedWord committed) {
        long max = UnsignedUtils.max(this.getMaximumValue(), UnsignedUtils.max(used, committed)).rawValue();
        return new MemoryUsage(this.getInitialValue().rawValue(), used.rawValue(), committed.rawValue(), max);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getMemoryManagerNames() {
        return Arrays.copyOf(this.managerNames, this.managerNames.length);
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=MemoryPool,name=" + this.name);
    }

    @Override
    public MemoryType getType() {
        return MemoryType.HEAP;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isUsageThresholdSupported() {
        return false;
    }

    @Override
    public long getUsageThreshold() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public void setUsageThreshold(long l) {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public boolean isUsageThresholdExceeded() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public long getUsageThresholdCount() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return false;
    }

    @Override
    public long getCollectionUsageThreshold() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public void setCollectionUsageThreshold(long l) {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public long getCollectionUsageThresholdCount() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public void resetPeakUsage() {
        this.peakUsage.set((UnsignedWord)WordFactory.zero());
    }

    void updatePeakUsage(UnsignedWord value) {
        UnsignedWord current;
        while (value.aboveThan(current = (UnsignedWord)this.peakUsage.get()) && !this.peakUsage.compareAndSet(current, value)) {
        }
    }
}

